//
//  RTCSettingContext.h
//  BaiduRtcRoom
//
//  Created by zhifan zhang on 2022/7/7.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>
#import <BaiduRtcRoom/BaiduRtcRoomApiDefines.h>

NS_ASSUME_NONNULL_BEGIN

@interface RTCSettingContext : NSObject

#pragma mark - Media Control

@property(nonatomic, copy) NSNumber *usingFrontCamera;
@property(nonatomic, copy) NSNumber *videoBgPushMode;
@property (nonatomic, copy) NSNumber *cameraAutoUpdateOrientation;
@property (nonatomic, copy) NSNumber *cameraOutputOrientation;

#pragma mark - Stream

@property(nonatomic) BOOL hasVideo;
@property(nonatomic) BOOL hasAudio;
@property(nonatomic) BOOL hasRemoteAudio; // whether subscribe remote audio
@property(nonatomic) BOOL hasRemoteVideo; // whether subscribe remote video
@property(nonatomic) BOOL isAutoPublish; // auto publish mode
@property(nonatomic) BOOL isAutoSubscribe; // auto/manual subscribe mode
@property(nonatomic) BOOL isVideoPullDemote;

#pragma mark - Codec

@property(nonatomic, copy) RtcVideoBaseParams *videoCaptureParams;
@property(nonatomic, copy) RtcVideoEncodeParams *_Nullable videoEncodeParams;
@property(nonatomic, assign) RtcAudioEncodeType audioCodecType;
@property(nonatomic, readonly) NSString *audioCodecName;
@property(nonatomic, copy) NSString *subscribeMode;
@property(nonatomic, copy) NSNumber *subscribeCount;

- (void)setMediaInfo:(NSString *) mediaInfo;
#pragma mark - Screen Share

@property(nonatomic, copy) RtcVideoEncodeParams *_Nullable screenEncodeParams;

- (NSString *)defaultScreenShareVideoResolutionSetting;
- (NSNumber *)defaultScreenShareVideoFps;
- (NSNumber *)defaultScreenShareVideoBitrate;

#pragma mark - Other
/** 当前角色 */
@property(nonatomic) BRTCRoleType roleType;
/** 标记当前正在切换角色 */
@property(nonatomic) BOOL switchRoleIng;
@property(nonatomic) BOOL enablePruneSignal;
@property(nonatomic) BOOL isOnlineMode;
@property(nonatomic) BOOL logQualityMonitor;
@property(nonatomic) BOOL logWeakNetQualityReport;

- (NSString *)getVideoCodec;
@end

NS_ASSUME_NONNULL_END
