//
//  UserRemoteManager.m
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/11/5.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import "UserRemoteManager.h"

@interface UserRemoteManager () <RTCRemoteVideoViewDelegate>
@property(nonatomic, strong) NSMutableArray<RTCRemoteVideoViewInfo *> *remoteViewsGroup;
@property (nonatomic, strong) RTCRemoteVideoViewInfo *shareScreenInfo;
@end

@implementation UserRemoteManager

+ (instancetype)instance {
    static UserRemoteManager *_instanceSingleton = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _instanceSingleton = [[super allocWithZone:NULL] init];
        _instanceSingleton.videoViewDelegate =nil;
    });
    return _instanceSingleton;
}

- (NSMutableArray *)remoteViewsGroup {
    if (!_remoteViewsGroup) {
        _remoteViewsGroup = [[NSMutableArray alloc] init];
    }
    return _remoteViewsGroup;
}

- (void)remoteAllRemove {
    if (_remoteViewsGroup) {
        [_remoteViewsGroup removeAllObjects];
    }
}

- (void)remoteUserJoin:(NSInteger)userId {
    
    for (int i = 0; i < self.remoteViewsGroup.count; i++) {
        RTCRemoteVideoViewInfo *videoInfo = self.remoteViewsGroup[i];
        if (videoInfo.userId ==  userId) {
            return;
        }
    }
    
    RTCRemoteVideoViewInfo *remoteVideoInfo1 = [self newVideoViewInfo];
    remoteVideoInfo1.userId = userId;
    [self.remoteViewsGroup addObject:remoteVideoInfo1];
}

- (void)remoteUserLeave:(NSInteger)userId {
    for (int i = 0; i < self.remoteViewsGroup.count; i++) {
        RTCRemoteVideoViewInfo *videoInfo = self.remoteViewsGroup[i];
        if (videoInfo.userId ==  userId) {
            [videoInfo.videoView.videoView removeFromSuperview];
            [videoInfo.userInfoView removeFromSuperview];
            [self.remoteViewsGroup removeObjectAtIndex:i];
        }
    }
}

- (RTCRemoteVideoViewInfo *)remoteUserQuery:(NSInteger)userId {
    for (RTCRemoteVideoViewInfo *rrVV in self.remoteViewsGroup) {
        if (rrVV.userId == userId) {
            return  rrVV;
        }
    }
    return  nil;
}

- (void)remoteUserSubStatus:(NSInteger)userId subscribe:(BOOL)boSub {
    for (RTCRemoteVideoViewInfo *rrVV in self.remoteViewsGroup) {
        if (rrVV.userId == userId) {
            rrVV.isSubScribed = boSub;
            break;
        }
    }
}

/**   reloadView
 */

- (void)remoteUserViewChangeed:(UIView*)remoteView size:(CGSize)videoResolution {
    
}

- (NSArray *)remoteSubScribedUsers {
    NSMutableArray *arrMuArr = [[NSMutableArray alloc] init];
    for (RTCRemoteVideoViewInfo *rrvv in self.remoteViewsGroup) {
        if (rrvv.isSubScribed) {
            [arrMuArr addObject:rrvv];
        }
    }
    return [NSArray arrayWithArray:arrMuArr];
}
- (NSArray*)remoteAllUsers {
    return [NSArray arrayWithArray:self.remoteViewsGroup];
}

- (NSUInteger)remoteSubscribeNumers {
    NSUInteger subScribe = 0;
    for (RTCRemoteVideoViewInfo *rrVV in self.remoteViewsGroup) {
        if (rrVV.isSubScribed) {
            subScribe ++;
        }
    }
    return subScribe;
}

- (RTCRemoteVideoViewInfo *)newVideoViewInfo {
    UIImageView *audioBgImgView = [[UIImageView alloc] initWithFrame:CGRectZero];
    [audioBgImgView setImage:[UIImage imageNamed:@"default_photo.png"]];

    RTCRemoteVideoView *remoteVideoView1 = [[RTCRemoteVideoView alloc] initWithDelegate:self];
    RTCVideoUserInfoView *userInfoView = [[RTCVideoUserInfoView alloc] initWithFrame:CGRectMake(0, 0, 200, 40)];
    [remoteVideoView1.videoView addSubview:userInfoView];
    [remoteVideoView1.videoView addSubview:audioBgImgView];
    
    audioBgImgView.autoresizingMask = UIViewAutoresizingFlexibleLeftMargin|UIViewAutoresizingFlexibleWidth|UIViewAutoresizingFlexibleRightMargin|UIViewAutoresizingFlexibleTopMargin|UIViewAutoresizingFlexibleHeight|UIViewAutoresizingFlexibleBottomMargin;
    
    RTCRemoteVideoViewInfo *remoteVideoInfo1 = [[RTCRemoteVideoViewInfo alloc] init];
    remoteVideoInfo1.videoView = remoteVideoView1;
    remoteVideoInfo1.userInfoView = userInfoView;
    remoteVideoInfo1.defaultImageView = audioBgImgView;
    
    return remoteVideoInfo1;
}

#pragma mark - RTCEAGLVideoViewDelegate
- (void)remoteVideoView:(RTCRemoteVideoView *)videoView didChangeVideoSize:(CGSize)size {
//    if (self.isMultiPersons && size.width > 0 && size.height > 0) {

    RTCRemoteVideoViewInfo * rrvvInfo =  [[UserRemoteManager instance] remoteUserQuery:videoView.userId];
    if (!rrvvInfo && self.shareScreenInfo.videoView == videoView) {
        rrvvInfo = self.shareScreenInfo;
    }
    rrvvInfo.defaultImageView.hidden = YES;
    if (self.videoViewDelegate) {
        [self.videoViewDelegate remoteVideoView:videoView didChangeVideoSize:size];
    }
}

@end
