//
//  UserRemoteManager.h
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/11/5.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>
#import <BaiduRtcRoom/BaiduRtcRoom.h>
#import "RTCVideoCallView.h"

NS_ASSUME_NONNULL_BEGIN
@class RTCVideoUserInfoView;

@interface UserRemoteManager : NSObject

@property (nonatomic, weak) id <RTCRemoteVideoViewDelegate> videoViewDelegate;

/**
 * Returns single object.
 */
+ (instancetype)instance;

/**
 *  userAdd
 */
- (void)remoteUserJoin:(NSInteger)userId;

/**
 *  userRemove
 */
- (void)remoteUserLeave:(NSInteger)userId;

/**
 *  queryByUserId
 */
- (RTCRemoteVideoViewInfo *)remoteUserQuery:(NSInteger)userId;

/**
 *    updatePub/Scri status
 */
- (void)remoteUserSubStatus:(NSInteger)userId subscribe:(BOOL)boSub;

/**   reloadView
 */

- (void)remoteUserViewChangeed:(UIView *)remoteView size:(CGSize)videoResolution;

/** query some users
 */
- (NSArray *)remoteAllUsers;

- (NSUInteger)remoteSubscribeNumers;

- (NSArray *)remoteSubScribedUsers;

/**
 *  remoteAllRemove
 */
- (void)remoteAllRemove;


@end

NS_ASSUME_NONNULL_END
