//
//  RTCVideoCallView.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef RTCVideoCallView_h
#define RTCVideoCallView_h

#import <UIKit/UIKit.h>
#import "BDCloudRTCBaseDefine.pch"
#import <BaiduRtcRoom/BaiduRtcRoom.h>

@class RTCVideoCallView;
@class RTCVideoUserInfoView;
@protocol BaiduRtcBeautyManager;

@interface RtcViewLayoutInfo : NSObject
@property (nonatomic, assign) BOOL isRemoved;
@property (nonatomic, assign) BOOL isUesed;
@property (nonatomic, assign) CGRect viewFrame;

@property (nonatomic, strong) RTCRemoteVideoView *remoteVideoView;
@end

@interface RTCRemoteVideoViewInfo : NSObject
@property(nonatomic, strong) RTCRemoteVideoView *videoView;
@property(nonatomic, assign) BOOL isSubScribed;
@property(nonatomic, strong) RTCVideoUserInfoView *userInfoView;
@property(nonatomic, strong) UIImageView * defaultImageView;
@property(nonatomic, assign) NSInteger userId;
@end

@interface RTCVideoUserInfoView : UIView
- (void)setupUserId:(NSInteger)userId;
@end



@protocol RTCVideoCallViewDelegate <NSObject>
//Called when the micphone switch button is pressed.
- (void)videoCallViewDidMuteMicphone:(RTCVideoCallView *)view;

// Called when the camera switch button is pressed.
- (void)videoCallViewDidSwitchCamera:(RTCVideoCallView *)view;

// Called when closing or openning camera.
- (void)videoCallViewDidMuteCamera:(RTCVideoCallView *)view mute:(BOOL)mute;

// Called when the route change button is pressed.
- (void)videoCallViewDidChangeRoute:(RTCVideoCallView *)view;

// Called when the hangup button is pressed.
- (void)videoCallViewDidHangup:(RTCVideoCallView *)view;

//called when view disappear or  appear
- (void)videoCallViewDidRemoteviewDisappear:(BOOL)disappear remoteUid:(NSString*)userId;

//called when view disappear or  appear
- (void)videoCallAudoDidRemoteviewDisappear:(BOOL)disappear remoteUid:(NSString*)userId;

@end


// Video call view that shows local and remote video, provides a label to
// display status, and also a hangup button.
@interface RTCVideoCallView : UIView
@property(nonatomic, readonly) UILabel *roomInfoLabel;
@property(nonatomic, readonly) UILabel *statusLabel;
//add new parameters for local and remote video view
@property(nonatomic, strong) RTCLocalVideoView *localVideoView;
@property(nonatomic, strong) RTCRemoteVideoView *remoteVideoView;

@property(nonatomic, weak) id<RTCVideoCallViewDelegate> delegate;

- (instancetype)initWithFrame:(CGRect)frame
                      isWatch:(BOOL)isWatch
                          uid:(NSInteger)uid
                   sdkVersion:(NSString*)sdkVersion;

- (void)updateSubView:(RTCRemoteVideoView*)remoteView
                  uid:(NSInteger)userID
                  add:(BOOL)boAdd;

- (void)updateRouteChangeStatus:(BOOL)isLoundSpeaker;


@end

#endif /* RTCVideoCallView_h */
