//
//  RTCMainViewController.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCMainViewController.h"
#import <BaiduRtcRoom/BaiduRtcRoom.h>
#import "RTCMainView.h"
#import "RTCVideoCallViewController.h"
#import "BDCloudRTCBaseDefine.pch"
static NSString *const kUserIdKey = @"rtc_baidu_room_user_id";
static NSString *const kRoomNameKey = @"rtc_baidu_room_name";


@interface RTCMainViewController () <RTCMainViewDelegate, RTCVideoCallViewControllerDelegate>

@end

@implementation RTCMainViewController {
    RTCMainView *_mainView;
    NSUserDefaults *_storage;
}

- (void)dealloc {
    NSLog(@"RTCMainViewController dealloc");
}

- (void)viewDidLoad {
    [super viewDidLoad];

    //disable rest screen
    [[UIApplication sharedApplication] setIdleTimerDisabled:YES];

    if (@available(iOS 13.0, *)) {
        self.navigationController.navigationBar.backgroundColor = [UIColor systemBackgroundColor];
    }
}

- (void)loadView {
    _storage = [NSUserDefaults standardUserDefaults];
    _mainView = [[RTCMainView alloc] initWithFrame:CGRectZero];

    NSString *uid = [_storage objectForKey:kUserIdKey];
    NSString *room = [_storage objectForKey:kRoomNameKey];
    if ([uid length] > 0 && [room length] > 0) {
        [_mainView setParams:uid roomName:room];
    }
    
    _mainView.delegate = self;
    self.view = _mainView;
}


#pragma mark - RTCMainViewDelegate

- (void)mainView:(RTCMainView *)mainView
    didInputRoom:(NSString *)room
          userId:(NSString *)userId
         isWatch:(BOOL)isWatch {
    if (!room.length) {
        [self showAlertWithMessage:@"房间号不能为空!!!"];
        return;
    }
    if (!userId.length) {
        [self showAlertWithMessage:@"uid不能为空!!!"];
        return;
    }
    
    if ([BDCloudDefaultRTCAppToken length] <= 0 || [BDCloudDefaultRTCAppID length] <= 0) {
        [self showAlertWithMessage:@"请检查 Appid & Token"];
        return;
    }
    
    if ([room length] > 0 && [userId length] > 0) {
        [_storage setObject:userId forKey:kUserIdKey];
        [_storage setObject:room forKey:kRoomNameKey];
        [_storage synchronize];
    }
    
    
    // Trim whitespaces.
    NSCharacterSet *whitespaceSet = [NSCharacterSet whitespaceCharacterSet];
    NSString *trimmedRoom = [room stringByTrimmingCharactersInSet:whitespaceSet];
    
    RTCVideoCallViewController *videoCallViewController =
    [[RTCVideoCallViewController alloc] initForRoom:trimmedRoom
                                             userId:userId
                                            isWatch:isWatch
                                           delegate:self];
    videoCallViewController.modalPresentationStyle = UIModalPresentationFullScreen;
    [self presentViewController:videoCallViewController
                       animated:YES
                     completion:nil];
}

#pragma mark - RTCVideoCallViewControllerDelegate

- (void)viewControllerDidFinish:(RTCVideoCallViewController *)viewController {
    if (![viewController isBeingDismissed]) {
        NSLog(@"Dismissing VC");
        [self dismissViewControllerAnimated:YES completion:^{
        }];
    }
}

#pragma mark - Private

- (void)presentViewControllerAsModal:(UIViewController *)viewController {
    [self presentViewController:viewController animated:YES completion:nil];
}

- (void)showAlertWithMessage:(NSString*)message {
    UIAlertController *alert =
    [UIAlertController alertControllerWithTitle:nil
                                        message:message
                                 preferredStyle:UIAlertControllerStyleAlert];
    
    UIAlertAction *defaultAction = [UIAlertAction actionWithTitle:@"OK"
                                                            style:UIAlertActionStyleDefault
                                                          handler:^(UIAlertAction *action){
                                                          }];
    
    [alert addAction:defaultAction];
    [self presentViewController:alert animated:YES completion:nil];
}

@end
