//
//  RTCMainView.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//


#import "RTCMainView.h"
#import <sys/utsname.h>
#include "BDCloudRTCBaseDefine.pch"

static CGFloat const kRoomTextFieldHeight = 40;
static CGFloat const kRoomTextFieldMargin = 8;

// Helper view that contains a text field and a clear button.
@interface RTCTextField : UIView <UITextFieldDelegate>
@property(nonatomic, readonly) NSString *roomText;
@end

@implementation RTCTextField {
    UITextField *_roomText;
    UIView *_roomTextUnderLine;
}

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        _roomText = [[UITextField alloc] initWithFrame:CGRectZero];
        _roomText.borderStyle = UITextBorderStyleNone;
        _roomText.font = [UIFont fontWithName:@"Roboto" size:12];
        _roomText.placeholder = @"请输入房间号";
        _roomText.autocorrectionType = UITextAutocorrectionTypeNo;
        _roomText.autocapitalizationType = UITextAutocapitalizationTypeNone;
        _roomText.clearButtonMode = UITextFieldViewModeAlways;
        _roomText.delegate = self;
        [self addSubview:_roomText];

        // Give rounded corners and a light gray border.
//        self.layer.borderWidth = 1;
//        self.layer.borderColor = [[UIColor lightGrayColor] CGColor];
//        self.layer.cornerRadius = 2;
    }
    return self;
}

- (void)dealloc {
    
}

- (void)layoutSubviews {
    _roomText.frame =
    CGRectMake(kRoomTextFieldMargin, 0, CGRectGetWidth(self.bounds) - kRoomTextFieldMargin,
               kRoomTextFieldHeight);
    _roomTextUnderLine = [[UIView alloc]initWithFrame:CGRectMake(0,
                                                                 _roomText.frame.size.height - 2,
                                                                 _roomText.frame.size.width, 1)];
    _roomTextUnderLine.backgroundColor = [UIColor grayColor];
    [_roomText addSubview:_roomTextUnderLine];
}

- (CGSize)sizeThatFits:(CGSize)size {
    size.height = kRoomTextFieldHeight;
    return size;
}

- (NSString *)roomText {
    return _roomText.text;
}

- (void)setRoomText:(NSString *)roomText {
    _roomText.text = roomText;
}

- (void)setPlaceHolder:(NSString *)ph {
    _roomText.placeholder = ph;
}

- (void)setTextFieldEnable:(BOOL)bEnable {
    _roomText.enabled = bEnable;
}

#pragma mark - UITextFieldDelegate

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    // There is no other control that can take focus, so manually resign focus
    // when return (Join) is pressed to trigger |textFieldDidEndEditing|.
    if (_roomText.text.length != 0) {
        _roomTextUnderLine.backgroundColor = [UIColor systemBlueColor];
    } else {
        _roomTextUnderLine.backgroundColor = [UIColor grayColor];
    }
    [textField resignFirstResponder];
    return YES;
}
@end

@interface RTCMainView () <UITextFieldDelegate>

@end

@implementation RTCMainView {
    RTCTextField *_roomText;
    RTCTextField *_userId;
    UILabel *_watchLable;
    UISwitch *_isWatch;
    UILabel *_appIdLabel;
    UITextField *_appId;
    UILabel *_tokenStrLabel;
    UITextField *_tokenStr;
    
    UIButton *_startCallButton;

    UIImage *_image;
    UIImageView *_logoImageView;
    UILabel *_welcomLabel;
    UILabel *_entryRoomLabel;
    UILabel *_serviceProviderLabel;
}

@synthesize delegate = _delegate;

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        _logoImageView = [[UIImageView alloc] init];
        [self addSubview:_logoImageView];

        _welcomLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _welcomLabel.textAlignment = NSTextAlignmentCenter;
        _welcomLabel.text = @"欢迎来到百度云RTC";
        _welcomLabel.font = [UIFont fontWithName:@"PingFangSC-Medium" size:30];
        _welcomLabel.textColor = [UIColor colorWithRed:68/255.0 green:73/255.0 blue:90/255.0 alpha:1/1.0];
        [self addSubview:_welcomLabel];


        _entryRoomLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _entryRoomLabel.textAlignment = NSTextAlignmentCenter;
        _entryRoomLabel.text = @"进入房间后开始你的旅程";
        _entryRoomLabel.font = [UIFont fontWithName:@"PingFangSC-Regular" size:15];
        _entryRoomLabel.textColor = [UIColor colorWithRed:68/255.0 green:73/255.0 blue:90/255.0 alpha:1/1.0];
        [self addSubview:_entryRoomLabel];

        _serviceProviderLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _serviceProviderLabel.text = @"百度云提供计算服务";
        _serviceProviderLabel.font = [UIFont fontWithName:@"PingFangSC-Regular" size:16];
        _serviceProviderLabel.textColor = [UIColor colorWithRed:210/255.0 green:211/255.0 blue:219/255.0 alpha:1/1.0];
        [self addSubview:_serviceProviderLabel];

        _roomText = [[RTCTextField alloc] initWithFrame:CGRectZero];
        [self addSubview:_roomText];
        _roomText.roomText = @"654";
        
        _userId = [[RTCTextField alloc] initWithFrame:CGRectZero];
        [_userId setPlaceHolder:@"输入用户ID，同一房间ID须唯一"];
        [self addSubview:_userId];
        
        _watchLable = [[UILabel alloc] initWithFrame:CGRectZero];
        _watchLable.textAlignment = NSTextAlignmentCenter;
        _watchLable.text = @"1v1手表场景";
        _watchLable.font = [UIFont fontWithName:@"PingFangSC-Regular" size:15];
        _watchLable.textColor = [UIColor colorWithRed:68/255.0 green:73/255.0 blue:90/255.0 alpha:1/1.0];
        [self addSubview:_watchLable];

        _isWatch = [[UISwitch alloc] initWithFrame:CGRectZero];
        [self addSubview:_isWatch];
        [_isWatch addTarget:self
                    action:@selector(onSwitchChanged:)
            forControlEvents:UIControlEventValueChanged];
        
        
        _startCallButton = [UIButton buttonWithType:UIButtonTypeCustom];

        NSString *deviceType = [self judgeDevice];
        if ([deviceType isEqualToString:@"iPhone X"]
             || [deviceType isEqualToString:@"iPhone XR"]
             || [deviceType isEqualToString:@"iPhone XS"]
             || [deviceType isEqualToString:@"iPhone XS MAX"]) {
            _startCallButton.layer.cornerRadius = 25.0;
        } else {
            _startCallButton.layer.cornerRadius = 20.0;
        }
        _startCallButton.layer.masksToBounds = YES;
        _startCallButton.titleLabel.adjustsFontSizeToFitWidth = YES;
        [_startCallButton setTitle:@"开始通话"
                          forState:UIControlStateNormal];

//        _startCallButton.titleLabel.font = controlFont;
        [_startCallButton addTarget:self
                             action:@selector(onStartCall:)
                   forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_startCallButton];


        if (@available(iOS 13.0, *)) {
            self.backgroundColor = [UIColor systemBackgroundColor];
        } else {
            self.backgroundColor = [UIColor whiteColor];
        }
    }
    
    return self;
}

- (void)layoutSubviews {
    CGRect bounds = self.bounds;
    CGSize bdsSize = bounds.size;
    CGFloat logImageViewX = bdsSize.width*523/kLayoutWidth;
    CGFloat logImageViewY = bdsSize.height*91.7/kLayoutHeight;
    CGFloat logImageViewW = bdsSize.width*196/kLayoutWidth;
    CGFloat logImageViewH = logImageViewW*222/196;
    _logoImageView.frame = CGRectMake(logImageViewX, logImageViewY, logImageViewW, logImageViewH);
    _image = [UIImage imageNamed:@"first_page_logo.png"];
    [_logoImageView setImage:_image];

    CGFloat welcomLabelX = bdsSize.width*165/kLayoutWidth;
    CGFloat welcomLabelY = bdsSize.height*443/kLayoutHeight;
    CGFloat welcomLabelW = bdsSize.width*912/kLayoutWidth;
    CGFloat welcomLabelH = welcomLabelW*140/912;
    _welcomLabel.frame = CGRectMake(welcomLabelX, welcomLabelY, welcomLabelW, welcomLabelH);

    CGFloat entryLabelX = bdsSize.width*343/kLayoutWidth;
    CGFloat entryLabelY = bdsSize.height*598/kLayoutHeight;
    CGFloat entryLabelW = bdsSize.width*556/kLayoutWidth;
    CGFloat entryLabelH = welcomLabelW*70/556;
    _entryRoomLabel.frame = CGRectMake(entryLabelX, entryLabelY, entryLabelW, entryLabelH);

    CGFloat roomTextX = bdsSize.width*97/kLayoutWidth;
    CGFloat roomTexMarginH = bdsSize.height*300*kLayoutHeightScale;
    CGFloat roomTextY = CGRectGetMaxY(_entryRoomLabel.frame) + roomTexMarginH;
    CGFloat roomTextW = bdsSize.width*1070/kLayoutWidth;
    CGFloat roomTextH = 50;
    _roomText.frame = CGRectMake(roomTextX, roomTextY, roomTextW, roomTextH);
    
    CGFloat userIdY = CGRectGetMaxY(_entryRoomLabel.frame) + roomTexMarginH - roomTextH;
    _userId.frame = CGRectMake(roomTextX, userIdY, roomTextW, roomTextH);

    
    CGFloat watchX = CGRectGetMinX(_roomText.frame) - 10;
    CGFloat watchY = CGRectGetMaxY(_roomText.frame) + bdsSize.height*10*kLayoutHeightScale;
    _watchLable.frame = CGRectMake(watchX, watchY, bdsSize.width*400/kLayoutWidth, welcomLabelW*70/556);

    _isWatch.frame = CGRectMake(bdsSize.width*1000/kLayoutWidth, watchY, bdsSize.width*100/kLayoutWidth, welcomLabelW*70/556);
    
    CGFloat _startCallBtnX = CGRectGetMinX(_roomText.frame);
    CGFloat _startCallBtnY = CGRectGetMaxY(_watchLable.frame) + bdsSize.height*179*kLayoutHeightScale;
    CGFloat _startCallBtnW = _roomText.frame.size.width;
    CGFloat _startCallBtnH = SCREEN_HEIGHT*140*kLayoutHeightScale;
    _startCallButton.frame = CGRectMake(_startCallBtnX,
                                        _startCallBtnY,
                                        _startCallBtnW,
                                        _startCallBtnH);
    [_startCallButton setBackgroundColor:[UIColor colorWithRed:77/255.0 green:102/255.0 blue:254/255.0 alpha:1/1.0]];

    CGFloat serviceProviderLabelX = bdsSize.width*383/kLayoutWidth;
    CGFloat serviceProviderLabelY = bdsSize.height*2070/kLayoutHeight;
    CGFloat serviceProviderLabelW = bdsSize.width*477/kLayoutWidth;
    CGFloat serviceProviderLabelH = welcomLabelW*69/477;
    _serviceProviderLabel.frame = CGRectMake(serviceProviderLabelX,
                                             serviceProviderLabelY,
                                             serviceProviderLabelW,
                                             serviceProviderLabelH);
}

- (void)setParams:(NSString *)uid roomName:(NSString *)roomName {
    [_roomText setRoomText:roomName];
    [_userId setRoomText:uid];
}


#pragma mark - Private
- (void)onStartCall:(id)sender {
    
    if (self.delegate && [self.delegate respondsToSelector:@selector(mainView:didInputRoom:userId:isWatch:)]) {
        [self.delegate mainView:self didInputRoom:_roomText.roomText userId:_userId.roomText isWatch:_isWatch.isOn];
    }
}

- (void)onSwitchChanged:(UISwitch *) sender {
    
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    // There is no other control that can take focus, so manually resign focus
    // when return (Join) is pressed to trigger |textFieldDidEndEditing|.
    [textField resignFirstResponder];
    return YES;
}

- (NSString *)judgeDevice {
    struct utsname systemInfo;
    uname(&systemInfo);
    NSString*phoneType = [NSString stringWithCString: systemInfo.machine encoding:NSASCIIStringEncoding];

    if([phoneType  isEqualToString:@"iPhone1,1"])  return @"iPhone 2G";

    if([phoneType  isEqualToString:@"iPhone1,2"])  return @"iPhone 3G";

    if([phoneType  isEqualToString:@"iPhone2,1"])  return @"iPhone 3GS";

    if([phoneType  isEqualToString:@"iPhone3,1"])  return @"iPhone 4";

    if([phoneType  isEqualToString:@"iPhone3,2"])  return @"iPhone 4";

    if([phoneType  isEqualToString:@"iPhone3,3"])  return @"iPhone 4";

    if([phoneType  isEqualToString:@"iPhone4,1"])  return @"iPhone 4S";

    if([phoneType  isEqualToString:@"iPhone5,1"])  return @"iPhone 5";

    if([phoneType  isEqualToString:@"iPhone5,2"])  return @"iPhone 5";

    if([phoneType  isEqualToString:@"iPhone5,3"])  return @"iPhone 5c";

    if([phoneType  isEqualToString:@"iPhone5,4"])  return @"iPhone 5c";

    if([phoneType  isEqualToString:@"iPhone6,1"])  return @"iPhone 5s";

    if([phoneType  isEqualToString:@"iPhone6,2"])  return @"iPhone 5s";

    if([phoneType  isEqualToString:@"iPhone7,1"])  return @"iPhone 6 Plus";

    if([phoneType  isEqualToString:@"iPhone7,2"])  return @"iPhone 6";

    if([phoneType  isEqualToString:@"iPhone8,1"])  return @"iPhone 6s";

    if([phoneType  isEqualToString:@"iPhone8,2"])  return @"iPhone 6s Plus";

    if([phoneType  isEqualToString:@"iPhone8,4"])  return @"iPhone SE";

    if([phoneType  isEqualToString:@"iPhone9,1"])  return @"iPhone 7";

    if([phoneType  isEqualToString:@"iPhone9,2"])  return @"iPhone 7 Plus";

    if([phoneType  isEqualToString:@"iPhone10,1"]) return @"iPhone 8";

    if([phoneType  isEqualToString:@"iPhone10,4"]) return @"iPhone 8";

    if([phoneType  isEqualToString:@"iPhone10,2"]) return @"iPhone 8 Plus";

    if([phoneType  isEqualToString:@"iPhone10,5"]) return @"iPhone 8 Plus";

    if([phoneType  isEqualToString:@"iPhone10,3"]) return @"iPhone X";

    if([phoneType  isEqualToString:@"iPhone10,6"]) return @"iPhone X";

    if([phoneType  isEqualToString:@"iPhone11,8"]) return @"iPhone XR";

    if([phoneType  isEqualToString:@"iPhone11,2"]) return @"iPhone XS";

    if([phoneType  isEqualToString:@"iPhone11,4"]) return @"iPhone XS Max";

    if([phoneType  isEqualToString:@"iPhone11,6"]) return @"iPhone XS Max";
    return nil;
}

@end

