//
//  RTCMainView.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef RTCMainView_h
#define RTCMainView_h
#import <UIKit/UIKit.h>

@class RTCMainView;

@protocol RTCMainViewDelegate <NSObject>

- (void)mainView:(RTCMainView *)mainView
    didInputRoom:(NSString *)room
          userId:(NSString *)userId
         isWatch:(BOOL)isWatch;

@end

// The main view of AppRTCMobile. It contains an input field for entering a room
// name on apprtc to connect to.
@interface RTCMainView : UIView

@property(nonatomic, weak) id<RTCMainViewDelegate> delegate;
// Updates the audio loop button as needed.
@property(nonatomic, assign) BOOL isAudioLoopPlaying;

@property(nonatomic, assign) BOOL isLastmileTesting;

- (void)setParams:(NSString *)uid roomName:(NSString *)roomName;
@end

#endif /* RTCMainView_h */
