//
//  RTCMediaRecorder.h
//  BaiduRtcRoom
//
//  Created by v_liyingna on 9/20/22.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>


NS_ASSUME_NONNULL_BEGIN

typedef NS_OPTIONS(NSUInteger, BRTCRecordOption) {
    BRTCRecordOptionNone  = 0,

    BRTCRecordMediaAudio = 1 << 0,
    BRTCRecordMediaVideo = 1 << 1,
    
    BRTCRecordStreamLocal  = 1 << 2,
    BRTCRecordStreamRemote = 1 << 3,
};

/// 录制媒体类型
typedef BRTCRecordOption BRTCMediaRecorderType;

extern BRTCMediaRecorderType const BRTCMediaRecorderTypeAudio;          // 本地录制 - 仅音频
extern BRTCMediaRecorderType const BRTCMediaRecorderTypeVideo;          // 本地录制 - 仅视频
extern BRTCMediaRecorderType const BRTCMediaRecorderTypeBoth;           // 本地录制 - 音视频

extern BRTCMediaRecorderType const BRTCMediaRecorderTypeRemoteAudio;    // 远端录制 - 仅音频
extern BRTCMediaRecorderType const BRTCMediaRecorderTypeRemoteVideo;    // 远端录制 - 仅视频
extern BRTCMediaRecorderType const BRTCMediaRecorderTypeRemoteBoth;     // 远端录制 - 音视频

extern BRTCMediaRecorderType const BRTCMediaRecorderTypeMixAudio;       // 混流录制 - 仅音频
extern BRTCMediaRecorderType const BRTCMediaRecorderTypeMixVideo;       // 混流录制 - 仅视频
extern BRTCMediaRecorderType const BRTCMediaRecorderTypeMixBoth;        // 混流录制 - 音视频

/// 混流录制的布局类型
/// @discussion 最多展示六路媒体流
typedef NS_ENUM(NSInteger, BRTCMediaMixType) {
    
    /**
     画中画：远端第一路视频是大画面，其余视频流是子画面，悬浮于画布底部从右到左依次平铺，高宽为画布 1/5，子画面内容适配填充。
     
     1 是本端, > 1 是远端。仅有一路时适配填充画布
     |--------|  |--------|
     |        |  |        |
     |   2    |  |   2    |
     |        |  |        |
     |     |--|  |--|--|--|
     |     |1 |  |4 |3 |1 |
     |-----|--|  |--|--|--|
     */
    BRTCMediaMixTypePip,
    
    /**
     主次平铺：远端第一路视频是大画面，高和画布相同，宽为画布 4/5。其余视频流是子画面，垂直排列于画布右侧从上到下依次平铺，高宽为画布 1/5，子画面内容适配填充。
     
     1 是本端, > 1 是远端。仅有一路时适配填充画布
     |------|-|  |------|-|
     |      |1|  |      |1|
     |      |-|  |      |-|
     |   2    |  |   2  |3|
     |        |  |      |-|
     |        |  |      |4|
     |--------|  |------|-|
     */
    BRTCMediaMixTypePas,
    
    /**
     平铺：本地视频和远端视频按从左到右从上到下按宫格形式依次平铺，高宽均分。
     
     1 是本端, > 1 是远端。仅有一路时适配填充画布
     |----|----|  |----|----|  |----|----|
     |    |    |  | 1  | 2  |  | 1  | 2  |
     |    |    |  |    |    |  |----|----|
     | 1  | 2  |  |----|----|  | 3  | 4  |
     |    |    |  | 3  |(4) |  |----|----|
     |    |    |  |    |    |  | 5  |(6) |
     |----|----|  |----|----|  |----|----|
     */
    BRTCMediaMixTypeTile,
};

typedef NS_ENUM (NSInteger, BRTCMediaRecorderContainerFormat) {
    BRTCMediaRecorderContainerFormat_MP4
};

typedef NS_ENUM (NSInteger, BRTCMediaRecorderState){
    BRTCMediaRecorderStateStop,
    BRTCMediaRecorderStateStart,
    BRTCMediaRecorderStateError
};

typedef NS_ENUM (NSInteger, BRTCMediaRecorderErrorCode){
    BRTCMediaRecorderErrorCode_Success = 0,
    BRTCMediaRecorderErrorCode_Started,                     ///< 已经开始录制，不能重复开始
    BRTCMediaRecorderErrorCode_FilePathNil,                 ///< 未配置文件存储路径
    BRTCMediaRecorderErrorCode_VideoProcessDisabled,        ///< 未开启视频处理，无法混流录制
    BRTCMediaRecorderErrorCode_RecorderInfoUpdateInterval,  ///< 更新间隔时间错误
    BRTCMediaRecorderErrorCode_InitAssertWriterFail,
    BRTCMediaRecorderErrorCode_AssertWriterStartFail,
    BRTCMediaRecorderErrorCode_OverTime,                    ///< 达到最长时长
    BRTCMediaRecorderErrorCode_Stoped,                      ///< /已经停止录制
    BRTCMediaRecorderErrorCode_Error
    
};

@interface BRTCAudioRecordParam: NSObject
@property (nonatomic, assign) int numberOfChannel;
@property (nonatomic, assign) int sampleRate; 
@property (nonatomic, assign) int audioBitrate; // unit: kbps
@end

@interface BRTCVideoRecordParam: NSObject
@property (nonatomic, assign) int videoFps;
@property (nonatomic, assign) int videoWidth;
@property (nonatomic, assign) int videoHeight;
@property (nonatomic, assign) int videoBitrate; // unit: kbps

@end

@interface BRTCMediaRecordParam : NSObject

//录制内容： 音频 视频 音视频
@property (nonatomic, assign) BRTCMediaRecorderType type;

/// 混流录制布局
@property (nonatomic, assign) BRTCMediaMixType mixType;

@property (nonatomic, strong) BRTCAudioRecordParam *audioParam;
@property (nonatomic, strong) BRTCVideoRecordParam *videoParam;
//存储路径
@property (nonatomic, copy) NSString *savePath;

//存储形式：aac:音频 mp4：视频/音视频
@property (nonatomic, assign) BRTCMediaRecorderContainerFormat format;

//最大录制时长，单位为毫秒，默认值为 120000。
@property (nonatomic, assign) NSInteger maxDurationMs;

//录制信息更新间隔，单位为毫秒，取值范围为 [1000,10000]。SDK 会根据设置 recorderInfoUpdateInterval 值触发 informationDidUpdated 回调，报告更新后的录制信息。
@property (nonatomic, assign) NSInteger recorderInfoUpdateInterval;

@end

@interface BRTCMediaRecorderInfo : NSObject
@property(nonatomic, copy) NSString *recorderFileName;
@property(nonatomic, assign) NSInteger durationMs;  //ms
@property(nonatomic, assign) float fileSize;  //kb
@end

@class BRTCMediaRecorder;
@protocol BRTCMediaRecorderDelegate <NSObject>
@optional
//录制状态回调
- (void)brtcMediaRecorder:(BRTCMediaRecorder* _Nonnull)recorder stateDidChanged:(BRTCMediaRecorderState)state error:(BRTCMediaRecorderErrorCode)error;

//录制信息更新
- (void)brtcMediaRecorder:(BRTCMediaRecorder* _Nonnull)recorder informationDidUpdated:(BRTCMediaRecorderInfo* _Nonnull)info;

@end

@interface BRTCMediaRecorder : NSObject

@property (nonatomic, assign, readonly) BRTCMediaRecorderState state;

- (void)setMediaRecorderDelegate:(id<BRTCMediaRecorderDelegate>)delegate;

- (int)startRecordWithParam:(BRTCMediaRecordParam *)param;
- (int)stopRecord;

@end

NS_ASSUME_NONNULL_END
