//
//  BaiduRtcRoomReplayKitExt.h
//  BaiduRtcRoom
//
//  Created by 曹士谦 on 2022/4/13.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreMedia/CoreMedia.h>
#import <ReplayKit/ReplayKit.h>
#import <BaiduRtcRoom/BaiduRtcRoom.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, BaiduRtcReplayKitStopReason) {
    
    // End from system control
    BaiduRtcReplayKitStopReasonSystemEnd,
    
    // End from host app
    BaiduRtcReplayKitStopReasonHostEnd,
    
    // Error occured during start sharing screen
    BaiduRtcReplayKitStopReasonStartError,
    
    // ReplayKit isn't started from host app
    BaiduRtcReplayKitStopReasonIncorrectStart,
};

@protocol BaiduRtcRoomReplayKitExtDelegate;

API_AVAILABLE(ios(11.0))
@interface BaiduRtcRoomReplayKitExt : NSObject

+ (instancetype)sharedInstance;

- (void)broadcastStartedWithAppGroup:(NSString *)appGroup delegate:(id<BaiduRtcRoomReplayKitExtDelegate>)delegate;
- (void)broadcastPaused;
- (void)broadcastResumed;
- (void)broadcastFinished;

- (void)processSampleBuffer:(CMSampleBufferRef)sampleBuffer bufferType:(RPSampleBufferType)buferType;

/// rtc instance for publishing screen streams
/// @discussion It's created after broadcastStartedWithAppGroup is called, dealloced after broadcasting is stopped.
@property (nonatomic, strong, readonly) BaiduRtcRoomApi *rtcRoom;
@property (nonatomic, weak) id<BaiduRtcRoomDelegate> roomDelegate;

@end

API_AVAILABLE(ios(11.0))
@protocol BaiduRtcRoomReplayKitExtDelegate <NSObject>

/// Called when screen sharing is stopped
/// @param replayKit replayKitExt
/// @param reason reason.
- (void)replayKitScreenShareStopped:(BaiduRtcRoomReplayKitExt *)replayKit reason:(BaiduRtcReplayKitStopReason)reason;

@optional

/// Called when rtc token is requried
/// @param appId appId
/// @param roomName roomName
/// @param userId userId
/// @param completin should be called when token is generated.
/// @discussion when you turns baidu rtc authentication on, you should implementation this method.
- (void)replayKitGetRtcTokenWithAppId:(NSString *)appId
                             roomName:(NSString *)roomName
                               userId:(NSInteger)userId
                           completion:(void (^)(NSString *tokenStr))completin;

@end

NS_ASSUME_NONNULL_END
