//
//  BRTCARFilter.h
//  BaiduRtcBeauty
//
//  Created by 曹士谦 on 2022/6/17.
//

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>
#import "BDMVExtensionFilterDefine.h"
#import "BDMVComplexFilterModel.h"
//#if __has_include(<BDCloudAVEffect/BDCloudAVEffect.h>)
//#import <BDCloudAVEffect/BDCloudAVEffect.h>
//#else
//#import "BDCloudAVEffect.h"
//#endif

NS_ASSUME_NONNULL_BEGIN

@protocol BRTCARFilter <NSObject>

- (void)setupAndStart;
- (void)stop;

/// 美化、美颜、滤镜、美妆某项能力是否被禁用
- (BDMVARFliterAdjustEnableState)adjustEnableState;

/// 启用流媒体基础美颜特效，包括磨皮、美白
- (void)applyBeautyBaseVideoFx;

/// 关闭流媒体基础美颜特效，包括磨皮、美白
- (void)disabledBeautyBaseVideoFx;

/// 调整基础美颜美白效果
/// @param level 美白效果
- (void)adjustBeautyWhiteLevel:(CGFloat)level;

/// 调整基础美颜磨皮效果
/// @param level 磨皮效果
- (void)adjustBeautyBlurLevel:(CGFloat)level;

/// 调整高级美颜大眼效果，请先确认是否开通对应权限
/// @param level 大眼效果
- (void)adjustBeautyEnlargingLevel:(CGFloat)level;

/// 调整高级美颜磨皮效果，请先确认是否开通对应权限。
/// @param level 磨皮效果
- (void)adjustBeautyThinningLevel:(CGFloat)level;

/// 滤镜统一接口
/// @param filterModel 滤镜模型
- (void)adjustBeautyFilter:(BDMVComplexFilterModel *)filterModel;

/// 美妆统一接口
/// @param makeupModel 美妆模型
- (void)adjustBeautyMakeup:(BDMVMakeupModel *)makeupModel;

/// 五官塑形统一接口
/// @param featuresType 五官枚举
/// @param value 五官塑形调整对象
- (void)adjustFeatures:(BDMVFeaturesModelType)featuresType value:(NSObject *)value;

/// 调整高级美颜l脸长效果，请先确认是否开通对应权限
/// @param level 脸长效果。
- (void)adjustBeautyFaceLengthLevel:(CGFloat)level;

/// 调整下巴
/// @param level 下巴长，下巴宽合并调节
- (void)adjustBeautyChin:(CGFloat)level;

/// 调整高级美颜眼睛长度效果，请先确认是否开通对应权限
/// @param level 眼睛长度效果。
- (void)adjustBeautyEyelengthLevel:(CGFloat)level;

/// 调整高级美颜鼻子宽度效果，请先确认是否开通对应权限
/// @param level 鼻子宽度效果
- (void)adjustBeautyNosebridgewidthLevel:(CGFloat)level;

/// 调整高级美颜眉头长度效果，请先确认是否开通对应权限
/// @param level 眉头长度效果
- (void)adjustBeautyBrowlengthLevel:(CGFloat)level;

/// 调整高级美颜嘴巴长度效果，请先确认是否开通对应权限
/// @param level 嘴巴长度效果
- (void)adjustBeautyMouthwidthLevel:(CGFloat)level;

/// 调整高级美颜眼距效果，请先确认是否开通对应权限
/// @param level 眼距效果
- (void)adjustBeautyEyeangleLevel:(CGFloat)level;

/// 加载本地贴纸特效，请先确认是否开通对应权限
/// @param stickerPath 贴纸地址
/// @param stickerModelPath 贴纸博兴地址
/// @param stickerType 贴纸类型
/// @param stickerIdentify 贴纸id
/// @param gesture 是否支持手式
- (BOOL)applyLocalStickerVideoFx:(NSString *)stickerPath
           stickerModelPath:(NSString *)stickerModelPath
                stickerType:(NSString *)stickerType
            stickerIdentify:(NSString *)stickerIdentify
                   upportGesture:(BOOL)gesture;

/// 加载滤镜
/// @param path 滤镜地址
- (BOOL)applyEffectWithPath:(NSString *)path;

/// 卸载贴纸特效
- (void)disabledStickerVideoFx;

/// 加载人像分割特效
/// @param enabled 加载 or 卸载
/// @param path case 地址
- (void)setHumanSegEnabled:(BOOL)enabled effectPath:(NSString *)path;

@end

@class BDCloudARVideoFilterConfiguration;

@interface BRTCARFilter : NSObject<BRTCARFilter>

- (instancetype)initWithConfig:(BDCloudARVideoFilterConfiguration * _Nullable)config;
- (BOOL)updateConfig:(BDCloudARVideoFilterConfiguration *)config;

@end

#pragma mark - BRTCARFilter (BufferListener)

@protocol BRTCARFilterBufferListener <NSObject>
- (void)brtcARFilter:(BRTCARFilter *)filter renderFinishWithBuffer:(CMSampleBufferRef)buffer
          userDefine:(NSObject* _Nullable)userDefine;
@end

@interface BRTCARFilter (BufferListener)

/// 设置视频Buffer监听。
/// @param listener Buffer监听者。
- (void)setBufferlistener:(id<BRTCARFilterBufferListener>)listener;

/// 开始渲染单张视图
/// @param sampleBuffer 视频帧数据
/// @param userDefine 用户自定义数据
- (void)updateSampleBuffer:(CMSampleBufferRef)sampleBuffer userDefine:(NSObject* _Nullable)userDefine;
@end

@interface BDCloudARVideoFilterConfiguration : NSObject
/// 左右镜像效果.。默认NO。
@property (nonatomic, assign) BOOL mirror;
/// 分辨率.。必须设置。
@property (nonatomic, assign) CMVideoDimensions dimensions;
/// 预览视图。 必须设置。
@property (nonatomic, weak)   UIView *preView;
/// 视频帧率。必须设置。
@property (nonatomic, assign) NSInteger frameRate;
/// 横屏配置。横屏必须设置。
@property (nonatomic, assign) BOOL landscapeLeft;
/// 提高视频画质。默认NO。
@property (nonatomic, assign) BOOL upgradeQuality;
/// 支持直播。默认NO。
@property (nonatomic, assign) BOOL enableLive;
/// 支持动态帧率。默认NO。
@property (nonatomic, assign) BOOL enableAutoFramerate;
/// 默认配置。
+ (BDCloudARVideoFilterConfiguration *)defaultConfiguration;
@end

NS_ASSUME_NONNULL_END
