//
//  BRTCAudioUnit.h
//  BaiduRtcAudioProcess
//
//  Created by 曹士谦 on 2022/7/26.
//

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol BRTCAudioUnit <NSObject>

@optional

/**
 配置基础处理环境，可在单元被添加到处理过程中后直接调用
 */
- (void)config;

/**
 停止当前处理过程，清空处理缓存数据、重置处理状态
 */
- (void)reset;

@required

/**
  处理音频数据，输出数据的长度信息可能和输入不同
 @discussion 输出数据可能和输入数据相同，外部清除数据时需注意区别处理

 @param inBuffer 输入缓存
 @param toBuffer 输出缓存
 */
- (void)processBuffer:(AudioBuffer *)inBuffer toBuffer:(AudioBuffer *)toBuffer;

/**
 抽取所有处理剩余缓存
 @discussion 有些效果的处理，输出数据和输入数据长度不同，有些数据会残留在单元中，流引擎需要在最后调用该方法获取所有数据

 @param toBuffer 输出缓存
 */
- (void)fetchAllRemainBuffer:(AudioBuffer *)toBuffer;

/** 该单元是否有引起音频变化的实际效果 */
- (BOOL)hasEffect;

@end

@interface BRTCAudioUnit : NSObject<BRTCAudioUnit>

@property (nonatomic, assign) BOOL enabled;

@property (nonatomic) AudioComponentDescription preferedAcd;
@property (nonatomic, strong) AVAudioFormat *audioFormat;

@property (nonatomic, assign, readonly) Float64 sampleRate;
@property (nonatomic, assign, readonly) UInt32 channels;
@property (nonatomic, assign, readonly) UInt32 bytesPerChannel;

- (instancetype)initWithFormat:(AVAudioFormat *)audioFormat preferedAcd:(AudioComponentDescription)preferedAcd;

@end

NS_ASSUME_NONNULL_END
