//
//  RTCPlayerViewController.m
//  BaiduRtcPlayerDemo
//
//  Created by zhangyafei02 on 2022/3/28.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCPlayerViewController.h"
#import "RTCPlayerStaticView.h"
#import "RTCTextField.h"

#import <BaiduRtcPlayer/BaiduRtcPlayer.h>

@interface RTCPlayerViewController ()<BaiduRtcPlayerDelegate,
                            NoticeextFieldSaveDelegate>
@property (weak, nonatomic) IBOutlet UIButton *_btnPlay;

//@property (weak, nonatomic) IBOutlet UILabel *_labelnotify;
@property (weak, nonatomic) IBOutlet UIView *_playerView;
//@property (weak, nonatomic) IBOutlet UITextView *logTextView;
@property (weak, nonatomic) IBOutlet UIButton *btnStopPlayer;
@property (weak, nonatomic) IBOutlet UIButton *btnPausePlay;
@property (weak, nonatomic) IBOutlet UISwitch *btnSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *btnSwitchCodec;
@property (nonatomic, strong)BaiduRtcPlayer *_bdPlayer;
@property (nonatomic, strong) NSString *_urlPlayer1;
@property (nonatomic, strong) NSString *_signalPlayer1;
@property (nonatomic, strong) NSString *_urlPlayer2;
@property (nonatomic, strong) NSString *_signalPlayer2;
@property (nonatomic, assign) NSInteger _currretDelay;
@property (nonatomic, strong, readonly) NSUserDefaults *storage;
@property (weak, nonatomic) IBOutlet UISwitch *btnVBFrame;
@property (nonatomic, assign) BOOL boPlaying;
@property (nonatomic, assign) int  numChanged;

//@property (nonatomic, retain) IBOutlet UIView *contentView;

@property (nonatomic, readonly)RTCPlayerStaticView *rtcPlayerStatic;
//@property (nonatomic, strong)BLPRTCPlayerAudioSessionCoordinatorPlugin *blAudioSessionCoordinatorPluginplugin;

@end

@implementation RTCPlayerViewController{
    BOOL    _boPauseStatus;
    RTCTextField *_signalText;
    RTCTextField *_pathText;
    RTCTextField *_delayCurText;
    NSUserDefaults *_storage;
    BOOL    _boSizeChanged;
    BOOL    _boH264Url;

    BOOL    _boCodec265Type;
    BOOL    _boVideoBFrame;
    
    uint32_t _caton_times;
    uint32_t _caton_times_600;
    uint64_t _play_begin;
    uint64_t _caton_duration;
    uint64_t _caton_duration_600;
    BOOL  _boRuning_player;
}

//- (BLPRTCPlayerAudioSessionCoordinatorPlugin *)blAudioSessionCoordinatorPluginplugin {
//    if (!_blAudioSessionCoordinatorPluginplugin) {
//        _blAudioSessionCoordinatorPluginplugin = [[BLPRTCPlayerAudioSessionCoordinatorPlugin alloc] init];
//    }
//    return _blAudioSessionCoordinatorPluginplugin;
//}

- (NSUserDefaults *)storage {
    if (!_storage) {
        _storage = [NSUserDefaults standardUserDefaults];
    }
    return _storage;
}

//判断地址是否正确
- (BOOL)verifyWebUrlAddress:(NSString *)webUrl{
    NSError *error = nil;
    NSDataDetector *detector = [NSDataDetector dataDetectorWithTypes:NSTextCheckingTypeLink
                                                               error:&error];
    NSArray *matches = [detector matchesInString:webUrl
                                         options:nil
                                           range:NSMakeRange(0, webUrl.length)];

    if (matches.count == 1) {
        NSTextCheckingResult *result = matches.firstObject;
        if (result.range.location == 0) {
            return YES;
        } else {
            return NO;
        }
    } else {
        return NO;
    }
}

- (void)initParamPlayer {
    _boPauseStatus = YES;
    _boSizeChanged = YES;
    _boRuning_player = NO;
    _numChanged = 0;
    _caton_times = 0;
    _caton_times_600 = 0;
    _play_begin =  [[NSDate date] timeIntervalSince1970] * 1000; //播放的开始时间
    _caton_duration = 0;
    _caton_duration_600 = 0;
    if (nil == self._bdPlayer) {
        
        [BaiduRtcPlayer setVerbose:YES];
        BaiduRtcPlayerParameter *param = [BaiduRtcPlayerParameter defaultParameter];
        param.externalSetActive = YES;
        param.enableDtlsSrtp = NO;
        param.netStatus = ReachableWiFi;
        param.bufferInterval =  self._currretDelay;
        
        //初始化设置 视频解码类型。
        param.videoCodectype = _boCodec265Type ? CODEC_H265 : CODEC_H264;
        //设置B帧
        param.videoBFrame = _boVideoBFrame;
        param.checkFrameDuration = 30;
        param.switchOffStatistics = YES;
        
        self._bdPlayer = [[BaiduRtcPlayer alloc] initWithParameter:param
                                                   delegate:self];
    }
}
- (void)configBaseUI {
//    self._labelnotify.lineBreakMode = UILineBreakModeWordWrap;
    self.btnSwitchCodec.selected = _boCodec265Type;
    self.btnVBFrame.selected = _boVideoBFrame;

    if (nil == _rtcPlayerStatic) {
        _rtcPlayerStatic = [[RTCPlayerStaticView alloc] initWithFrame:CGRectZero];
        //_rtcPlayerStatic.videoCallViewDelegate = self;
        _rtcPlayerStatic.hidden = YES;
        //_rtcPlayerStatic.sdkVerion = [BaiduRtcPlayer version];
        [self.view addSubview:_rtcPlayerStatic];
        //_rtcPlayerStatic.backgroundColor = [UIColor greenColor];
        //_rtcPlayerStatic.alpha = 0.1;
    }

    //url and signal
    CGRect frame_rtc = CGRectMake(0, kRoomTextFieldHeight * 3,
                                  self.view.bounds.size.width, kRoomTextFieldHeight);
    
    if (nil == _signalText) {
        _signalText = [[RTCTextField alloc] initWithFrame:frame_rtc delegate:self];
        [_signalText setPlaceHolder:@"请输入信令地址："];
        [self.view addSubview:_signalText];
        
        if (self._signalPlayer1 == nil || [self._signalPlayer1 isEqual:@""]) {
           //-_signalText.roomText =  @"http://test-pl-central.bigenemy.cn/brtc/v3/pullstream";
           _signalText.roomText = @"https://flv-rtc.liveshow.bdstatic.com/brtc/v3/pullstream";
           //测试环境：
//          _signalText.roomText = @"http://124.237.177.17:8337/brtc/v3/pullstream";
            
//         _signalText.roomText = @"https://flv-rtc.liveshow.bdstatic.com/brtc/v3/pullstream";
            //server from 陈飞
           //_signalText.roomText = @"http://10.138.35.208:8888/brtc/v3/pullstream";
           //_signalText.roomText = @"http://10.25.69.114:/brtc/v3/pullstream";
            //张悦
//        _signalText.roomText = @"http://rtc-ss-gz02.acgrtc.com:8188/brtc/v3/pullstream";
            
            // 线上测试环境
//            _signalText.roomText = @"http://by-test.bj-webrtc-pl001.bigenemy.cn/brtc/v3/pullstream";
            
            self._signalPlayer1  = _signalText.roomText;
        } else {
            _signalText.roomText = self._signalPlayer1;
        }
    } else {
        self._signalPlayer1 = _signalText.roomText;
    }
    
    CGRect frame_path = CGRectMake(0, kRoomTextFieldHeight * 2,
                                  self.view.bounds.size.width, kRoomTextFieldHeight);
    if (nil == _pathText) {
        _pathText = [[RTCTextField alloc] initWithFrame:frame_path  delegate:self];
        [_pathText setPlaceHolder:@"请输入文件播放地址："];
        [self.view addSubview:_pathText];
        
        if (self._urlPlayer1 == nil || [self._urlPlayer1 isEqual:@""]) {
            //_pathText.roomText = @"webrtc://rtc2.exp.bcelive.com/live/appjmhm34aajbam/626667";
    //        _pathText.roomText = @"webrtc://test-pl-central.bigenemy.cn/myapp/test321.flv";
           //- minglu 测试地址 _pathText.roomText = @"webrtc://test-pl-central.bigenemy.cn/myapp/test321888.flv";
            //-_pathText.roomText = @"webrtc://flv-rtc.liveshow.bdstatic.com/appkh6jkudazeby/stream_bduid_1950898658_7484957039-L21.flv";
            

            //_pathText.roomText = @"webrtc://test-pl-central.bigenemy.cn/myapp/test369369.flv";
            //_pathText.roomText = @"webrtc://flv-rtc.liveshow.bdstatic.com/appkh6jkudazeby/stream_bduid_2600194283_7684429760-L21.flv";
            //-_pathText.roomText = @"webrtc://flv-rtc.liveshow.bdstatic.com/appkh6jkudazeby/stream_bduid_878729132_7620665010-L21.flv";
            
            //快乐的coding
            //_pathText.roomText = @"webrtc://flv-rtc.liveshow.bdstatic.com/appkh6jkudazeby/stream_bduid_1268676514_7700209671-L21.flv";
            
            //_pathText.roomText = @"webrtc://124.237.177.17/myapp/stream_bduid_4877466723_7765100920.flv";
            
            //_pathText.roomText = @"webrtc://flv-rtc.liveshow.bdstatic.com/appkh6jkudazeby/stream_bduid_2824416718_7784105665-L21.flv";
            //_pathText.roomText = @"webrtc://124.237.177.17/myapp/test369369.flv";
            //测试环境：
            //_pathText.roomText = @"webrtc://124.237.177.17/myapp/100002.flv";

            
            //_pathText.roomText = @"webrtc://test-pl-central.bigenemy.cn/myapp/test3288.flv";
            //--url from 晨飞
            //_pathText.roomText = @"webrtc://10.138.35.208/lssrtc-player/chenfei.flv";
            
            //张跃
           //- _pathText.roomText = @"webrtc://flv-rtc.liveshow.bdstatic.com/appkh6jkudazeby/stream_bduid_1104574864_7798087673.flv";
            
            //_pathText.roomText = @"webrtc://flv-rtc.liveshow.bdstatic.com/appkh6jkudazeby/stream_bduid_1104574864_7819698290.flv";
            
            _pathText.roomText = @"webrtc://flv-rtc.liveshow.bdstatic.com/appkh6jkudazeby/stream_bduid_6344174705_9141985044-L21.flv";
            _pathText.roomText = @"webrtc://flv-rtc.liveshow.bdstatic.com/appkh6jkudazeby/stream_bduid_6344174705_9141985044-hevc-LV720-brtc-b.flv";
            
           
            //本地测试
//           _pathText.roomText = @"webrtc://124.237.177.17/myapp/test369369.flv";
            
            // 线上测试环境
//            _pathText.roomText = @"webrtc://by-test.bj-webrtc-pl001.bigenemy.cn/myapp/test369369.flv";
//
//            _pathText.roomText = @"webrtc://flv-rtc.liveshow.bdstatic.com/appkh6jkudazeby/stream_bduid_6422418969_8686715754-L21.flv";
//
//           _pathText.roomText = @"webrtc://endpoint/live/appjfkryqbzyns5/8888/100227393";

            //_pathText.roomText = @"webrtc://flv-rtc.liveshow.bdstatic.com/live/zyf000.flv";
            self._urlPlayer1  = _pathText.roomText;

        } else {
            _pathText.roomText = self._urlPlayer1;
        }
    } else {
        self._urlPlayer1 = _pathText.roomText;
    }
    
    if (nil == _delayCurText) {
        CGRect frame_path = CGRectMake(0, kRoomTextFieldHeight * 4,
                                      self.view.bounds.size.width, kRoomTextFieldHeight);
        _delayCurText = [[RTCTextField alloc] initWithFrame:frame_path  delegate:self];
        [_delayCurText setPlaceHolder:@"请输入手动延迟："];
        [self.view addSubview:_delayCurText];
        
        if (self._currretDelay == 0 ) {
           
            //本地测试
            _delayCurText.roomText = @"0";

            self._currretDelay  = [_delayCurText.roomText integerValue];

        } else {
            _delayCurText.roomText = [NSString stringWithFormat:@"%ld", (long)self._currretDelay];
        }
    } else {
        self._currretDelay = [_delayCurText.roomText integerValue];
    }
}

- (void) viewDidLayoutSubviews{
    
    _rtcPlayerStatic.frame = CGRectMake(self.view.bounds.origin.x,
                                              self.view.bounds.origin.y,
                                              self.view.bounds.size.width,
                                              self.view.bounds.size.height * 6 / 8);
}
- (void)layoutSubviews {
    //CGSize statsSize = [_rtcPlayerStatic sizeThatFits:self.view.bounds.size];
}
- (void)applicationBecomeActive {
    NSLog(@"[rtcplayer] applicationBecomeActive");
    return;
//    [self._bdPlayer s];
    [self._bdPlayer resetAudioDeviceConfigure];
    
    
    [self._bdPlayer setCodecType:_boCodec265Type ? CODEC_H264 : CODEC_H265 ];
    
    [self._bdPlayer prepareToPlay:[self._urlPlayer1 stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]]
                         autoPlay:NO];
    
}
- (void)applicationEnterBackground {
    NSLog(@"[rtcplayer] applicationEnterBackground");
    return;
   // [self._bdPlayer pausePlay];
    
    [self._bdPlayer stopPlay];
//    [self._bdPlayer reset];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self._urlPlayer1  = [self.storage objectForKey:@"url_rtc"];
    self._signalPlayer1 = [self.storage objectForKey:@"signal_rtc"];
    self._currretDelay = [[self.storage objectForKey:@"delay_rtc"]  integerValue];
    
    // app从后台进入前台都会调用这个方法
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationBecomeActive) name:UIApplicationWillEnterForegroundNotification object:nil];
    // 添加检测app进入后台的观察者
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationEnterBackground) name: UIApplicationDidEnterBackgroundNotification object:nil];
    
    // Do any additional setup after loading the view.
    _boCodec265Type = YES;
    _boVideoBFrame = YES;

    [self configBaseUI];
    //TODO log output
//    [self redirectSTD:STDOUT_FILENO];
//    [self redirectSTD:STDERR_FILENO];
}

- (void)popViewController {
    [self.navigationController popViewControllerAnimated:YES];
}

#pragma mark - player

- (void)initPlayer {
    if (!__bdPlayer) {
        [self initParamPlayer];
    }
    if (!self.boPlaying) {
        return;
    }
    if (self._playerView.subviews.count == 0) {
        [self._playerView addSubview:self._bdPlayer.view];
        self._bdPlayer.view.frame = self._playerView.bounds;
        //self._bdPlayer.view.backgroundColor = [UIColor grayColor];
        //[self._bdPlayer.view bringSubviewToFront:self._playerView];
    }
}

- (void)uinitPlayer {
    if (self._bdPlayer) {
        [__bdPlayer.view removeFromSuperview];
        [__bdPlayer stopPlay];
        __bdPlayer = nil;
        [_rtcPlayerStatic clear];
    }
}

- (void)replayPlayer {
    if (__bdPlayer) {
        [__bdPlayer stopPlay];
        [__bdPlayer prepareToPlay:self._urlPlayer1 autoPlay:YES];
    }
}

- (void)preparePlayerWithIp:(NSString *)serverIp streamUrl:(NSString *)url isUdp:(BOOL)isUdp {
    if (!self._bdPlayer) return;
    
    [self._bdPlayer setMediaServerIp:serverIp];
    [self._bdPlayer setSingalMode:(isUdp ? BaiduRtcPlayerSingalModeOverUdp : BaiduRtcPlayerSingalModeOverHttp)];
    [self._bdPlayer setCodecType:self->_boCodec265Type ? CODEC_H265 : CODEC_H264];
    [self._bdPlayer prepareToPlay:url autoPlay:NO];
}

- (BOOL)validateStartPlay {
    BOOL ret = YES;
    if (self.boPlaying) {
        NSLog(@"[Player][Start Error] quit for playing now");
        ret = NO;
    }
    BaiduRtcPlayerStatus status = self._bdPlayer.status;
    if (status == BaiduRtcPlayerStatusStarting ||
        status == BaiduRtcPlayerStatusPrepared ||
        status == BaiduRtcPlayerStatusStarted ||
        status == BaiduRtcPlayerStatusStoping) {
        NSLog(@"[Player][Start Error] quit for invalid status: %@", @(status));
        ret = NO;
    }
    return ret;
}

- (BOOL)validatePlayUrlAddress {
    BOOL ret = YES;
    if (!([self verifyWebUrlAddress:_pathText.roomText] && [self verifyWebUrlAddress:_signalText.roomText])) {
        NSLog(@"[Player][Start Error] empty stream url or signal url.");
        ret = NO;
    }
    return ret;
}

- (void)startRequestDNSWithUrl:(NSURL *)url streamUrl:(NSString *)streamUrl isUdp:(BOOL)isUdp {
    if (nil == [url host]) {
        NSLog(@"[Player][Start Error] signal address should be crorect !!!");
        return;
    }
    
    NSString *urlDns= @"http://httpdns.bcelive.com/?dns=";
    NSURL *requestUrl = [NSURL URLWithString:[urlDns stringByAppendingString:[url host]]];
    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:requestUrl];
    request.HTTPMethod = @"GET";
    
    NSURLSession *session = [NSURLSession sharedSession];
    [[session dataTaskWithRequest:request
                completionHandler:^(NSData *data, NSURLResponse *response, NSError *error) {
        [self handleDNSResponseWithUrl:url streamUrl:streamUrl isUdp:isUdp data:data error:error];
    }] resume];
}

- (void)handleDNSResponseWithUrl:(NSURL *)url streamUrl:(NSString *)streamUrl isUdp:(BOOL)isUdp
                            data:(NSData *)data error:(NSError *)error {
    if (error) {
        NSLog(@"[Player][Start Error] request dns error: %@", error.description);
        return;
    }
    
    NSDictionary *resposne = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:nil];
    NSDictionary *responseData = [resposne objectForKey:@"data"];
    if (nil == responseData) {
        NSLog(@"[Player][Start Error] dns response data is empty.");
        return;
    }
    
    [self._bdPlayer detectNetStatus];
    
    NSDictionary *dataInner = [responseData objectForKey:[url host]];
    if (dataInner != nil) {
        NSArray *ipsArray = [dataInner objectForKey:@"ips"];
        if (ipsArray != nil) {
            NSString *ip = ipsArray.firstObject;
            NSLog(@" remote ip: dns %@ ,ip: %@", [url host], ip);
            [self preparePlayerWithIp:ip streamUrl:streamUrl isUdp:isUdp];
        }
    } else {
        [self preparePlayerWithIp:[url host] streamUrl:streamUrl isUdp:isUdp];
    }
}

#pragma mark ---BaiduRtcPlayerDelegate

- (void)onPrepared:(BaiduRtcPlayer *)player elapse:(NSInteger)interval{
    if (self._bdPlayer) {
        [self._bdPlayer startPlay];
    }
}

- (void)onFirstVideoFrameRendered:(BaiduRtcPlayer *)player elapse:(NSInteger)interval{
    NSLog(@"当前已获取视频首帧");
   //NSString *outStr = @"Demo:";
   // [self appendLogInfo:[outStr stringByAppendingFormat:@"当前已获取视频首帧"]];
    dispatch_async(dispatch_get_main_queue(), ^{
        self->_rtcPlayerStatic.info = [NSString stringWithFormat:@"%ld , sessionId:%@", interval, self->__bdPlayer.sessionId];
        //self->_rtcPlayerStatic.videoSize = self._bdPlayer.videoSize;
        [self->_rtcPlayerStatic layoutSubviews];
    });
    
//    [self._bdPlayer setVoulme:0.0];
    _boRuning_player = YES;
    
    NSLog(@"onFirstVideoFrameRendered session:%@", self->__bdPlayer.sessionId);
}

- (IBAction)onVideoBframeChange:(id)sender {
    _boVideoBFrame = self.btnVBFrame.isOn;
}

- (IBAction)onCodecChange:(id)sender {
    _boCodec265Type = self.btnSwitchCodec.isOn;
}

- (void)onPlayerAudioBufferingStart:(BaiduRtcPlayer *)player {
    NSLog(@"播放器开始卡顿  frameRate:");
    _caton_times++;
    _caton_times_600++;
}
- (void)onPlayerAudioBufferingEnd:(BaiduRtcPlayer *)player jitter:(NSInteger)interval netInfo:(NSString *)playingInfo {
    NSLog(@"播放器开始卡顿 结束  卡顿时常:%ld 网络参数：%@", (long)interval, playingInfo);
    
    _caton_duration += interval;
    if (interval < 600) {
        _caton_times_600--;
    } else {
        _caton_duration_600 += interval;
    }
}

- (void)onPeriodRenderStatis:(BaiduRtcPlayer *)player frame:(NSInteger)frameRate {
    
    NSLog(@"周期性获取渲染参数统计  frameRate:%lu", frameRate);
    
   //NSString *outStr = @"Demo:";
   // [self appendLogInfo:[outStr stringByAppendingFormat:@"当前已获取视频首帧"]];
    dispatch_async(dispatch_get_main_queue(), ^{
        
        self->_rtcPlayerStatic.info = [NSString stringWithFormat:@"%ld", (long)self->__bdPlayer.firstFrameTimeval];
        self->_rtcPlayerStatic.staticInfo = @"hahhahhsdhfadsfasdfßßß";
        [self->_rtcPlayerStatic layoutSubviews];
        NSLog(@"caton: %llu", self->_play_begin);
        uint64_t _play_now = [[NSDate date] timeIntervalSince1970] * 1000;
        NSLog(@"caton now: %llu", _play_now);
        self->_rtcPlayerStatic.catonInfo = [NSString stringWithFormat:@"卡顿次数：%u, 卡顿时长：%llu\n卡顿次数：%u, 卡顿时长：%llu(600)\n播放时长：%llu",
                                            self->_caton_times, self->_caton_duration,
                                            self->_caton_times_600, self->_caton_duration_600,
                                            (_play_now - self->_play_begin)];
        self->_rtcPlayerStatic.rtcInnerInfo = [self->__bdPlayer playerInnerInfo];
        
    });
}

- (void)onSetActiveExternal:(BaiduRtcPlayer *)player
                      active:(BOOL) boActive
                       error:(NSError **)outError {
    NSError* error;
    AVAudioSessionSetActiveOptions options =
    boActive ? 0 : AVAudioSessionSetActiveOptionNotifyOthersOnDeactivation;
    BOOL success = [[AVAudioSession sharedInstance] setActive:boActive
                                             withOptions:options
                           error:&error];
    if (outError) {
      *outError = error;
    }
    
}
- (void)onStreamResolutionChanged:(BaiduRtcPlayer *)player
                           status:(BaiduRtcStreamChangeStatus)channgedStatus
                          netInfo:(NSString *)playingInfo {
    NSLog(@"onStreamResolutionChanged :%ld playingInfo:%@", (long)channgedStatus, playingInfo);
    self->_numChanged ++;
    self->_rtcPlayerStatic.changedNum = [NSString stringWithFormat:@"线路切换次数：%d", self->_numChanged];
    [self replayPlayer];
}
/// 过滤sei消息中的补03字节
- (NSData *)handleNalHeaderBytes:(NSData *)data  {
    NSMutableString *resultStr = [NSMutableString string];
    const char *bytes = [data bytes];
    for (int i = 0; i < data.length; i++) {
        [resultStr appendFormat:@"%02hhx", (unsigned char)bytes[i]];
    }
    [resultStr replaceOccurrencesOfString:@"000003"
                                  withString:@"0000"
                                     options:NSLiteralSearch
                                       range:NSMakeRange(0, [resultStr length])];
    NSData *dataWithBytes = [self convertHexStrToData:resultStr];
    return dataWithBytes;
}
// 将十六进制字符串转换成NSData
- (NSData *)convertHexStrToData:(NSString *)str {
    if (!str || [str length] == 0) {
        return nil;
    }
    NSMutableData *hexData = [[NSMutableData alloc] initWithCapacity:8];
    NSRange range;
    if ([str length] % 2 == 0) {
        range = NSMakeRange(0, 2);
    } else {
        range = NSMakeRange(0, 1);
    }
    for (NSInteger i = range.location; i < [str length]; i += 2) {
        unsigned int anInt;
        NSString *hexCharStr = [str substringWithRange:range];
        NSScanner *scanner = [[NSScanner alloc] initWithString:hexCharStr];
        
        [scanner scanHexInt:&anInt];
        NSData *entity = [[NSData alloc] initWithBytes:&anInt length:1];
        [hexData appendData:entity];
        
        range.location += range.length;
        range.length = 2;
    }
    return hexData;
}

- (NSString *)hexStringFromData:(NSData *)myD{
    Byte *bytes = (Byte *)[myD bytes];
    //下面是Byte 转换为16进制。
    NSString *hexStr=@"";
    for (int i = 0; i < [myD length]; i++){
        //16进制数
        NSString *newHexStr = [NSString stringWithFormat:@"%x", bytes[i]&0xff];
        if ([newHexStr length] == 1) {
            hexStr = [NSString stringWithFormat:@"%@0%@", hexStr, newHexStr];
        } else {
            hexStr = [NSString stringWithFormat:@"%@%@", hexStr, newHexStr];
        }
    }
    return hexStr;
}
//字符串转时间戳 如：2017-4-10 17:15:10

- (NSString *)getTimeStrWithString:(NSString *)str{
    
    NSTimeInterval timeInterval = [str integerValue];
    NSDate *date = [NSDate dateWithTimeIntervalSince1970:timeInterval];
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    formatter.dateFormat = @"yyyy-MM-dd HH:mm:ss SSS";
    NSString *dateString = [formatter stringFromDate:date];
    return dateString;
}

- (NSInteger)countTimeDuration:(NSString *)timestamp {
    NSTimeInterval currentTime = [[NSDate date] timeIntervalSince1970] * 1000;
    NSString *timeStr = [NSString stringWithFormat:@"%.0f", currentTime];
    NSInteger time = [timeStr integerValue] - [timestamp integerValue];
    if (time < 0) {
        time = 0;
    }
    
    //NSLog(@"Delay current ts:%@ remote ts:%@ delay:%ld",  [self getTimeStrWithString:timeStr], [self getTimeStrWithString:timestamp], time);
    NSLog(@"Delay current ts:%ld remote ts:%ld delay:%ld",  [timeStr integerValue], [timestamp integerValue], time);

    return time;
}

- (NSInteger)countTailLength:(NSData *)data {
    NSMutableString *resultStr = [NSMutableString string];
    const char *bytes = [data bytes];
    for (int i = 0; i < data.length; i++) {
        [resultStr appendFormat:@"%02hhx", (unsigned char)bytes[i]];
    }
    NSString *tailStr = [resultStr substringWithRange:NSMakeRange(resultStr.length - 8, 8)];
    if ([tailStr containsString:@"000080"]) {
        return 3;
    } else if ([tailStr containsString:@"0080"]) {
        return 2;
    }
    return 1;
}

- (id)string2Object:(NSString *)string {
    if ([string isEqual:[NSNull null]] || ![string length]) {
        return nil;
    }
    NSError *error = nil;
    NSData *data = [string dataUsingEncoding:NSUTF8StringEncoding];
    if (data) {
        id json = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:&error];
        return json;
    } else {
        return nil;
    }
}

- (void)onPlayerReceivedSEI:(BaiduRtcPlayer *)player
                        sei:(NSData *)sei {
    NSDictionary *result = [NSKeyedUnarchiver unarchiveObjectWithData:sei];
    NSString *str  = [[NSString alloc] initWithBytes:sei.bytes length:sei.length encoding:NSUTF8StringEncoding];
    NSLog(@"onPlayerReceivedSEI info");
    
    // seiDic:{"playload":"xxxx","type":"5","uuid":"AAAA01F8D818E62212EB88E43C3551C7"}
     sei = [self handleNalHeaderBytes:sei];
     uint8_t *seiData = (uint8_t *)[sei bytes];
     int index = 2;
//     if ([_resCategory isEqualToString:@"bdrtchevc"]) {
     if (self->_boCodec265Type) {
         index = 3;  // hevc流sei头部有4E标识，需要去掉
     }
     int readPlayloadSize = 0;
     do {
         readPlayloadSize += seiData[index] & 0xFF;
     } while (seiData[index++] == 0xFF);
     if (sei.length < index + 16) {
         return; // sei消息异常
     }
     NSData *uuidData = [sei subdataWithRange:NSMakeRange(index, 16)];
     NSString *uuid = [self hexStringFromData:uuidData];
     NSInteger tailLength = [self countTailLength:sei];
     NSString *playload = [[NSString alloc] initWithData:[sei subdataWithRange:NSMakeRange(index + 16, sei.length - index - 16 - tailLength)] encoding:NSASCIIStringEncoding];
 //     NSLog(@"wc直播 sei信息 uuid:%@  playload:%@ ", uuid, playload);
//     if (!CHECK_STRING_VALID(uuid) || uuid.length < 6) {
//         return;
//     }
     NSString *seiHeader = [uuid substringToIndex:4];
     if (![seiHeader isEqualToString:@"aaaa"]) {
         return;
     }
//     if (!CHECK_STRING_VALID(playload)) {
//         return;
//     }
     id playloadObject = [self string2Object:playload];
     NSString *seiType = [uuid substringWithRange:NSMakeRange(4, 2)];
     if (nil != (seiType)) {
         // SEI消息
         if (seiType.intValue == 1 /*&& [self getSEI2PlayerSync]*/) {
//             if (CHECK_DICTIONARY_INVALID(playloadObject)) {
//                 return;
//             }
             NSMutableDictionary *mutablePlayload = [playloadObject mutableCopy];
             [mutablePlayload setValue:seiType forKey:@"sei_type"];
             dispatch_async(dispatch_get_main_queue(), ^{
                 
                 NSDictionary *detailsDict = playloadObject[@"data"];
                 if (detailsDict != nil) {
                     NSDictionary *service_infoDict = detailsDict[@"service_info"];
                     if (service_infoDict != nil) {
                         NSDictionary *contentDict = service_infoDict[@"content"];
                         if (nil != contentDict) {
                             NSString* strTimeStamp = contentDict[@"timestamp"];
                             ;
                             self->_rtcPlayerStatic.delayInfo = [NSString stringWithFormat:@"端到端延迟：%lu",
                                                                 [self countTimeDuration:strTimeStamp]];
                         }
                     }
                 }
                 
//                 [self.seiManager addSEIMessage:mutablePlayload];
             });
         } else if (seiType.intValue == 2 /*&& [self getSEI2IMSync]*/) { // IM消息
//             if (CHECK_ARRAY_VALID(playloadObject)) {
//                 for (NSDictionary *item in playloadObject) {
//                     dispatch_async(dispatch_get_main_queue(), ^{
//                         [self.seiManager addBussinessSEIMessage:item];
//                     });
//                 }
//             } else if (CHECK_DICTIONARY_VALID(playloadObject)) {
//                 dispatch_async(dispatch_get_main_queue(), ^{
//                     [self.seiManager addBussinessSEIMessage:playloadObject];
//                 });
//             }
         } else if (seiType.intValue == 3 ) { // 字幕消息
//             if (CHECK_DICTIONARY_VALID(playloadObject)) {
//                 // playloadObject":@"{\"data\":{\"content_type\":\"stream_asr\",\"duration\":\"1200\",\"id\":\"1\",\"text\":\"那个建这控\"}}}\n
//                 dispatch_async(dispatch_get_main_queue(), ^{
//                     [self.seiManager addBussinessSEIMessage:playloadObject];
//                 });
//             }
         }
     }

}
- (void)onResolutionChanged:(BaiduRtcPlayer *)player
                       size:(CGSize)size {
    NSLog(@"当前视频分辨率发生变化");
    self->_rtcPlayerStatic.videoSize = size;
}
- (void)onPlayerError:(BaiduRtcPlayer *)player
            errorCode:(BaiduRtcPlayerErrorCode)errorCode
                error:(nullable NSError *)error {
    NSLog(@"播放失败：errorCode = %zd, error = %@", errorCode, error);
//    NSString *outStr = @"Demo:";
//    [self appendLogInfo:[outStr stringByAppendingFormat:@"播放失败：errorCode = %zd, error = %@", errorCode, error]];
    switch (errorCode) {
        case BaiduRtcPlayerErrorInvalidUrl:{
            NSLog(@"请使用有效的url播放");
//            __weak typeof(self) wSelf = self;
//            UIAlertController *alert = [[UIAlertController alloc] init];
//            alert.title = @"请使用有效的url播放";
//            UIAlertAction *action = [UIAlertAction actionWithTitle:@"确定"
//                                                             style:UIAlertActionStyleCancel
//                                                           handler:^(UIAlertAction * _Nonnull action) {
//                [wSelf popViewController];
//            }];
//            [alert addAction:action];
//            [self presentViewController:alert animated:YES completion:nil];
        }
            break;
        case BaiduRtcPlayerErrorIceFailed:
            break;
        case BaiduRtcPlayerErrorIceDisconnected:
            NSLog(@"请检查自己的网络后进行重连");
            //-[self.session reconnectLivePlay];
            break;
        case BaiduRtcPlayerErrorGetLocalSdpFailed:
        case BaiduRtcPlayerErrorSetLocalSdpFailed:
            NSLog(@"请检查自己的网络后进行重连");
//            [self.session reconnectLivePlay];
            break;
        case BaiduRtcPlayerErrorGetRemoteSdpFailed:
        case BaiduRtcPlayerErrorSetRemoteSdpFailed:
            NSLog(@"请检查自己的网络后进行重连，同时上报错误信息方便排查");
//            [self.session reconnectLivePlay];
            break;
        case BaiduRtcPlayerErrorNullVideoFrame:
        case BaiduRtcPlayerErrorUdpUnsupport:
            [self replayPlayer];
            break;
        default:
            break;
    }
}
//stats 统计日志
- (void)onPlayerStatisticsInfo:(BaiduRtcPlayer *)player
                        stats:(NSArray *)statistics {
    dispatch_async(dispatch_get_main_queue(), ^{
        self->_rtcPlayerStatic.stats = statistics;
        [self->_rtcPlayerStatic layoutSubviews];
    });
}

- (void)onPlayerStreamChanged:(BaiduRtcPlayer *)player
                     hasVideo:(BOOL)hasVideo
                     hasAudio:(BOOL)hasAudio {
//    NSString *outStr = @"Demo:";
//    [self appendLogInfo:[outStr stringByAppendingFormat:@"视频流发生变化： hasVideo = %d, hasAudio = %d", hasVideo, hasAudio]];
    NSLog(@"视频流发生变化： hasVideo = %d, hasAudio = %d", hasVideo, hasAudio);
}

- (void)onPlayerStatusChanged:(BaiduRtcPlayer *)player
                       status:(BaiduRtcPlayerStatus)status {
    NSLog(@"播放器状态发生变化：status = %zd", status);
    
    dispatch_async(dispatch_get_main_queue(), ^{
        if (status == BaiduRtcPlayerStatusIdle || status == BaiduRtcPlayerStatusStoped) {
            self->_signalText.hidden = NO;
            self->_pathText.hidden = NO;
            self->_delayCurText.hidden = NO;
            self->_rtcPlayerStatic.hidden = YES;
        } else {
            self->_signalText.hidden = YES;
            self->_pathText.hidden = YES;
            self->_delayCurText.hidden = YES;
            self->_rtcPlayerStatic.hidden = NO;
        }
    });
    
//    [self.blAudioSessionCoordinatorPluginplugin StatusChanged:player status:status];
//    if (<#condition#>) {
//        <#statements#>
//    }
//    [_plugin ]
    
    
//    NSString *outStr = @"Demo:";
//    [self appendLogInfo:[outStr stringByAppendingFormat:@"播放器状态发生变化：status = %zd", status]];
}
- (NSString *)convertToJsonData:(NSDictionary *) dict {
    NSError *error;
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:dict
                                        options:NSJSONWritingSortedKeys
                                        error:&error];
    NSString *jsonString;
    if (!jsonData) {
        NSLog(@"%@", error);
    } else {
        jsonString = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
    }
    return jsonString;
}


- (void)onPlayerTimeStatician:(BaiduRtcPlayer *)player
                         info:(NSDictionary*)playStartInfo {
    NSLog(@"player:%@, onPlayerTimeStatician:%@", player, [self convertToJsonData:playStartInfo]);
}
#pragma  operation
- (void) appendLogInfo:(NSString*)logstr {
    dispatch_async(dispatch_get_main_queue(), ^{
//        self._labelnotify.text= [self._labelnotify.text stringByAppendingFormat:@"\n%@", logstr];
    });
}
- (IBAction)onPlayerViewChanged:(id)sender {
    if (_boSizeChanged){
        self._bdPlayer.view.frame = CGRectMake(0, kRoomTextFieldHeight * 4, self._playerView.bounds.size.width, self._playerView.bounds.size.height *2 /8);

    } else {
        self._bdPlayer.view.frame = CGRectMake(0, kRoomTextFieldHeight * 4, self._playerView.bounds.size.width, self._playerView.bounds.size.height *7 /8);

    }
    _boSizeChanged = !_boSizeChanged;
}
- (IBAction)onStartL2:(id)sender {
    return;
    if (![self validateStartPlay] || ![self validatePlayUrlAddress]) {
        return;
    }
    
    NSLog(@"onStartL3 StartPlay now");
    self.boPlaying = YES;
    [self initPlayer];
    
    NSString *signalUrl = [self getTrimmingString:_signalText.roomText];
    NSString* realStr2 = [_pathText.roomText stringByReplacingOccurrencesOfString:@"L21" withString:@"L22"];
    realStr2 = [self getTrimmingString:realStr2];
    
    [self startRequestDNSWithUrl:[NSURL URLWithString:signalUrl] streamUrl:realStr2 isUdp:NO];
    self.boPlaying = NO;
}
- (IBAction)onStartL3:(id)sender {
    return;
    if (![self validateStartPlay] || ![self validatePlayUrlAddress]) {
        return;
    }
    
    NSLog(@"onStartL3 StartPlay now");
    self.boPlaying = YES;
    [self initPlayer];
    
    NSString *signalUrl = [self getTrimmingString:_signalText.roomText];
    NSString* realStr3 = [_pathText.roomText stringByReplacingOccurrencesOfString:@"L21" withString:@"L23"];
    realStr3 = [self getTrimmingString:realStr3];
    
    [self startRequestDNSWithUrl:[NSURL URLWithString:signalUrl] streamUrl:realStr3 isUdp:NO];
    self.boPlaying = NO;
}

- (IBAction)onStart:(id)sender {
    if (![self validateStartPlay] || ![self validatePlayUrlAddress]) {
        return;
    }
    
    NSLog(@"onStart StartPlay now");
    self.boPlaying = YES;
    [self initPlayer];
    
    NSString *signalUrl = [self getTrimmingString:_signalText.roomText];
    NSString *streamUrl = [self getTrimmingString:self._urlPlayer1];
    
    [self._bdPlayer setSignalServer:signalUrl];
    [self startRequestDNSWithUrl:[NSURL URLWithString:signalUrl] streamUrl:streamUrl isUdp:NO];
    self.boPlaying = NO;
}

- (IBAction)onStart_U:(id)sender {
    if (![self validateStartPlay]) {
        return;
    }
    
    NSLog(@"onStart_U StartPlay now");
    self.boPlaying = YES;
    [self initPlayer];
    
    NSString *signalUrl = [self getTrimmingString:_signalText.roomText];
    NSString *streamUrl = [self getTrimmingString:self._urlPlayer1];
    
    [self._bdPlayer setSignalServer:signalUrl];
    [self startRequestDNSWithUrl:[NSURL URLWithString:signalUrl] streamUrl:streamUrl isUdp:YES];
    self.boPlaying = NO;
}
- (IBAction)onPausePlay:(id)sender {
        if (_boPauseStatus) {
            [self._bdPlayer pausePlay];
//            [self.btnPausePlay setTitle:@"RESU" forState:UIControlStateNormal];
        } else {
            [self._bdPlayer resumePlay];
//            [self.btnPausePlay setTitle:@"PAUSE" forState:UIControlStateNormal];
        }
        _boPauseStatus = !_boPauseStatus;
        NSString *outStr = @"Demo:";
        [self appendLogInfo:[outStr stringByAppendingFormat:@" operation: pause or resume"]];
}
- (IBAction)onPause:(id)sender {
//    if (_boPauseStatus) {
//        [self._bdPlayer pausePlay];
//        [self._btnPause setTitle:@"RESUM" forState:UIControlStateNormal];
//    } else {
//        [self._bdPlayer resumePlay];
//        [self._btnPause setTitle:@"PAUSE" forState:UIControlStateNormal];
//    }
    _boPauseStatus = !_boPauseStatus;
//    NSString *outStr = @"Demo:";
//    [self appendLogInfo:[outStr stringByAppendingFormat:@" operation: pause or resume"]];
    //[self redirectSTD:STDERR_FILENO];

}
- (IBAction)onstopPlay:(id)sender {
    [self uinitPlayer];
}
- (void)redirectNotificationHandle:(NSNotification *)nf{ // 通知方法
//    NSData *data = [[nf userInfo] objectForKey:NSFileHandleNotificationDataItem];
//    NSString *str = [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
//
//    self.logTextView.text = [NSString stringWithFormat:@"%@\n\n%@", self.logTextView.text, str];
//    NSRange range;
//    range.location = [self.logTextView.text length] - 1;
//    range.length = 0;
//    [self.logTextView scrollRangeToVisible:range];
//    [[nf object] readInBackgroundAndNotify];
}
 
- (void)redirectSTD:(int)fd{
    NSPipe *pipe = [NSPipe pipe]; // 初始化一个NSPipe 对象
    NSFileHandle *pipeReadHandle = [pipe fileHandleForReading];
    dup2([[pipe fileHandleForWriting] fileDescriptor], fd);
     
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(redirectNotificationHandle:)
                                                 name:NSFileHandleReadCompletionNotification
                                               object:pipeReadHandle]; // 注册通知
    [pipeReadHandle readInBackgroundAndNotify];
}

#pragma mark NoticeextFieldSaveDelegate
- (void) onNoticeSave:(RTCTextField *) textField {
    
    if ([textField.roomText length] < 0) {
        return;
    }
    
    if (textField == _signalText) {
        [self.storage setObject:textField.roomText forKey:@"signal_rtc"];
        [self.storage setObject:_pathText.roomText forKey:@"url_rtc"];
        
    } else if (textField == _pathText) {
        [self.storage setObject:_signalText.roomText forKey:@"signal_rtc"];
        [self.storage setObject:textField.roomText forKey:@"url_rtc"];
        
    } else if (textField == _delayCurText) {
        self._currretDelay =  [_delayCurText.roomText integerValue];
        [self.storage setObject:[NSString stringWithFormat:@"%ld", (long)__currretDelay] forKey:@"delay_rtc"];
    }
    self._urlPlayer1 =_pathText.roomText;
    self._signalPlayer1 = _signalText.roomText;
    [self.storage synchronize];

}

- (NSString *)getTrimmingString:(NSString *)str {
    return [str stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
}

@end
