//
//  RTCPlayerStaticView.m
//  BaiduRtcPlayerDemo
//
//  Created by zhangyafei02 on 2022/4/8.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RTCPlayerStaticView.h"
///#import <BaiduRTCPlayer/RTCStatsBuilder.h>

@implementation RTCPlayerStaticView  {
    UILabel *_statsLabel;
    NSString *_headerInfo;
    CGSize   _vidoeSize;
    NSString *_catonInfo;
    NSString *_delayInfo;
    NSString *_rtcInnerInfo;
    NSString *_changedNum;
    //RTCStatsBuilder *_statsBuilder;
}
- (void) dealloc {
    NSLog(@"RTCPlayerStaticView dealloc!!!");
}
- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        _statsLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _statsLabel.numberOfLines = 0;
        _statsLabel.font = [UIFont fontWithName:@"Roboto" size:9];
        _statsLabel.adjustsFontSizeToFitWidth = YES;
        _statsLabel.minimumScaleFactor = 0.6;
        _statsLabel.textColor = [UIColor blueColor];
        [self addSubview:_statsLabel];
        self.backgroundColor = [UIColor colorWithWhite:0 alpha:0.3];
        //_statsBuilder = [[RTCStatsBuilder alloc] init];
        UITapGestureRecognizer *tapRecognizerOfStates =
        [[UITapGestureRecognizer alloc]
         initWithTarget:self
         action:@selector(onTapScreen:)];
        tapRecognizerOfStates.numberOfTapsRequired = 3;
        [self addGestureRecognizer:tapRecognizerOfStates];
        
        self.sdkVerion = @"1.1.5";
    }
    return self;
}
- (void)setVideoSize:(CGSize)vSize {
    _vidoeSize = vSize;
}
- (void)setInfo:(NSString *)statsInfo {
    _headerInfo = statsInfo;
}
- (void)setCatonInfo:(NSString *)catonInfo {
    _catonInfo = catonInfo;
}
- (void)setDelayInfo:(NSString *)delayInfo {
    _delayInfo = delayInfo;
}
- (void)setRtcInnerInfo:(NSString *)rtcInnerInfo {
    _rtcInnerInfo = rtcInnerInfo;
}
- (void)setChangedNum:(NSString *)changedNum {
    _changedNum = changedNum;
}
- (void)setStats:(NSArray *)stats {
//    for (RTCLegacyStatsReport *report in stats) {
//        [_statsBuilder parseStatsReport:report];
//    }
    NSString *outStr = [NSString stringWithFormat:@"%@ \n FirstFrame: %@ \n  videoSize w:%d, h:%d \n rtcInfo:%@ \n卡顿：%@ \n 延时：%@", self.sdkVerion, _headerInfo, (int)_vidoeSize.width, (int)_vidoeSize.height, _rtcInnerInfo, _catonInfo, _delayInfo];
    
    _statsLabel.text = outStr;
}


- (void)setStaticInfo:(NSString *)info {
    
    NSString *outStr = [NSString stringWithFormat:@"%@ \n FirstFrame: %@ \n videoSize w:%d,h:%d \n%@ \n%@ \n%@ \n%@", self.sdkVerion,  _headerInfo, (int)_vidoeSize.width, (int)_vidoeSize.height, _catonInfo, _rtcInnerInfo, _delayInfo, _changedNum];
    _statsLabel.text = outStr;
}

- (void)clear {
    _headerInfo = nil;
    _delayInfo = nil;
    _rtcInnerInfo = nil;
    _vidoeSize = CGSizeZero;
    _statsLabel.text = nil;
}

- (void)layoutSubviews {
    _statsLabel.frame = self.bounds;
}
- (CGSize)sizeThatFits:(CGSize)size {
    return [_statsLabel sizeThatFits:size];
}
- (void)onTapScreen:(UITapGestureRecognizer *)recognizer {
    //[self.videoCallViewDelegate didTripleTap:recognizer];
}



@end
