
--[[
Stack 堆栈
created by：caoyifan
]]

ARUtils.Stack = class()

function ARUtils.Stack:ctor(name)
	self.stack_name = name
    self.stack_table = {}
end

function ARUtils.Stack:push(element)
    local size = self:size()
    self.stack_table[size + 1] = element
end

function ARUtils.Stack:pop()
    local size = self:size()
    if self:isEmpty() then
        io.write("Error: Stack is empty! name:"..self.stack_name)
        return
    end
    return table.remove(self.stack_table,size)
end

function ARUtils.Stack:top()
    local size = self:size()
    if self:isEmpty() then
        io.write("Error: Stack is empty! name:"..self.stack_name)
        return
    end
    return self.stack_table[size]
end

function ARUtils.Stack:isEmpty()
    local size = self:size()
    if size == 0 then
        return true
    end
    return false
end

function ARUtils.Stack:size()
    return #self.stack_table or 0
end

function ARUtils.Stack:clear()
    self.stack_table = nil
    self.stack_table = {}
end

function ARUtils.Stack:print()
    local size = self:size()

    if self:isEmpty() then
        ARLOG("Error: Stack is empty! "..self.stack_name)
        return
    end

    local str = "{ stack name:"..self.stack_name..", size:"..self:size()..", element:"
    while size > 0 do
        str = str..", "..tostring(self.stack_table[size])
        size = size - 1
    end
    str = str.."}"
    io.write(str)
end