precision highp float;
varying highp vec2 v_tex_coord;
uniform sampler2D color_map;
uniform sampler2D color_map1;
//back ground
uniform sampler2D color_map2;
uniform int rotation;
uniform int ruliu_width;
uniform int ruliu_height;

void main() {
    float width = float(ruliu_width);
    float height = float(ruliu_height);
    float length_max = max(width, height);
    float length_min = min(width, height);
    float offset =  (length_max - length_min )/2.0;
    int is_portrait = 1;
    if (width > height) {
        is_portrait = 0;
    }  

    vec4 src = texture2D(color_map, v_tex_coord);
    vec4 mask = texture2D(color_map1, v_tex_coord);
    float x_ = v_tex_coord.x ;
    float y_ =  v_tex_coord.y;

    if( is_portrait == 1) {
        x_ =  (v_tex_coord.x * width + offset) / (width + offset + offset) ;
        y_ =  v_tex_coord.y;
    }else {
        x_ =  v_tex_coord.x ;
        y_ =  (v_tex_coord.y * height + offset) / (height + offset + offset) ;
    }

    vec2 v_tex_coord_rotation = vec2(x_ , y_) ;
    vec4 back = texture2D(color_map2, v_tex_coord_rotation);
   
    float ratio = clamp(((mask.r - 0.4) / 0.6), 0.0, 1.0);

    ratio = pow(ratio, 2.0) * (3.0 - 2.0 * ratio);

    gl_FragColor = mix(back, src, ratio);
}
