precision highp float;
varying highp vec2 v_tex_coord;
uniform sampler2D color_map;
uniform sampler2D color_map1;
//back ground
uniform sampler2D color_map2;
uniform int rotation;
uniform int ruliu_width;
uniform int ruliu_height;
uniform int ruliu_front;

void main() {
    float width = float(ruliu_width);
    float height = float(ruliu_height);
    float offset =  (width - height )/2.0;
    vec4 src = texture2D(color_map, v_tex_coord);
    vec4 mask = texture2D(color_map1, v_tex_coord);
    float x_ = v_tex_coord.x ;
    float y_ =  v_tex_coord.y;
    if (ruliu_front == 1) {
        if (rotation == 0 ) {
            x_ = 1.0 - (v_tex_coord.x * height + offset) / width;
            y_ =  v_tex_coord.y;
        }else if (rotation == 1 ) {
            x_ =  1.0 - v_tex_coord.y;
            y_ =  1.0 - (v_tex_coord.x * height + offset) / width;
        }else if (rotation == 2 ) {
            x_ =  v_tex_coord.y;
            y_ = (v_tex_coord.x * height + offset) / width;
        } 
    }else {
        if (rotation == 0 ) {
            x_ = (v_tex_coord.x * height + offset) / width;
            y_ =  v_tex_coord.y;
        }else if (rotation == 1 ) {
            x_ =  v_tex_coord.y;
            y_ =  1.0 - (v_tex_coord.x * height + offset) / width;
        }else if (rotation == 2 ) {
            x_ = 1.0 -  v_tex_coord.y;
            y_ =  (v_tex_coord.x * height + offset) / width;
        } 
    }

    vec2 v_tex_coord_rotation = vec2(x_ , y_) ;
    vec4 back = texture2D(color_map2, v_tex_coord_rotation);
   
    float ratio = clamp(((mask.r - 0.4) / 0.6), 0.0, 1.0);

    ratio = pow(ratio, 2.0) * (3.0 - 2.0 * ratio);

    gl_FragColor = mix(back, src, ratio);


}
