precision highp float;
varying highp vec2 v_tex_coord;
uniform sampler2D color_map;
uniform sampler2D color_map1;
uniform sampler2D maskTexture;
uniform vec4 mask_rotate;
uniform float alpha_ratio;

float rand(vec2 co) {
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main() {
   mat2 mask_matrix = mat2(mask_rotate.x, mask_rotate.y, mask_rotate.z, mask_rotate.w);
   vec2 mask_coord = mask_matrix * (v_tex_coord - vec2(0.5)) + vec2(0.5);
   vec4 mask = texture2D(maskTexture, mask_coord);
   vec4 back = texture2D(color_map, v_tex_coord);
   vec4 input_tex = texture2D(color_map1, v_tex_coord);

   gl_FragColor = mask;
}