custom_filter_pipline = function()
    fm = ae.FilterManager:get_instance();
    fm:reset_pipeline();

    skin_filter = fm:get_filter_id_by_name("globalSkinFilter")
    engine_filter = fm:get_filter_id_by_name("globalEngineFilter")
    face_filter = fm:get_filter_id_by_name("globalFaceFilter")
    lut_filter = fm:get_filter_id_by_name("globalLutFilter")
    color_filter = fm:get_filter_id_by_name("globalTuneColorFilter")

    gaussian_filter = fm:create_filter("GaussianBlurFilter",
                                       "caseGaussianFilter")

    platform_name = app:get_platform_name()
    if platform_name == 'android' then

        texture_filter = fm:create_filter_by_fragment_shader("Filter",
                                                             "textureFilter",
                                                             "texture_filter.fs", 2,
                                                             false)
    else
        texture_filter = fm:create_filter_by_fragment_shader("Filter",
                                                         "textureFilter",
                                                         "texture_filter_ios.fs", 2,
                                                         false)
    end




    
    fm:update_property_int(texture_filter, "is_enable", 0)

    fm:register_property_path(texture_filter, "color_map2",
                              "./res/texture/".."0"..".png")
    fm:register_property_int(texture_filter, "rotation", 0)
    fm:update_property_int(texture_filter, "rotation", 0)
    if platform_name == 'android' then
        fm:register_property_int(texture_filter, "ruliu_width", 640)
        fm:register_property_int(texture_filter, "ruliu_height", 480)
        fm:register_property_int(texture_filter, "ruliu_front", 1)
    else
        fm:register_property_int(texture_filter, "ruliu_width", 480)
        fm:register_property_int(texture_filter, "ruliu_height", 640)
    end



    copy_filter = fm:create_filter("Tex2DFilter", "caseTex2DFilter")
    blur_copy_filter = fm:create_filter("Tex2DFilter", "caseBlurCopyFilter")
    beauty_makeup_filter = fm:create_filter("BeautyMakeupFilter",
                                            "caseBeautyMakeupFilter")

    fs = "blur-filter.fs"
    blur_filter = fm:create_filter_by_fragment_shader("Filter", "blurFilter",
                                                      fs, 1, false)

    fm:register_property_texture(blur_filter, "maskTexture", 1)
    local mask_rotate_vec4 = ae.ARVec4:new_local(1.0, 0.0, 0.0, 1.0)
    fm:register_property_vec4(blur_filter, "mask_rotate", mask_rotate_vec4)
    fm:update_property_int(blur_filter, "is_enable", 0)

    fm:register_property_float(blur_filter, "alpha_ratio", 0.73)

    fm:connect_filter_to_camera(skin_filter)

    fm:connect_filters_by_id(skin_filter, blur_copy_filter)
    fm:connect_filters_by_id(blur_copy_filter, texture_filter)

    fm:connect_filters_by_id(skin_filter, blur_filter)
    fm:connect_filters_by_id(blur_filter, gaussian_filter)
    fm:connect_filters_by_id(gaussian_filter, texture_filter)

    fm:connect_filters_by_id(texture_filter, face_filter)

    fm:connect_filters_by_id(face_filter, lut_filter);    

    fm:connect_filter_to_output(lut_filter);

end
