app_controller = ae.ARApplicationController:shared_instance()
app_controller:require('./scripts/include.lua')
app = AR:create_application(AppType.Imu, "demo")

-- 加载scene
app:load_scene_from_json("res/simple_scene.json", "demo_scene")
scene = app:get_current_scene()

-- 加载滤镜配置文件
app_controller:require("./filter_pipline.lua")

pic_rot = 0
custom_filter_pipline()

case_ruliu_width = 640
case_ruliu_height = 480
case_ruliu_front = 1
case_ruliu_rotation = 0

app.on_loading_finish = function()
    
    app:set_algo_data_handler(handle_data)
    PaddleImgseg:send_control_msg(1, "seg_plane")

    local msg = {}
    msg["event_name"] = "enable_ui_interaction_with_filter"
    msg["event_id"] = 0
    app_controller:send_message_to_native(msg)

end


app.device.on_device_rotate = function(orientation)


end

handle_data = function(mapdata)

    local handle_data_array = mapdata["texture_array_data"]
    if type(handle_data_array) ~= "nil" then
        -- ARLOG("-=-=-=-=-=-=--== handle_data: update_property_texture_handle -=-=-=-=-=-=-")
        local handle_data = handle_data_array[0]
        fm:update_property_texture_handle(blur_filter, "maskTexture",
                                          handle_data)
        fm:update_property_int(blur_filter, "is_enable", 1)
        fm:update_property_int(texture_filter, "is_enable", 1)
    else
        -- ARLOG("-=-=-=-=-=-=--== handle_data: update_property_texture -=-=-=-=-=-=-")
        local handle_data = mapdata["handle"]
        if type(handle_data) ~= "nil" then
            fm:update_property_texture(blur_filter, "maskTexture", handle_data)
            fm:update_property_int(blur_filter, "is_enable", 1)
            fm:update_property_int(texture_filter, "is_enable", 1)            
        end
    end

    update_orientation(mapdata)

end

function get_screen_size(...)
    local screen_size = app:get_property_vec2("screen_size")
    if type(screen_size) ~= "nil" then
        screen_width = screen_size.x
        screen_height = screen_size.y
        ARLOG("BBDebug: " .. screen_width .. " * " .. screen_height)
        -- fm:update_property_int(texture_filter, "ruliu_width", screen_width)
        -- fm:update_property_int(texture_filter, "ruliu_height", screen_height)
    end
end

function open_ability_face_model(...)
    local msg = {}
    msg["event_name"] = "ability_operation"
    msg["ability_action"] = "open" -- open/close/adjust 三选一
    msg["ability_name"] = "ability_face_model"
    app_controller:send_message_to_native(msg)
end

update_orientation = function(mapdata)
    if type(mapdata) == "nil" then
        ARLOG("bg_xuhua - update_orientation : type(mapdata) = nil ")
        return
    end

    local orientation = mapdata["orientation"]
    if type(orientation) ~= "nil" then
        -- ARLOG("bg_xuhua - update_orientation : orientation = " .. orientation)
        local mask_rotate_vec4 = ae.ARVec4:new_local(1.0, 0.0, 0.0, 1.0) -- VEC_NO_ROTATE
        -- Landscape Support
        if (orientation == 1) then
            mask_rotate_vec4 = ae.ARVec4:new_local(0.0, 1.0, -1.0, 0.0) -- VEC_ROTATE_LEFT
        elseif (orientation == 2) then
            mask_rotate_vec4 = ae.ARVec4:new_local(0.0, -1.0, 1.0, 0.0) -- VEC_ROTATE_RIGHT            
        elseif (orientation == 3) then
            mask_rotate_vec4 = ae.ARVec4:new_local(1.0, 0.0, 0.0, -1.0) -- VEC_FLIP_VERTICAL
        elseif (orientation == 4) then
            mask_rotate_vec4 = ae.ARVec4:new_local(-1.0, 0.0, 0.0, 1.0) -- VEC_FLIP_HORIZONTAL
        elseif (orientation == 5) then
            mask_rotate_vec4 = ae.ARVec4:new_local(0.0, 1.0, 1.0, 0.0) -- VEC_ROTATE_RIGHT_FLIP_VERTICAL
        elseif (orientation == 6) then
            mask_rotate_vec4 = ae.ARVec4:new_local(0.0, -1.0, -1.0, 0.0) -- VEC_ROTATE_RIGHT_FLIP_HORIZONTAL
        elseif (orientation == 7) then
            mask_rotate_vec4 = ae.ARVec4:new_local(-1.0, 0.0, 0.0, -1.0) -- VEC_ROTATE_180
        end
        fm:update_property_vec4(blur_filter, "mask_rotate", mask_rotate_vec4)
    end
end

-- Receive & Process native message
app_controller:set_native_message_handler(
    function(msg) handle_native_message(msg) end)

-- Analyse Face exist or not
-- 0无人脸, 1有人脸
local last_face_state = 0
function handle_native_message(msg)
    local event_name = msg['event_name']
    if event_name == nil then
        ARLOG("------ FaceDetect event_name == nil")
        return
    end

    if event_name == "update_bg_texture" then
        ARLOG("case_update_bg_texture " )
        custom_filter_pipline()

        platform_name = app:get_platform_name()
        if platform_name == 'android' then
            if type(case_ruliu_rotation) ~= "nil" then
                ARLOG("case_update_bg_texture " .. " r:" .. case_ruliu_rotation )
                fm:update_property_int(texture_filter, "rotation", case_ruliu_rotation)
            end

            if type(case_ruliu_width) ~= "nil" then
                 if type(case_ruliu_height) ~= "nil" then
                    ARLOG("case_update_bg_texture " .. " w:" .. case_ruliu_width )
                    fm:update_property_int(texture_filter, "ruliu_width", case_ruliu_width)
                    ARLOG("case_update_bg_texture " .. " h:" .. case_ruliu_height )
                    fm:update_property_int(texture_filter, "ruliu_height", case_ruliu_height)
                end
            end
            
            if type(case_ruliu_front) ~= "nil" then
                ARLOG("case_update_bg_texture " .." f:" .. case_ruliu_front)
                fm:update_property_int(texture_filter, "ruliu_front", case_ruliu_front)
            end            
        end
        
    end

    if event_name == "update_ruliu_rotation" then
        -- ARLOG("case_update_ruliu_rotation")
        local orientation = msg["event_data"]["rotation"]
        if type(orientation) ~= "nil" then
            ARLOG("case_update_ruliu_rotation:orientation " .. orientation)
            if( orientation == 1) then
                pic_rot = 1
                -- custom_filter_pipline()
                fm:update_property_int(texture_filter, "rotation", pic_rot)
            elseif( orientation  == 2) then-- 右横屏
                pic_rot = 2
                -- custom_filter_pipline()
                fm:update_property_int(texture_filter, "rotation", pic_rot)
            elseif ( orientation == 0) then
                pic_rot = 0
                -- custom_filter_pipline()
                fm:update_property_int(texture_filter, "rotation", pic_rot)
            end
        end  

        local ruliu_width = msg["event_data"]["ruliu_width"]
        if type(ruliu_width) ~= "nil" then
            ARLOG("case_update_ruliu_rotation:ruliu_width " .. ruliu_width)
            case_ruliu_width = ruliu_width
            fm:update_property_int(texture_filter, "ruliu_width", ruliu_width)
        end 

        local ruliu_height = msg["event_data"]["ruliu_height"]
        if type(ruliu_height) ~= "nil" then
            ARLOG("case_update_ruliu_rotation:ruliu_height " .. ruliu_height)
            case_ruliu_height = ruliu_height
            fm:update_property_int(texture_filter, "ruliu_height", ruliu_height)
        end 
        local ruliu_front = msg["event_data"]["ruliu_front"]
        if type(ruliu_front) ~= "nil" then
            ARLOG("case_update_ruliu_rotation:ruliu_front " .. ruliu_front)
            case_ruliu_front = ruliu_front
            fm:update_property_int(texture_filter, "ruliu_front", ruliu_front)
        end 

    end

    local face_state = msg["bool_face_headpose"]
    -- ARLOG("------ bool_face_headpose = " .. face_state)
    if (type(face_state) ~= "nil") then
        if (last_face_state ~= face_state) then
            last_face_state = face_state
            -- ARLOG("------ FaceDetect face_state = " .. face_state)
            if (face_state == 1) then
                -- ARLOG("------ FaceDetect Found Face!")
                -- scene:get_node_by_name("seg_plane"):set_visible(true)
                -- fm:update_property_int(blur_filter, "is_enable", 1)
            else
                -- ARLOG("------ FaceDetect Face Lost !")
                -- scene:get_node_by_name("seg_plane"):set_visible(false)
                -- fm:update_property_int(blur_filter, "is_enable", 0)
            end
        end
    end
end
