
--[[
Quene 队列
created by：caoyifan
]]

ARUtils.Quene = class()

--notice：本对列实现为循环队列，队列能储存的最大个数为capacity-1

function ARUtils.Quene:ctor(name, capacity)
	self.quene_name = name
    self.capacity = capacity
    self.quene = {}
    self.size_ = 0
    self.head = -1
    self.rear = -1
end

function ARUtils.Quene:push(element)
    if self.size_ == 0 then
        self.head = 0
        self.rear = 1
        self.size_ = 1
        self.quene[self.rear] = element
    else
        local temp = (self.rear + 1) % self.capacity
        if temp == self.head then
            io.write("Error: Quene capacity is full, name:"..self.quene_name)
            return 
        else
            self.rear = temp
        end

        self.quene[self.rear] = element
        self.size_ = self.size_ + 1
    end

end

function ARUtils.Quene:pop()
    if self:is_empty() then
        io.write("Error: The quene is empty, name"..self.quene_name)
        return
    end
    self.size_ = self.size_ - 1
    self.head = (self.head + 1) % self.capacity
    local value = self.quene[self.head]
    return value
end

function ARUtils.Quene:clear()
    self.quene = nil
    self.quene = {}
    self.size_ = 0
    self.head = -1
    self.rear = -1
end

function ARUtils.Quene:is_empty()
    if self.head == self.rear then
        return true
    end
    return false
end

function ARUtils.Quene:is_full()
    local temp = (self.rear + 1) % self.capacity
    if temp == self.head then
        return true
    else
        return false
    end

end

function ARUtils.Quene:size()
    return self.size_
end

function ARUtils.Quene:get_array()
	local array = {}

	if (self.size_ == 0) then
		return array
	end
    local first_flag = true

    local h = self.head
    local r = self.rear

    while h ~= r do
        if first_flag == true then
            h = (h + 1) % self.capacity
            first_flag = false
        else
            local value = self.quene[h]
            table.insert(array, value)
            h = (h + 1) % self.capacity
        end
    end
    local value = self.quene[r]
    table.insert(array, value)
	return array
end

function ARUtils.Quene:print()
    local h = self.head
    local r = self.rear
    local str = ""
	local first_flag = true

    if (h == r) then
        io.write("quene name:"..self.quene_name.." is empty.")
        return
    end

    while h ~= r do
        if first_flag == true then
            str = "{ quene name:"..self.quene_name..", elements:"
            h = (h + 1) % self.capacity
            first_flag = false
        else
            str = str..","..self.quene[h]
            h = (h + 1) % self.capacity
        end
	end
	str = str..","..self.quene[r].."}"
    io.write(str)
end