precision highp float;
varying highp vec2 v_tex_coord;
uniform sampler2D color_map;

uniform vec2 headCenter;
uniform vec2 footCenter;
uniform vec2 cupHeadCenter;
uniform vec2 cupLegCenter;
uniform float effect;
uniform int selectedMagicType;
uniform vec2 dripTopCenter;
uniform vec2 dripFootCenter;
uniform vec2 dripCircleCenter;
uniform int passThrough;

vec2 offset;
vec2 uv;
vec2 kneeCenter;
vec2 hipCenter;
vec2 waistCenter;
vec2 dv;
float scale;
vec2 node;
vec2 offsetY;
float radius;
float x;
float angle;

vec4 cupBodyCenter;

uniform lowp vec2 location0;
uniform lowp vec2 location1;
uniform lowp vec2 location2;
uniform lowp vec2 location5;
uniform lowp vec2 location8;
uniform lowp vec2 location9;
uniform lowp vec2 location10;
uniform lowp vec2 location11;
uniform lowp vec2 location12;
uniform lowp vec2 location13;

uniform lowp vec2 test;

float getDistance(vec2 pos_src, vec2 pos_dist) {
    float quadratic_sum = pow((pos_src.x - pos_dist.x), 2.) + pow((pos_src.y - pos_dist.y), 2.);
    return sqrt(quadratic_sum);
}

void switchMagicType() {
    if (selectedMagicType == 1) {
        
        cupBodyCenter = vec4((cupHeadCenter.x + cupLegCenter.x)/2.0,(cupHeadCenter.y + cupLegCenter.y)/2.0,0,1.0);
        vec2 midline = vec2(cupHeadCenter.x, v_tex_coord.y);
        
        vec2 node = vec2(0.0, cupBodyCenter.y);
        if (v_tex_coord.y < cupBodyCenter.y && v_tex_coord.y >= (2.0*cupHeadCenter.y - cupBodyCenter.y)) {
            
            vec2 dv = midline.xy - v_tex_coord.xy;
            
            vec2 topPosLeft = vec2(-0.25, cupHeadCenter.y);
            float a = (node.x-topPosLeft.x)/pow(node.y - topPosLeft.y, 2.0);
            vec2 newPos = vec2(a * pow(v_tex_coord.y - topPosLeft.y, 2.0) + topPosLeft.x + v_tex_coord.x, v_tex_coord.y);
            
            if (effect - abs(cupHeadCenter.x - v_tex_coord.x) >= 0.0) {
                scale = (effect - abs(cupHeadCenter.x - v_tex_coord.x)) / effect;
            } else {
                scale = 0.0;
            }
            vec2 dvY = v_tex_coord.xy - vec2(v_tex_coord.x, cupHeadCenter.y);
            float value;
            if (v_tex_coord.y <= cupHeadCenter.y) {
                value = (2.0*cupHeadCenter.y - cupBodyCenter.y - v_tex_coord.y) / (2.0*cupHeadCenter.y - cupBodyCenter.y - cupHeadCenter.y);
            } else {
                value = 1.0;
            }
            
            offset = normalize(dv) * (distance(v_tex_coord.xy, newPos) * length(dv)) * scale * 4.0 * (1.0-scale);
            offsetY = normalize(dvY) * (distance(v_tex_coord.xy, vec2(v_tex_coord.x, cupHeadCenter.y)) * length(dvY)) * value;
            uv = v_tex_coord.xy + offset + offsetY;
            gl_FragColor = texture2D(color_map, uv);
        }
        else if (v_tex_coord.y >= cupBodyCenter.y && v_tex_coord.y < (2.0*cupLegCenter.y - cupBodyCenter.y)) {
            
            vec2 dv = v_tex_coord.xy - midline.xy;
            
            vec2 topPosLeft = vec2(0.25, cupLegCenter.y);
            float a = (node.x-topPosLeft.x)/pow(node.y-topPosLeft.y, 2.0);
            vec2 newPos = vec2(a*pow(v_tex_coord.y-topPosLeft.y, 2.0)+topPosLeft.x+v_tex_coord.x, v_tex_coord.y);
            
            if (effect - abs(cupLegCenter.x - v_tex_coord.x) >= 0.0) {
                scale = (effect - abs(cupLegCenter.x - v_tex_coord.x))/effect;
            } else {
                scale = 0.0;
            }
            float overvalue;
            if (v_tex_coord.y >= cupLegCenter.y) {
                overvalue = (v_tex_coord.y - (2.0*cupLegCenter.y - cupBodyCenter.y))/(cupBodyCenter.y-cupLegCenter.y);
            } else {
                overvalue = 1.0;
            }
            vec2 dvY = vec2(v_tex_coord.x, topPosLeft.y) - v_tex_coord.xy;
            
            offset = normalize(dv)*(distance(v_tex_coord.xy,newPos)*length(dv))*pow(scale, 2.0) *3.0;
            
            offsetY = normalize(dvY)*(distance(v_tex_coord.xy,vec2(v_tex_coord.x,topPosLeft.y))*length(dvY))*overvalue;
            uv = v_tex_coord.xy + offset + offsetY;
            gl_FragColor = texture2D(color_map, uv);
        } else {
            gl_FragColor = texture2D(color_map,v_tex_coord);
        }
        
    } else if (selectedMagicType == 2) {
        
        if(v_tex_coord.y >dripCircleCenter.y && v_tex_coord.y < (dripFootCenter.y*2.0 - dripCircleCenter.y)){
            
            vec2 midline = vec2(dripFootCenter.x,v_tex_coord.y);
            
            vec2 node = vec2(0.0,dripCircleCenter.y);
            vec2 dv = midline.xy - v_tex_coord;
            
            vec2 topPosLeft = vec2(-0.25, dripFootCenter.y);
            float a = (node.x-topPosLeft.x)/pow(node.y - topPosLeft.y,2.0);
            vec2 newPos = vec2(a*pow(v_tex_coord.y - topPosLeft.y,2.0)+topPosLeft.x + v_tex_coord.x,v_tex_coord.y);
            
            if(effect -abs(dripFootCenter.x - v_tex_coord.x) > 0.0){
                scale = (effect - abs(dripFootCenter.x - v_tex_coord.x)) / effect ;
            }
            
            else{
                scale = 0.0;
            }
            
            offset = normalize(dv) * (distance(v_tex_coord,newPos)*length(dv))*scale* 5.0*(1.0-scale);
            uv =v_tex_coord + offset;
            
            gl_FragColor = texture2D(color_map,uv);
        }
        
        else if(v_tex_coord.y <= dripCircleCenter.y && v_tex_coord.y >
                dripTopCenter.y-(dripCircleCenter.y-dripTopCenter.y)){
            
            vec2 midline = vec2(dripTopCenter.x,v_tex_coord.y);
            vec2 node = vec2(0.0,dripCircleCenter.y);
            vec2 dv = v_tex_coord - midline.xy;
            
            vec2 topPosLeft = vec2(0.5, dripTopCenter.y);
            float a = (node.x-topPosLeft.x)/pow(node.y - topPosLeft.y,2.0);
            vec2 newPos = vec2(a*pow(v_tex_coord.y - topPosLeft.y,2.0)+topPosLeft.x + v_tex_coord.x,v_tex_coord.y);
            
            if(effect -abs(dripTopCenter.x - v_tex_coord.x) > 0.0){
                scale = (effect - abs(dripTopCenter.x - v_tex_coord.x)) / effect;
            }
            
            else{
                scale = 0.0;
            }
            offset = normalize(dv) * (distance(v_tex_coord,newPos)*length(dv))*pow(scale, 2.0)*3.0;
            uv =v_tex_coord + offset;
            
            gl_FragColor = texture2D(color_map,uv);
            //                  gl_FragColor = texture2D(color_map,v_tex_coord);
        } else {
            gl_FragColor = texture2D(color_map,v_tex_coord);
        }
        
    } else {
        float dis = distance(headCenter.y,footCenter.y) / 4.0;
        kneeCenter = vec2(footCenter.x,footCenter.y - dis);
        hipCenter = vec2(footCenter.x,footCenter.y - dis * 2.0);
        waistCenter = vec2(headCenter.x, headCenter.y + dis);
        vec2 topPos;
        
        if (v_tex_coord.y > (headCenter.y - dis/2.0) && v_tex_coord.y < (footCenter.y + dis/2.0)) {
            
            if ((effect - abs(headCenter.x - v_tex_coord.x)) > 0.0) {
                scale = (effect - abs(headCenter.x - v_tex_coord.x)) / effect;
            } else {
                scale = 0.0;
            }
            
            if (v_tex_coord.y <= (headCenter.y + dis/2.0)) {
                
                vec2 midline = vec2(headCenter.x,v_tex_coord.y);
                node = vec2(0.0, headCenter.y + dis/2.0);
                
                dv = midline.xy - v_tex_coord;
                topPos = vec2(-0.2, headCenter.y);
                
                float a = (node.x-topPos.x)/pow(node.y - topPos.y, 2.0);
                vec2 newPos = vec2(a * pow(v_tex_coord.y - topPos.y, 2.0) + topPos.x + v_tex_coord.x, v_tex_coord.y);
                offset = normalize(dv) * (distance(v_tex_coord,newPos) * length(dv)) * scale * 3.0 * (1.0-scale);
                
            } else if (v_tex_coord.y > (waistCenter.y - dis/2.0) && v_tex_coord.y <= (waistCenter.y + dis/2.0)) {
                
                vec2 midline = vec2(waistCenter.x,v_tex_coord.y);
                node = vec2(0,headCenter.y + dis/2.0);
                
                dv = v_tex_coord - midline.xy;
                topPos = vec2(0.2, waistCenter.y);
                
                float a = (node.x-topPos.x)/pow(node.y - topPos.y, 2.0);
                vec2 newPos = vec2(a * pow(v_tex_coord.y - topPos.y, 2.0) + topPos.x + v_tex_coord.x, v_tex_coord.y);
                offset = normalize(dv) * (distance(v_tex_coord,newPos) * length(dv)) * scale * 2.0;
                
            } else if (v_tex_coord.y > (hipCenter.y - dis/2.0) && v_tex_coord.y <= (hipCenter.y + dis/2.0)) {
                
                vec2 midline = vec2(hipCenter.x,v_tex_coord.y);
                node = vec2(0,hipCenter.y + dis/2.0);
                
                dv = midline.xy - v_tex_coord;
                topPos = vec2(-0.2, hipCenter.y);
                
                float a = (node.x-topPos.x)/pow(node.y - topPos.y, 2.0);
                vec2 newPos = vec2(a * pow(v_tex_coord.y - topPos.y, 2.0) + topPos.x + v_tex_coord.x, v_tex_coord.y);
                offset = normalize(dv) * (distance(v_tex_coord,newPos) * length(dv)) * scale * 4.0 * (1.0-scale);
                
            } else if (v_tex_coord.y > (kneeCenter.y - dis/2.0) && v_tex_coord.y <= (kneeCenter.y + dis/2.0)) {
                
                vec2 midline = vec2(kneeCenter.x,v_tex_coord.y);
                node = vec2(0,hipCenter.y + dis/2.0);
                
                dv = v_tex_coord - midline.xy;
                topPos = vec2(0.2, kneeCenter.y);
                
                float a = (node.x-topPos.x)/pow(node.y - topPos.y, 2.0);
                vec2 newPos = vec2(a * pow(v_tex_coord.y - topPos.y, 2.0) + topPos.x + v_tex_coord.x, v_tex_coord.y);
                offset = normalize(dv) * (distance(v_tex_coord,newPos) * length(dv)) * scale * 2.0;
                
            } else if (v_tex_coord.y < (footCenter.y - dis/2.0)) {
                
                vec2 midline = vec2(footCenter.x,v_tex_coord.y);
                node = vec2(0,footCenter.y + dis/2.0);
                
                dv = midline.xy - v_tex_coord;
                topPos = vec2(-0.2, footCenter.y);
                
                float a = (node.x-topPos.x)/pow(node.y - topPos.y, 2.0);
                vec2 newPos = vec2(a * pow(v_tex_coord.y - topPos.y, 2.0) + topPos.x + v_tex_coord.x, v_tex_coord.y);
                offset = normalize(dv) * (distance(v_tex_coord,newPos) * length(dv)) * scale * 4.0 * (1.0-scale);
            }
            
            uv = v_tex_coord + offset;
            gl_FragColor = texture2D(color_map, uv);
            
        } else {
            gl_FragColor = texture2D(color_map,v_tex_coord);
        }
    }
}

void main() {
        
    if (passThrough == 1) {
        gl_FragColor = texture2D(color_map,v_tex_coord);

    } else {
        switchMagicType();
    }
    
}
