custom_filter_pipline = function()
    fm = ae.FilterManager:get_instance();
    fm:reset_pipeline();
--[[
    skin_filter = fm:create_filter("SkinFilter", "globalSkinFilter", true);
    engine_filter = fm:create_filter("EngineFilter", "globalEngineFilter", true);
    face_filter = fm:create_filter("FaceFilter", "globalFaceFilter", true);
    lut_filter = fm:create_filter("LUTFilter", "globalLutFilter", true);

    origin_filter = fm:create_filter("Tex2DFilter", "globalTex2DFilter", true);
    copy_filter0 = fm:create_filter("Tex2DFilter", "globalTex2DFilter0", true);
    beauty_makeup_filter = fm:create_filter("BeautyMakeupFilter", "globalBeautyMakeupFilter", true);
]]


    skin_filter = fm:get_filter_id_by_name("globalSkinFilter")
    engine_filter = fm:get_filter_id_by_name("globalEngineFilter")
    face_filter = fm:get_filter_id_by_name("globalFaceFilter")
    lut_filter = fm:get_filter_id_by_name("globalLutFilter")

    origin_filter = fm:create_filter("Tex2DFilter", "caseTex2DFilter")
    copy_filter0 = fm:create_filter("Tex2DFilter", "caseTex2DFilter0")
    beauty_makeup_filter = fm:create_filter("BeautyMakeupFilter", "caseBeautyMakeupFilter")


    
    -- gauss_filter = fm:create_filter("GaussianBlurFilter","caseBgGaussianFilter", false)
    -- fm:update_property_int(gauss_filter, "radius", 5)
    -- platform_name = app:get_platform_name()
    -- if platform_name == 'android' then
    --     fm:update_property_float(gauss_filter, "sigma", 15.0)
    -- else 
    --     fm:update_property_float(gauss_filter, "sigma", 20.0)
    -- end

    platform_name = app:get_platform_name()
    if platform_name == 'android' then
        gauss_filter = fm:create_filter("GaussianBlurFilter","caseBgGaussianFilter", false)
        fm:update_property_int(gauss_filter, "radius", 5)
        fm:update_property_float(gauss_filter, "sigma", 15.0)
    else 
        gauss_vs = "gauss.vs"
        guass_fs = "gauss.fs"
        gauss_filter = fm:create_filter_by_shader("Filter","wblurFilter",gauss_vs,guass_fs, false)
        -- gauss_filter = fm:create_filter_by_fragment_shader("Filter", "xblurFilter", guass_fs , 1 ,false);
        fm:register_property_float(gauss_filter, "texel_width_offset", 0.0015625)    
        fm:register_property_float(gauss_filter, "texel_height_offset", 0.0)

        gauss_filter_h = fm:create_filter_by_shader("Filter","hvblurFilter",gauss_vs,guass_fs, false)
        -- gauss_filter = fm:create_filter_by_fragment_shader("Filter", "xblurFilter", guass_fs , 1 ,false);
        fm:register_property_float(gauss_filter_h, "texel_width_offset", 0.0)    
        fm:register_property_float(gauss_filter_h, "texel_height_offset", 0.0015625)

    end

    fs = "blur-filter.fs"
    blur_filter = fm:create_filter_by_fragment_shader("Filter", "blurFilter", fs , 2 ,false);
    
    fm:register_property_texture(blur_filter, "maskTexture", 1)
    local mask_rotate_vec4 = ae.ARVec4:new_local(1.0, 0.0, 0.0, 1.0)
    fm:register_property_vec4(blur_filter, "mask_rotate", mask_rotate_vec4)
    fm:update_property_int(blur_filter, "is_enable", 0)



    
    -- fm:connect_filters_by_id(origin_filter, beauty_makeup_filter);
    -- fm:connect_filters_by_id(origin_filter, copy_filter0);
    -- fm:connect_filters_by_id(copy_filter0, beauty_makeup_filter);

    fm:connect_filter_to_camera(skin_filter);
    -- fm:connect_filters_by_id(beauty_makeup_filter, skin_filter);
    fm:connect_filters_by_id(skin_filter, blur_filter);
    fm:connect_filters_by_id(skin_filter, gauss_filter);
    if platform_name == 'android' then
        fm:connect_filters_by_id(gauss_filter, blur_filter);
    else
        fm:connect_filters_by_id(gauss_filter, gauss_filter_h);
        fm:connect_filters_by_id(gauss_filter_h, blur_filter);
    end
    fm:connect_filters_by_id(blur_filter, face_filter);
    fm:connect_filters_by_id(face_filter, lut_filter);
    
    fm:connect_filter_to_output(lut_filter);

end
