//
//  UIColor+RtcCategory.m
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/8/8.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import "UIColor+RtcCategory.h"

@implementation UIColor (RtcCategory)
+ (UIColor *)colorWithHex:(unsigned int)hex
{
    int a = (hex & 0xFF000000) ? (hex & 0xFF000000) >> 24 : 255.0;
    int r = (hex & 0x00FF0000) >> 16;
    int g = (hex & 0x0000FF00) >> 8;
    int b = (hex & 0x000000FF);
    return [UIColor colorWithRed:r/255.0 green:g/255.0 blue:b/255.0 alpha:a];
}

+ (UIColor *)colorWithHex:(unsigned int)hex alpha:(CGFloat)alpha
{
    int r = (hex >> 16) & 0xFF;
    int g = (hex >> 8) & 0xFF;
    int b = (hex) & 0xFF;
    return [UIColor colorWithRed:r/255.0 green:g/255.0 blue:b/255.0 alpha:alpha];
}
@end
