//
//  UIColor+RtcCategory.h
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/8/8.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface UIColor (RtcCategory)
/*!
 @method colorWithHex:
 @abstract 把十六进制转成 UIColor，如0x666666(RGB),0xff666666(ARGB)
 @param hex 十六进制颜色值
 @result 返回UIColor对象
 */
+ (UIColor *)colorWithHex:(unsigned int)hex;

/*!
 @method colorWithHex:alpha:
 @abstract 把十六进制转成 UIColor
 @param hex 十六进制颜色值不函透明值
 @param alpha 透明度为0.0~1.0
 @result 返回UIColor对象
 */
+ (UIColor *)colorWithHex:(unsigned int)hex alpha:(CGFloat)alpha;
@end

NS_ASSUME_NONNULL_END
