//
//  RTCSettingsStore.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/11/27.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCStoreFile.h"

static NSString *const kRtcStoreConfigKey = @"rtc_store_config_key";


NS_ASSUME_NONNULL_BEGIN
@interface RTCStoreFile () {
    
}
@end

@implementation RTCStoreFile


- (id)init {
    if (self = [super init]) {

    }
    return self;
}

+ (id)loadFromLocal {
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    NSData *encodedObject = [defaults objectForKey:kRtcStoreConfigKey];
    RTCStoreFile *object = [NSKeyedUnarchiver unarchiveObjectWithData:encodedObject];
    return object;
}

- (void)saveToLocal {
    NSData *encodedObject = [NSKeyedArchiver archivedDataWithRootObject:self];
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    [defaults setObject:encodedObject forKey:kRtcStoreConfigKey];
    [defaults synchronize];
}

#pragma mark -- encoder

- (void)encodeWithCoder:(NSCoder *)encoder {
#define ENCODE_OBJ(x)       [encoder encodeObject:self.x forKey:@#x]
#define ENCODE_BOOL(x)      [encoder encodeObject:@(self.x) forKey:@#x]

    ENCODE_OBJ(audioProfile);
    ENCODE_OBJ(audioScenario);
    ENCODE_OBJ(videoCodec);
    ENCODE_OBJ(audioCodec);
    ENCODE_OBJ(maxBitrate);
    ENCODE_OBJ(minBitrate);
    ENCODE_OBJ(videoFps);
    ENCODE_OBJ(captureVideoResolution);
    ENCODE_OBJ(videoResolution);
    ENCODE_OBJ(videoDegradation);

    // screen share
    ENCODE_OBJ(screenResolution);
    ENCODE_OBJ(screenMaxBitrate);
    ENCODE_OBJ(screenMinBitrate);
    ENCODE_OBJ(screenVideoFps);

    // whiteboard
    ENCODE_OBJ(boardTransparency);
    ENCODE_OBJ(boardToolType);
    ENCODE_OBJ(boardToolColor);
    ENCODE_OBJ(boardBgColor);
    ENCODE_BOOL(boardAudience);

    ENCODE_BOOL(isFixedResolution);
    ENCODE_BOOL(isExportAudioRecord);
    ENCODE_BOOL(isExportAudioPlayout);
    ENCODE_BOOL(isExportAudioRecordPlayoutMix);
    ENCODE_BOOL(isEnableModeCaptureExternal);
    ENCODE_BOOL(sessionMode);
    ENCODE_BOOL(createAecDump);
    ENCODE_BOOL(useLevelController);
    ENCODE_BOOL(useManualAudioConfig);
    ENCODE_BOOL(isEnableExternalAudioDevice);
    ENCODE_BOOL(noiseSuppression);
    ENCODE_BOOL(echoCancellation);
    ENCODE_BOOL(voiceGain);
    ENCODE_BOOL(logEnableVerbose);
    ENCODE_BOOL(isCompulsive);
    ENCODE_BOOL(isAutoReconnect);

    ENCODE_BOOL(remoteSubscribeOpt);
    ENCODE_BOOL(videoEnHance);
    ENCODE_BOOL(superResolution);
    ENCODE_BOOL(waterMarkEnable);
    ENCODE_BOOL(lockCameraOrient);
    ENCODE_BOOL(videoBeauty);
    ENCODE_BOOL(enableAudioVolumeIndication);
    
    ENCODE_BOOL(is1V1);

    ENCODE_BOOL(isMsgDataChannel);
    ENCODE_BOOL(isMultiStreamMode);
    ENCODE_BOOL(isReportWatchSli);
    ENCODE_OBJ(signalMode);

    ENCODE_BOOL(isLiveMix);
    ENCODE_BOOL(isLiveRecord);
    ENCODE_OBJ(liveUrl);
    ENCODE_OBJ(liveMixTemplate);
    ENCODE_OBJ(liveTransferMode);
    ENCODE_OBJ(serverHost);
    ENCODE_OBJ(serverAppId);
    ENCODE_OBJ(serverToken);
    ENCODE_OBJ(serverUserId);
    ENCODE_OBJ(mediaServerIp);
    ENCODE_OBJ(roomName);
    ENCODE_BOOL(showMeetingMode);
    ENCODE_OBJ(encryptMode);


    // lastmile
    ENCODE_OBJ(probeServerUrl);
    ENCODE_OBJ(probeUplinkKbps);
    ENCODE_OBJ(probeDownlinkKbps);
    
    // RTCSettingContext
    ENCODE_OBJ(usingFrontCamera);
    ENCODE_OBJ(videoBgPushMode);
    ENCODE_BOOL(hasVideo);
    ENCODE_BOOL(hasAudio);
    ENCODE_BOOL(hasRemoteAudio);
    ENCODE_BOOL(hasRemoteVideo);
    ENCODE_BOOL(isAutoPublish);
    ENCODE_BOOL(isAutoSubscribe);
    ENCODE_BOOL(isVideoPullDemote);

    ENCODE_OBJ(subscribeMode);
    ENCODE_OBJ(subscribeCount);

    ENCODE_BOOL(isOnlineMode);
    ENCODE_BOOL(logQualityMonitor);
    ENCODE_BOOL(logWeakNetQualityReport);

#undef ENCODE_BOOL
#undef ENCODE_OBJ
}

#pragma mark -- decoder

- (id)initWithCoder:(NSCoder *)decoder {
    if (self = [super init]) {
#define DECODE_OBJ(x)       self.x = [decoder decodeObjectForKey:@#x]
#define DECODE_BOOL(x)      self.x = [[decoder decodeObjectForKey:@#x] boolValue]

        DECODE_OBJ(audioProfile);
        DECODE_OBJ(audioScenario);
        DECODE_OBJ(videoCodec);
        DECODE_OBJ(audioCodec);
        DECODE_OBJ(maxBitrate);
        DECODE_OBJ(videoFps);
        DECODE_OBJ(captureVideoResolution);
        DECODE_OBJ(videoResolution);
        DECODE_OBJ(videoDegradation);

        // screen share
        DECODE_OBJ(screenResolution);
        DECODE_OBJ(screenMaxBitrate);
        DECODE_OBJ(screenMinBitrate);
        DECODE_OBJ(screenVideoFps);

        // whiteboard
        DECODE_OBJ(boardTransparency);
        DECODE_OBJ(boardToolType);
        DECODE_OBJ(boardToolColor);
        DECODE_OBJ(boardBgColor);
        DECODE_BOOL(boardAudience);


        DECODE_BOOL(isFixedResolution);
        DECODE_BOOL(isExportAudioRecord);
        DECODE_BOOL(isExportAudioPlayout);
        DECODE_BOOL(isExportAudioRecordPlayoutMix);
        DECODE_BOOL(isEnableModeCaptureExternal);
        DECODE_BOOL(sessionMode);
        DECODE_BOOL(createAecDump);
        DECODE_BOOL(useLevelController);
        DECODE_BOOL(useManualAudioConfig);
        DECODE_BOOL(isEnableExternalAudioDevice);
        DECODE_BOOL(noiseSuppression);
        DECODE_BOOL(echoCancellation);
        DECODE_BOOL(voiceGain);
        DECODE_BOOL(logEnableVerbose);
        DECODE_BOOL(isCompulsive);
        DECODE_BOOL(isAutoReconnect);

        
        DECODE_BOOL(remoteSubscribeOpt);
        DECODE_BOOL(videoEnHance);
        DECODE_BOOL(superResolution);
        DECODE_BOOL(waterMarkEnable);
        DECODE_BOOL(lockCameraOrient);
        DECODE_BOOL(videoBeauty);
        DECODE_BOOL(enableAudioVolumeIndication);

        DECODE_BOOL(is1V1);

        
        DECODE_BOOL(isMsgDataChannel);
        DECODE_BOOL(isVideoPullDemote);
        DECODE_BOOL(isMultiStreamMode);
        DECODE_BOOL(isReportWatchSli);
        DECODE_OBJ(signalMode);

        DECODE_BOOL(isLiveMix);
        DECODE_BOOL(isLiveRecord);
        DECODE_OBJ(liveUrl);
        DECODE_OBJ(liveMixTemplate);
        DECODE_OBJ(liveTransferMode);
        DECODE_OBJ(serverHost);
        DECODE_OBJ(serverAppId);
        DECODE_OBJ(serverToken);
        DECODE_OBJ(serverUserId);
        DECODE_OBJ(mediaServerIp);
        DECODE_OBJ(roomName);
        DECODE_BOOL(showMeetingMode);
        DECODE_OBJ(encryptMode);


        // lastmile
        DECODE_OBJ(probeServerUrl);
        DECODE_OBJ(probeUplinkKbps);
        DECODE_OBJ(probeDownlinkKbps);
        
        // RTCSettingContext
        DECODE_OBJ(usingFrontCamera);
        DECODE_OBJ(videoBgPushMode);

        DECODE_BOOL(hasVideo);
        DECODE_BOOL(hasAudio);
        DECODE_BOOL(hasRemoteAudio);
        DECODE_BOOL(hasRemoteVideo);
        DECODE_BOOL(isAutoPublish);
        DECODE_BOOL(isAutoSubscribe);
        DECODE_BOOL(isVideoPullDemote);
        DECODE_OBJ(subscribeMode);
        DECODE_OBJ(subscribeCount);

        DECODE_BOOL(isOnlineMode);
        DECODE_BOOL(logQualityMonitor);
        DECODE_BOOL(logWeakNetQualityReport);
#undef DECODE_OBJ
#undef DECODE_BOOL
    }
    return self;
}
@end
NS_ASSUME_NONNULL_END
