//
//  RTCSettingsStore.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/11/27.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef RTCSettingsStore_h
#define RTCSettingsStore_h
#import <Foundation/Foundation.h>
#import <BaiduRtcRoom/RTCSettingContext.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * Light-weight persistent store for user settings.
 *
 * It will persist between application launches and application updates.
 */
@interface RTCStoreFile : RTCSettingContext


+(id)loadFromLocal;
-(void)saveToLocal;

@property (nonatomic, copy) NSNumber *audioProfile;
@property (nonatomic, copy) NSNumber *audioScenario;

@property (nonatomic, copy) NSString *videoCodec;
@property (nonatomic, copy) NSString *audioCodec;
@property (nonatomic, copy) NSNumber *maxBitrate;
@property (nonatomic, copy) NSNumber *minBitrate;
@property (nonatomic, copy) NSNumber *videoFps;
@property (nonatomic, copy) NSString *captureVideoResolution;
@property (nonatomic, copy) NSString *videoResolution;
@property (nonatomic, copy) NSNumber *videoDegradation;
// screen share
@property (nonatomic, copy) NSString *screenResolution;
@property (nonatomic, copy) NSNumber *screenMaxBitrate;
@property (nonatomic, copy) NSNumber *screenMinBitrate;
@property (nonatomic, copy) NSNumber *screenVideoFps;
// whiteboard
@property (nonatomic, copy) NSNumber *boardTransparency;
@property (nonatomic, copy) NSNumber *boardToolType;
@property (nonatomic, copy) NSNumber *boardToolColor;
@property (nonatomic, copy) NSNumber *boardBgColor;
@property (nonatomic) BOOL boardAudience;

@property (nonatomic) BOOL isFixedResolution;
@property (nonatomic) BOOL isExportAudioRecord;
@property (nonatomic) BOOL isExportAudioPlayout;
@property (nonatomic) BOOL isExportAudioRecordPlayoutMix;
@property (nonatomic) BOOL isEnableModeCaptureExternal;
@property (nonatomic) BOOL sessionMode;
@property (nonatomic) BOOL createAecDump;
@property (nonatomic) BOOL useLevelController;
@property (nonatomic) BOOL useManualAudioConfig;
@property (nonatomic) BOOL isEnableExternalAudioDevice;
@property (nonatomic) BOOL noiseSuppression;
@property (nonatomic) BOOL echoCancellation;
@property (nonatomic) BOOL voiceGain;
@property (nonatomic) BOOL logEnableVerbose;
@property (nonatomic) BOOL isCompulsive;
@property (nonatomic) BOOL isAutoReconnect;

@property (nonatomic) BOOL remoteSubscribeOpt;
@property (nonatomic) BOOL videoEnHance;
@property (nonatomic) BOOL superResolution;
@property (nonatomic) BOOL waterMarkEnable;
@property (nonatomic) BOOL lockCameraOrient;
@property (nonatomic) BOOL videoBeauty;
@property (nonatomic) BOOL enableAudioVolumeIndication;

@property (nonatomic) BOOL is1V1;

@property (nonatomic) BOOL isMsgDataChannel;
@property (nonatomic) BOOL isMultiStreamMode;
@property (nonatomic) BOOL isReportWatchSli;
@property (nonatomic, copy) NSNumber *signalMode;
/**
 * Stores and return the provided live configuration.
 */
@property (nonatomic, assign) BOOL isLiveMix;
@property (nonatomic, assign) BOOL isLiveRecord;
@property (nonatomic, copy) NSString *liveUrl;
@property (nonatomic, copy) NSString *liveMixTemplate;
@property (nonatomic, copy) NSString *liveTransferMode;
@property (nonatomic, copy) NSString *serverHost;
@property (nonatomic, copy) NSString *serverAppId;
@property (nonatomic, copy) NSString *serverToken;
@property (nonatomic, copy) NSString *serverUserId;
@property (nonatomic, copy) NSString *mediaServerIp;
@property (nonatomic, copy) NSString *roomName;
@property (nonatomic, assign) BOOL showMeetingMode;
@property (nonatomic, copy) NSString *encryptMode;

// lastmile
@property(nonatomic, copy) NSString *probeServerUrl;
@property(nonatomic, copy) NSString *probeUplinkKbps;
@property(nonatomic, copy) NSString *probeDownlinkKbps;

@end
NS_ASSUME_NONNULL_END


#endif /* RTCSettingsStore_h */
