//
//  RTCSettingsModel.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/11/27.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RTCSettingsModel.h"
#import "RTCStoreFile.h"

NS_ASSUME_NONNULL_BEGIN

static NSArray<NSString *> *auidoCodecsStaticValues(void) {
    return @[ @"opus", @"amr-wb", @"pcmu", @"pcma", @"g722" ];
}

static NSArray<NSString *> *videoBgPushModeSaticValues(void){
    return @[@"BRTC_VIDEO_BG_PUSH_NOT", @"BRTC_VIDEO_BG_PUSH_BLACKFRAME", @"BRTC_VIDEO_BG_PUSH_LASTFRAME"];
}

static NSArray<NSString *> *videoCodecsStaticValues(void) {
    return @[ @"H264", @"H263", @"JPEG", @"H265" ];
}

static NSArray<NSString *> *videoCaptureResolutionSettingOutput(void) {
    return  @[ @"2160x3840", @"1440x2160", @"1080x1920", @"720x1280", @"480x640", @"360x640", @"360x480", @"288x352"];
}

static NSArray<NSString *> *videoEncoderResolutionSettingOutput(void) {
    return  @[ @"2160x3840", @"1440x2160", @"1080x1920", @"720x1280", @"480x640", @"360x640", @"360x480", @"240x240", @"176x144"];
}

static NSArray<NSString *> *subscribeModeStaticValues(void) {
    return @[ @"manual", @"auto", @"meeting", @"off" ];
}

static NSArray<NSString *> *encryptModeStaticValues(void) {
    return @[ @"KeyExchangeDTLS", @"KeyExchangeSDES", @"KeyExchangeNONE" ];
}

static BOOL CheckString(NSString *str) {
    if (![str isKindOfClass:[NSString class]] || str.length == 0) {
        return NO;
    }
    return YES;
}

static BOOL CheckNumer(NSNumber *num) {
    if (![num isKindOfClass:[NSNumber class]] || num.intValue < 0) {
        return NO;
    }
    return YES;
}

@interface RTCSettingsModel () {
    RTCStoreFile *_fileStore;
}
@end

@implementation RTCSettingsModel

+ (instancetype)sharedInstance {
    static RTCSettingsModel *_sharedSingleton = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _sharedSingleton = [[super allocWithZone:NULL] init];
    });
    return _sharedSingleton;
}

- (void)sync {
    [[self settingsStore] saveToLocal];
}

- (NSNumber *)currentVideoFpsSettingFromStore {
    return [self settingsStore].videoFps;
}

- (void)storeVideoFpsSetting:(NSNumber *)fps {
    [self settingsStore].videoFps = fps;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentCaptureExternalModeSettingFromStore {
    return [self settingsStore].isEnableModeCaptureExternal;
}

- (void)storeCaptureExternalModeSetting:(BOOL)isEnableExternalRender {
    [self settingsStore].isEnableModeCaptureExternal = isEnableExternalRender;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentCompulsiveModeSettingFromStore {
    return [self settingsStore].isCompulsive;
}

- (void)storeCompulsiveModeSetting:(BOOL)isCompulsive {
    [self settingsStore].isCompulsive = isCompulsive;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentAutoReconnectFromStore {
    return [self settingsStore].isAutoReconnect;
}

- (void)storeAutoReconnectSetting:(BOOL)enable {
    [self settingsStore].isAutoReconnect = enable;
    [[self settingsStore] saveToLocal];
}



- (BOOL)currentExportAudioRecordSettingFromStore {
    return [self settingsStore].isExportAudioRecord;
}

- (void)storeExportAudioRecordSetting:(BOOL)isExportingAudioRecord {
    [self settingsStore].isExportAudioRecord = isExportingAudioRecord;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentExportAudioPlayoutSettingFromStore {
    return [self settingsStore].isExportAudioPlayout;
}

- (void)storeExportAudioPlayoutSetting:(BOOL)isExportingAudioPlayout {
    [self settingsStore].isExportAudioPlayout = isExportingAudioPlayout;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentExportAudioRecordPlayoutMixSettingFromStore {
    return [self settingsStore].isExportAudioRecordPlayoutMix;
}

- (void)storeExportAudioRecordPlayoutMixSetting:(BOOL)isExportingAudioRecordPlayoutMix {
    [self settingsStore].isExportAudioRecordPlayoutMix = isExportingAudioRecordPlayoutMix;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentAudioExteranlDeviceSettingFromStore {
    return [self settingsStore].isEnableExternalAudioDevice;
}

- (void)storeAudioExternalDeviceSetting:(BOOL)isEnableExternalAudioDeivce {
    [self settingsStore].isEnableExternalAudioDevice = isEnableExternalAudioDeivce;
    [[self settingsStore] saveToLocal];
}

- (NSString *)currentVideoResolutionSettingFromStore {
    return [self settingsStore].videoResolution;
}

- (BOOL)storeVideoResolutionSetting:(NSString *)resolution {
//    if (![[self availableVideoResolutions] containsObject:resolution]) {
//        return NO;
//    }
    [self settingsStore].videoResolution = resolution;
    [[self settingsStore] saveToLocal];
    return YES;
}

- (NSString *)currentCaptureVideoResolutionSettingFromStore {
    return [self settingsStore].captureVideoResolution;
}

- (BOOL)storeCaptureVideoResolutionSetting:(NSString *)resolution {
    [self settingsStore].captureVideoResolution = resolution;
    [[self settingsStore] saveToLocal];
    return YES;
}

- (int)currentCaptureVideoResolutionWidthFromStore {
    NSString *resolution = [self currentCaptureVideoResolutionSettingFromStore];
    return [self videoResolutionComponentAtIndex:0 inString:resolution];
}

- (int)currentCaptureVideoResolutionHeightFromStore {
    NSString *resolution = [self currentCaptureVideoResolutionSettingFromStore];
    return [self videoResolutionComponentAtIndex:1 inString:resolution];
}

- (NSArray<NSString *> *)outputVideoCaptureResultions {
    return videoCaptureResolutionSettingOutput();
}

- (NSArray<NSString *> *)outputVideoEncoderResultions {
    return videoEncoderResolutionSettingOutput();
}

- (NSArray<NSString *> *)availableVideoCodecs {
    return videoCodecsStaticValues();
}

- (NSArray<NSString *> *)availableAudioCodecs {
    return auidoCodecsStaticValues();
}

- (NSArray<NSString *> *)availableSubscribeMode {
    return subscribeModeStaticValues();
}

- (NSArray<NSString *> *)availableEncryptMode {
    return encryptModeStaticValues();
}

- (NSArray<NSString *> *)availableVideoBgPushMode {
    return videoBgPushModeSaticValues();
}

- (NSNumber *)currentCaptureVideoBgPushModeSettingFromStore {
    return [self settingsStore].videoBgPushMode;
}

- (BOOL)storeCaptureVideoBgPushModeSetting:(NSNumber *)videoBgPushMode {
    [self settingsStore].videoBgPushMode = videoBgPushMode;
    [[self settingsStore] saveToLocal];
    return YES;
}

//audioScenario
- (NSNumber *)currentAudioProfileSettingFromStore {
    return [self settingsStore].audioProfile;
}

- (BOOL)storeAudioProfileSetting:(NSNumber *)audioProfile {
    [self settingsStore].audioProfile = audioProfile;
    [[self settingsStore] saveToLocal];
    return YES;
}

- (NSNumber *)currentAudioScenarioSettingFromStore {
    return [self settingsStore].audioScenario;
}

- (BOOL)storeAudioScenarioSetting:(NSNumber *)audioScenario {
    [self settingsStore].audioScenario = audioScenario;
    [[self settingsStore] saveToLocal];
    return YES;
}

- (NSString *)currentAudioCodecSettingFromStore {
    return [self settingsStore].audioCodec;
}
- (BOOL)storeAudioCodecSetting:(NSString *)audioCodec {
    [self settingsStore].audioCodec = audioCodec;
    [[self settingsStore] saveToLocal];
    return YES;
}

- (NSString *)currentVideoCodecSettingFromStore {
    return [self settingsStore].videoCodec;
}

- (BOOL)storeVideoCodecSetting:(NSString *)videoCodec {
    if (![[self availableVideoCodecs] containsObject:videoCodec]) {
        return NO;
    }
    [self settingsStore].videoCodec = videoCodec;
    [[self settingsStore] saveToLocal];
    return YES;
}

- (int)currentVideoDegradationFromStore {
    return [self settingsStore].videoDegradation.intValue;
}

- (void)storeVideoDegradation:(int)val {
    [self settingsStore].videoDegradation = @(val);
    [[self settingsStore] saveToLocal];
}

- (NSString *)currentEncryptModeSettingFromStore {
    return [self settingsStore].encryptMode;
}

- (BOOL)storeEncryptModeSetting:(NSString *)encryptMode {
    if (![[self availableEncryptMode] containsObject:encryptMode]) {
        return NO;
    }
    [self settingsStore].encryptMode = encryptMode;
    [[self settingsStore] saveToLocal];
    return YES;
}

- (NSString *)currentSubscribeModeSettingFromStore {
    return [self settingsStore].subscribeMode;
}

- (BOOL)storeSubscribeModeSetting:(NSString *)subscribeMode {
    if (![[self availableSubscribeMode] containsObject:subscribeMode]) {
        return NO;
    }
    [self settingsStore].subscribeMode = subscribeMode;
    [[self settingsStore] saveToLocal];
    return YES;
}

- (nullable NSNumber *)currentMinBitrateSettingFromStore {
    return [self settingsStore].minBitrate;
}

- (void)storeMinBitrateSetting:(nullable NSNumber *)bitrate {
    [self settingsStore].minBitrate = bitrate;
    [[self settingsStore] saveToLocal];
}

- (nullable NSNumber *)currentMaxBitrateSettingFromStore {
    return [[self settingsStore] maxBitrate];
}

- (void)storeMaxBitrateSetting:(nullable NSNumber *)bitrate {
    [[self settingsStore] setMaxBitrate:bitrate];
    [[self settingsStore] saveToLocal];
}

- (nullable NSNumber *)currentSubscribeCountSettingFromStore {
    return [self settingsStore].subscribeCount;
}

- (void)storeSubscribeCountSetting:(nullable NSNumber *)subscribeCount {
    [self settingsStore].subscribeCount = subscribeCount;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentSessionModeSettingFromStore {
    return [self settingsStore].sessionMode;
}

- (void)storeSessionModeSetting:(BOOL)sessionMode {
    [self settingsStore].sessionMode = sessionMode;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentCreateAecDumpSettingFromStore {
    return [self settingsStore].createAecDump;
}

- (void)storeCreateAecDumpSetting:(BOOL)createAecDump {
    [self settingsStore].createAecDump = createAecDump;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentUseLevelControllerSettingFromStore {
    return [self settingsStore].useLevelController;
}

- (void)storeUseLevelControllerSetting:(BOOL)useLevelController {
    [self settingsStore].useLevelController = useLevelController;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentUseManualAudioConfigSettingFromStore {
    return [self settingsStore].useManualAudioConfig;
}

- (void)storeUseManualAudioConfigSetting:(BOOL)useManualAudioConfig {
    [self settingsStore].useManualAudioConfig = useManualAudioConfig;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentNoiseSuppressionSettingFromStore {
    return [self settingsStore].noiseSuppression;
}

- (void)storeNoiseSuppressionSetting:(BOOL)noiceSuppression {
    [self settingsStore].noiseSuppression = noiceSuppression;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentEchoCancellationSettingFromStore {
    return [self settingsStore].echoCancellation;
}

- (void)storeEchoCancellationSetting:(BOOL)echoCancel {
    [self settingsStore].echoCancellation = echoCancel;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentVoiceGainSettingFromStore {
    return [self settingsStore].voiceGain;
}

- (void)storeVoiceGainSetting:(BOOL)noicseSuppress{
    [self settingsStore].voiceGain = noicseSuppress;
    [[self settingsStore] saveToLocal];
}

- (void)storeRemoteSubscribeSetting:(BOOL)isOptmode {
    [self settingsStore].remoteSubscribeOpt = isOptmode;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentRemoteSubscribeSettingFromStore {

    return [self settingsStore].remoteSubscribeOpt;
}

- (BOOL)currentCallMode1v1SettingFromStore {
    return [self settingsStore].is1V1;
}

- (void)storeCallMode1v1Setting:(BOOL)is1V1 {
    [self settingsStore].is1V1 = is1V1;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentLogQualityMonitorSetting {
    return  [self settingsStore].logQualityMonitor;
}

- (void)storeLogQualityMonitorSetting:(BOOL)isMonitor {
    [self settingsStore].logQualityMonitor = isMonitor;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentLogWeakNetQualityReportSetting {
    return  [self settingsStore].logWeakNetQualityReport;
}

- (void)storeLogWeakNetQualityReportSetting:(BOOL)isReport{
    [self settingsStore].logWeakNetQualityReport = isReport;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentLogEnableVerboseSetting {
    return self.settingsStore.logEnableVerbose;
}

- (void)storeLogEnableVerboseSetting:(BOOL)enable {
    self.settingsStore.logEnableVerbose = enable;
    [[self settingsStore] saveToLocal];
}

// lastmile
- (NSString *)currentProbeServerUrlSettingFromStore {
    return [self settingsStore].probeServerUrl;
}

- (void)storeProbeServerUrlSetting:(NSString *)url {
    [self settingsStore].probeServerUrl = url;
    [[self settingsStore] saveToLocal];
}

- (NSString *)currentProbeUplinkKbpsSettingFromStore {
    return [self settingsStore].probeUplinkKbps;
}

- (void)storeProbeUplinkKbpsSetting:(NSString *)kbps {
    [self settingsStore].probeUplinkKbps = kbps;
    [[self settingsStore] saveToLocal];
}

- (NSString *)currentProbeDownlinkKbpsSettingFromStore {
    return [self settingsStore].probeDownlinkKbps;
}

- (void)storeProbeDownlinkKbpsSetting:(NSString *)kbps {
    [self settingsStore].probeDownlinkKbps = kbps;
}

// server setting
- (NSString*) currentRoomNameSettingFromStore {
    return [self settingsStore].roomName;
}

- (void)storeRoomNameSetting:(NSString *)roomName {
    [self settingsStore].roomName = roomName;
    [[self settingsStore] saveToLocal];
}

- (NSString*) currentServerHostSettingFromStore {
    return [self settingsStore].serverHost;
}

- (void)storeServerHostSetting:(NSString *)host {
    [self settingsStore].serverHost = host;
    [[self settingsStore] saveToLocal];
}

- (NSString*) currentServerAppIdSettingFromStore {
    return  [self settingsStore].serverAppId;
}

- (void)storeServerAppIdSetting:(NSString *)appId {
    [self settingsStore].serverAppId = appId;
    [[self settingsStore] saveToLocal];
}

- (NSString*) currentServerTokenSettingFromStore {
    return  [self settingsStore].serverToken;
}

- (void)storeServerTokenSetting:(NSString *)token{
    [self settingsStore].serverToken = token;
    [[self settingsStore] saveToLocal];
}


- (NSString*) currentServerUserIdSettingFromStore {
    return  [self settingsStore].serverUserId;
}

- (void)storeServerUserIdSetting:(NSString *)userId {
    [self settingsStore].serverUserId = userId;
    [[self settingsStore] saveToLocal];
}

- (NSString *)currentMediaServerIpSettingFromStore {
    return  [self settingsStore].mediaServerIp;
}

- (void)storeMediaServerIpSetting:(NSString *)mediaServerIp {
    [self settingsStore].mediaServerIp = mediaServerIp;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentShownMeetingModeFromStore {
    return [self settingsStore].showMeetingMode;
}

- (void)storeShownMeetingMode:(BOOL)isMeetingMode {
    [self settingsStore].showMeetingMode = isMeetingMode;
    [[self settingsStore] saveToLocal];

}

- (BOOL)currentHasVideoSettingFromStore {
    return [self settingsStore].hasVideo;
}

- (void)storeHasVideoSetting:(BOOL)hasVideo {
    [self settingsStore].hasVideo = hasVideo;
    [[self settingsStore] saveToLocal];

}

- (BOOL)currentHasRemoteVideoSettingFromStore {
    return self.settingsStore.hasRemoteVideo;
}

- (void)storeHasRemoteVideoSetting:(BOOL)hasRemoteVideo {
    self.settingsStore.hasRemoteVideo = hasRemoteVideo;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentVideoEnhanceFromStore {
    return [self settingsStore].videoEnHance;
}

- (void)storeVideoEnhance:(BOOL)videoEnhance {
    [self settingsStore].videoEnHance = videoEnhance;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentSuperResolutionFromStore {
    return [self settingsStore].superResolution;
}

- (void)storeSuperResolution:(BOOL)sr {
    [self settingsStore].superResolution = sr;
    [[self settingsStore] saveToLocal];
}


- (BOOL)currentWaterMarkFromStore {
    return [self settingsStore].waterMarkEnable;
}

- (void)storeWaterMark:(BOOL)waterMark {
    [self settingsStore].waterMarkEnable = waterMark;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentLockCameraOrient {
    return self.settingsStore.lockCameraOrient;
}
- (void)storeLockCameraOrient:(BOOL)lock {
    self.settingsStore.lockCameraOrient = lock;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentEnableAudioVolumeIndicationFromStore {
    return [self settingsStore].enableAudioVolumeIndication;
}
- (void)storeEnableAudioVolumeIndication:(BOOL)enable {
    [self settingsStore].enableAudioVolumeIndication = enable;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentVideoBeautyFromStore {
    return [self settingsStore].videoBeauty;
}

- (void)storeVideoBeauty:(BOOL)videoBeauty {
    [self settingsStore].videoBeauty = videoBeauty;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentHasAudioSettingFromStore {
    return [self settingsStore].hasAudio;
}

- (void)storeHasAudioSetting:(BOOL)hasAudio {
    [self settingsStore].hasAudio = hasAudio;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentIsAutoPublishSettingFromStore {
    return [self settingsStore].isAutoPublish;
}

- (BOOL)currentHasRemoteAudioSettingFromStore {
    return self.settingsStore.hasRemoteAudio;
}

- (void)storeHasRemoteAudioSetting:(BOOL)hasRemoteAudio {
    self.settingsStore.hasRemoteAudio = hasRemoteAudio;
    [[self settingsStore] saveToLocal];
}

- (void)storeIsAutoPublishSetting:(BOOL)isAutoPublish {
    self.settingsStore.isAutoPublish = isAutoPublish;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentIsAutoSubscribeSettingFromStore {
    return [self settingsStore].isAutoSubscribe;
}

- (void)storeIsMessageModeChannelDataSetting:(BOOL)isUseDataChannel {
    [self settingsStore].isMsgDataChannel = isUseDataChannel;
}

- (BOOL)currentIsMessageModeChannelDataFromStore {
    return [self settingsStore].isMsgDataChannel;
}

- (BOOL)currentIsVideoPullDemoteFromStore {
    return [self settingsStore].isVideoPullDemote;
}

- (void)storeIsVideoPullDemoteSetting:(BOOL)isVideoPullDemote {
    [self settingsStore].isVideoPullDemote = isVideoPullDemote;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentIsMockSdpFromStore {
    if ([self settingsStore].subscribeMode && [[self settingsStore].subscribeMode isEqualToString:@"off"]) {
        return NO;
    } else {
        return YES;
    }
}

- (NSNumber *)currentSignalModeFromStore {
    return [self settingsStore].signalMode;
}

- (void)storeSignalModeSetting:(NSNumber *)signalMode {
    [self settingsStore].signalMode = signalMode;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentIsMultiStreamModeFromStore {
    return [self settingsStore].isMultiStreamMode;
}

- (void)storeIsMultiStreamModeSetting:(BOOL)isMultiStreamMode {
    [self settingsStore].isMultiStreamMode = isMultiStreamMode;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentIsOnlineModeFromStore {
    return [self settingsStore].isOnlineMode;
}

- (void)storeIsOnlineModeSetting:(BOOL)isOnlineMode {
    [self settingsStore].isOnlineMode = isOnlineMode;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentIsReportWatchSliFromStore {
    return [self settingsStore].isReportWatchSli;
}

- (void)storeIsReportWatchSliSetting:(BOOL)isReportWatchSli {
    [self settingsStore].isReportWatchSli = isReportWatchSli;
    [[self settingsStore] saveToLocal];
}

- (void)storeIsAutoSubscribeSetting:(BOOL)isAutoSubscribe {
    [self settingsStore].isAutoSubscribe = isAutoSubscribe;
    [[self settingsStore] saveToLocal];
}

// whiteboard background transparency
- (NSNumber *)currentBoardTransparencyFromStore {
    return [self settingsStore].boardTransparency;
}

- (void)storeBoardTransparency:(NSNumber *)transparency {
    [self settingsStore].boardTransparency = transparency;
    [[self settingsStore] saveToLocal];
}

// whiteboard tool type
- (NSNumber *)currentBoardToolTypeFromStore {
    return [self settingsStore].boardToolType;
}

- (void)storeBoardToolType:(NSNumber *)type {
    [self settingsStore].boardToolType = type;
    [[self settingsStore] saveToLocal];
}

// whiteboard tool color index
- (NSNumber *)currentBoardToolColorFromStore {
    return [self settingsStore].boardToolColor;
}

- (void)storeBoardToolColor:(NSNumber *)color {
    [self settingsStore].boardToolColor = color;
    [[self settingsStore] saveToLocal];
}

// whiteboard background color index
- (NSNumber *)currentBoardBgColorFromStore {
    return [self settingsStore].boardBgColor;
}

- (void)storeBoardBgColor:(NSNumber *)color {
    [self settingsStore].boardBgColor = color;
    [[self settingsStore] saveToLocal];
}

- (BOOL)currentBoardAudienceFromStore {
    return [self settingsStore].boardAudience;
}

- (void)storeBoardAudience:(BOOL)audience {
    [self settingsStore].boardAudience = audience;
    [[self settingsStore] saveToLocal];
}

#pragma mark - Testable

- (RTCStoreFile *)settingsStore {
    if (!_fileStore) {
        RTCStoreFile *local = [RTCStoreFile loadFromLocal];
        /** 本地缓存nil */
        if (local == nil) {
            _fileStore = [[RTCStoreFile alloc] init];
            [self registerStoreDefaults];
            [_fileStore saveToLocal];
        } else {
            _fileStore = local;
        }
    }
    return _fileStore;
}

- (BOOL)currentIsFixedResolutionSettingFromStore {
    return [self settingsStore].isFixedResolution;
}

- (void)storeIsFixedResolutionSetting:(BOOL)isFixedResolution {
    [self settingsStore].isFixedResolution = isFixedResolution;
    [[self settingsStore] saveToLocal];
}

- (int)currentVideoResolutionWidthFromStore {
    NSString *resolution = [self currentVideoResolutionSettingFromStore];
    
    return [self videoResolutionComponentAtIndex:0 inString:resolution];
}

- (int)currentVideoResolutionHeightFromStore {
    NSString *resolution = [self currentVideoResolutionSettingFromStore];
    return [self videoResolutionComponentAtIndex:1 inString:resolution];
}

#pragma mark - default configure


- (NSString *)defaultCaptureVideoResolutionSetting {
    return videoCaptureResolutionSettingOutput()[3];
}

- (NSString *)defaultVideoResolutionSetting {
    return videoEncoderResolutionSettingOutput()[3];
}

- (NSString *)defaultVideoCodecSetting {
    return videoCodecsStaticValues()[0];
}

- (NSString *)defaultAudioCodecSetting {
    return auidoCodecsStaticValues()[0];
}

- (NSString *)defaultSubscribeModeSetting {
//    return subscribeModeStaticValues()[0];
    return subscribeModeStaticValues()[3];
}

- (NSString *)defaultEncryptModeSetting {
    return encryptModeStaticValues()[0];
}

- (NSNumber *)defaultSubscribeCount {
    return [NSNumber numberWithInt:3];
}

- (NSNumber *)defaultVideoFps {
    return [NSNumber numberWithInt:24];
}

- (NSNumber *)defaultVideoBitrate {
    return [NSNumber numberWithInt:1500];
}

- (NSString *)defaultScreenShareVideoResolutionSetting {
    return videoEncoderResolutionSettingOutput()[0];
}

- (NSNumber *)defaultScreenShareVideoFps {
    return [NSNumber numberWithInt:15];
}

- (NSNumber *)defaultScreenShareVideoBitrate {
    return [NSNumber numberWithInt:2500];
}

- (NSNumber *)defaultScreenShareVideoMinBitrate {
    return [NSNumber numberWithInt:1500];
}

- (NSString *)defaultSignalServerHost {
    return @"";
    // return @"wss://rtc-online-test.exp.bcelive.com/janus";
}

- (int)videoResolutionComponentAtIndex:(int)index inString:(NSString *)resolution {
    if (index != 0 && index != 1) {
        return 0;
    }
    NSArray<NSString *> *components = [resolution componentsSeparatedByString:@"x"];
    if (components.count != 2) {
        return 0;
    }
    return components[index].intValue;
}
//modeVideoExternal : NO 默认支持内部采集
- (void)registerStoreDefaults {
    _fileStore.videoResolution = [self defaultVideoResolutionSetting];
    _fileStore.videoCodec = [self defaultVideoCodecSetting];
    _fileStore.maxBitrate = [self defaultVideoBitrate];
    _fileStore.videoFps = [self defaultVideoFps];
    _fileStore.hasVideo = YES;
    _fileStore.hasAudio = YES;
    _fileStore.hasRemoteAudio = YES;
    _fileStore.hasRemoteVideo = YES;
    _fileStore.audioCodec = [self defaultAudioCodecSetting];
    _fileStore.audioProfile = @(0);
    _fileStore.audioScenario = @(0);
    _fileStore.videoBgPushMode = @(0);

    _fileStore.remoteSubscribeOpt = YES;
    _fileStore.isAutoPublish = YES;
    _fileStore.isAutoSubscribe = YES;
    _fileStore.useManualAudioConfig = YES;
    _fileStore.signalMode = @(0);
    _fileStore.isOnlineMode = YES;
    _fileStore.isReportWatchSli = YES;
    _fileStore.isCompulsive = YES;
    _fileStore.isAutoReconnect = YES;
    _fileStore.captureVideoResolution = [self defaultVideoResolutionSetting];
    _fileStore.videoResolution = [self defaultCaptureVideoResolutionSetting];
    _fileStore.subscribeMode = [self defaultSubscribeModeSetting];
    _fileStore.subscribeCount = [self defaultSubscribeCount];
    _fileStore.encryptMode = [self defaultEncryptModeSetting];
    _fileStore.serverHost = [self defaultSignalServerHost];

    _fileStore.screenResolution = [self defaultScreenShareVideoResolutionSetting];
    _fileStore.screenVideoFps = [self defaultScreenShareVideoFps];
    _fileStore.screenMaxBitrate = [self defaultScreenShareVideoBitrate];
    _fileStore.screenMinBitrate = [self defaultScreenShareVideoMinBitrate];
    
    _fileStore.probeServerUrl = @"https://rtc-ss.su.baidubce.com";
    _fileStore.probeUplinkKbps = @"2000";
    _fileStore.probeDownlinkKbps = @"3000";
    
    _fileStore.boardToolType = @(0);
    _fileStore.boardTransparency = @(80);
    _fileStore.boardToolColor = @(0);

}


#pragma mark --  configure live server
//live url
- (NSString*)currentLiveUrlSettingFromStore {
    return [self settingsStore].liveUrl;
}

- (void)storeLiveUrlSetting:(NSString*)liveUrl {
    [self settingsStore].liveUrl = liveUrl;
    [[self settingsStore] saveToLocal];
}

//live isMix
- (BOOL)currentLiveMixSettingFromStore {
    return [self settingsStore].isLiveMix;
}

- (void)storeLiveMixSetting:(BOOL)isLiveMix {
    [self settingsStore].isLiveMix = isLiveMix;
    [[self settingsStore] saveToLocal];
}

//live isRecord
- (BOOL)currentLiveRecordSettingFromStore {
    return [self settingsStore].isLiveRecord;
}

- (void)storeLiveRecordSetting:(BOOL)isLiveRecord {
    [self settingsStore].isLiveRecord = isLiveRecord;
    [[self settingsStore] saveToLocal];
}

//live mix template
- (NSString *)currentLiveMixTemplateSettingFromStore {
    return [self settingsStore].liveMixTemplate;
}

- (void)storeLiveMixTemplateSetting:(NSString *)liveMixTemplate {
    [self settingsStore].liveMixTemplate = liveMixTemplate;
    [[self settingsStore] saveToLocal];
}

//live transfer mode
- (NSString *)currentLiveTransferModSettingFromStore {
    return [self settingsStore].liveTransferMode;
}

- (void)storeLiveTransferModeSetting:(NSString *)liveTransferMode {
    [self settingsStore].liveTransferMode = liveTransferMode;
    [[self settingsStore] saveToLocal];
}

#pragma mark - Media Control

- (BOOL)currentUsingFrontCameraSettingFromStore {
    NSNumber *num = [self settingsStore].usingFrontCamera;
    if (num == nil) return [self defaultUsingFrontCamera];
    return num.boolValue;
}

- (void)storeUsingFrontCameraSetting:(BOOL)usingFrontCamera {
    [self settingsStore].usingFrontCamera = @(usingFrontCamera);
    [[self settingsStore] saveToLocal];
}

- (BOOL)defaultUsingFrontCamera {
    return YES;
}

#pragma mark - Screen Share

- (NSString *)currentScreenShareVideoResolutionSettingFromStore {
    return [self.settingsStore screenResolution];
}

- (BOOL)storeScreenShareVideoResolutionSetting:(NSString *)resolution {
    if (!CheckString(resolution)) {
        return NO;
    }
    [self.settingsStore setScreenResolution:resolution];
    [[self settingsStore] saveToLocal];
    return YES;
}

- (int)currentScreenShareVideoResolutionWidthFromStore {
    NSString *resolution = [self currentScreenShareVideoResolutionSettingFromStore];
    return [self videoResolutionComponentAtIndex:0 inString:resolution];
}

- (int)currentScreenShareVideoResolutionHeightFromStore {
    NSString *resolution = [self currentScreenShareVideoResolutionSettingFromStore];
    return [self videoResolutionComponentAtIndex:1 inString:resolution];
}

- (NSNumber *)currentScreenShareVideoFpsSettingFromStore {
    return [self.settingsStore screenVideoFps];
}

- (BOOL)storeScreenShareVideoFpsSetting:(NSNumber *)fps {
    if (!CheckNumer(fps)) {
        return NO;
    }
    [self.settingsStore setScreenVideoFps:fps];
    [[self settingsStore] saveToLocal];

    return YES;
}

- (nullable NSNumber *)currentScreenShareMinBitrateSettingFromStore {
    return [self.settingsStore screenMinBitrate];
}

- (BOOL)storeScreenShareMinBitrateSetting:(nullable NSNumber *)bitrate {
    if (!CheckNumer(bitrate)) {
        return NO;
    }
    [self.settingsStore setScreenMinBitrate:bitrate];
    return YES;
}

- (nullable NSNumber *)currentScreenShareMaxBitrateSettingFromStore {
    return [self.settingsStore screenMaxBitrate];
}

- (BOOL)storeScreenShareMaxBitrateSetting:(nullable NSNumber *)bitrate {
    if (!CheckNumer(bitrate)) {
        return NO;
    }
    [self.settingsStore setScreenMaxBitrate:bitrate];
    [[self settingsStore] saveToLocal];

    return YES;
}

@end
NS_ASSUME_NONNULL_END
