//
//  RTCSettingsModel.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/11/27.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef RTCSettingsModel_h
#define RTCSettingsModel_h

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * Model class for user defined settings.
 *
 * Handles storing the settings and provides default values if setting is not
 * set. Also provides list of available options for different settings. Stores
 * for example video codec, video resolution and maximum bitrate.
 */
@interface RTCSettingsModel : NSObject

/**
 * Returns RTCSettingsModel single object.
 */
+ (instancetype)sharedInstance;

@property (nonatomic, assign) BOOL pushStream;

/**
 * Returns current video fps nsnumber.
 * If no fps is in store, default value of 24 is returned.
 */
- (NSNumber *)currentVideoFpsSettingFromStore;

/**
 * Stores the provided fps value into the store.
 *
 * @param fps NSNumber representation of capture fps value.
 */
- (void)storeVideoFpsSetting:(NSNumber *)fps;

/**
 *  Return current mode of capture.
 */
- (BOOL)currentCaptureExternalModeSettingFromStore;

/**
 *  Stores the CaptureMode.
 */
- (void)storeCaptureExternalModeSetting:(BOOL)isEnableExternalRender;


- (BOOL)currentCompulsiveModeSettingFromStore;
- (void)storeCompulsiveModeSetting:(BOOL)isForceLogin;

- (BOOL)currentAutoReconnectFromStore;
- (void)storeAutoReconnectSetting:(BOOL)enable;

/**
 * Returns currrent exporting audio record setting.
 */
- (BOOL)currentExportAudioRecordSettingFromStore;

/**
 * Store the provided audio exporting recording setting.
 */
- (void)storeExportAudioRecordSetting:(BOOL)isExportingAudioRecord;

/**
 * Returns current exporting audio playout setting.
 */
- (BOOL)currentExportAudioPlayoutSettingFromStore;

/**
 * Store the provided exporting audio playout setting.
 */
- (void)storeExportAudioPlayoutSetting:(BOOL)isExportingAudioPlayout;

/**
 * Returns current exporting audio record and playout mixing setting.
 */
- (BOOL)currentExportAudioRecordPlayoutMixSettingFromStore;

/**
 * Store the provided exporting audio record and playout mixing setting.
 */
- (void)storeExportAudioRecordPlayoutMixSetting:(BOOL)isExportingAudioRecordPlayoutMix;

/**
 * Store the provided external audio device bool value..
 */
- (void)storeAudioExternalDeviceSetting:(BOOL)isEnableExternalAudioDeivce;

/**
 * Returns current audio external device model.
 */
- (BOOL)currentAudioExteranlDeviceSettingFromStore;

/**
 * Returns array of available capture resoultions.
 *
 * The capture resolutions are represented as strings in the following format
 * [width]x[height]
 */
//- (NSArray<NSString *> *)availableVideoResolutions;


- (BOOL)currentIsFixedResolutionSettingFromStore;
- (void)storeIsFixedResolutionSetting:(BOOL)isFixedResolution;

/**
 * Returns current video resolution string.
 * If no resolution is in store, default value of 640x480 is returned.
 * When defaulting to value, the default is saved in store for consistency reasons.
 */
- (NSString *)currentVideoResolutionSettingFromStore;
- (int)currentVideoResolutionWidthFromStore;
- (int)currentVideoResolutionHeightFromStore;

/**
 * Stores the provided video resolution string into the store.
 *
 * If the provided resolution is no part of the available video resolutions
 * the store operation will not be executed and NO will be returned.
 * @param resolution the string to be stored.
 * @return YES/NO depending on success.
 */
- (BOOL)storeVideoResolutionSetting:(NSString *)resolution;

- (NSString *)currentCaptureVideoResolutionSettingFromStore;
- (int)currentCaptureVideoResolutionWidthFromStore;
- (int)currentCaptureVideoResolutionHeightFromStore;
- (BOOL)storeCaptureVideoResolutionSetting:(NSString *)resolution;

/**
 * Returns arrays of output Resolutions
 */
- (NSArray<NSString *> *)outputVideoCaptureResultions;
- (NSArray<NSString *> *)outputVideoEncoderResultions;

/**
 * Returns arrays of output Resolutions
 */
- (NSArray<NSString *> *)availableAudioCodecs;

/**
 *Return arrays of VideoBgPushMode
 */
- (NSArray<NSString *> *)availableVideoBgPushMode;
    
/**
 * Returns array of available video codecs.
 */
- (NSArray<NSString *> *)availableVideoCodecs;

/**
 * Returns current video codec setting from store if present or default (H264) otherwise.
 */
- (NSString *)currentVideoCodecSettingFromStore;

/**
 * Returns array of available subscribe modes.
 */
- (NSArray<NSString *> *)availableSubscribeMode;

/**
 * Returns array of available encrypt modes.
 */
- (NSArray<NSString *> *)availableEncryptMode;

/**
 * Returns current subscribe mode setting from store if present or default (Manual) otherwise.
 */
- (NSString *)currentSubscribeModeSettingFromStore;

/**
 * Returns current encrypt mode setting from store if present or default (DTLS) otherwise.
 */
- (NSString *)currentEncryptModeSettingFromStore;

/**
 * Stores the provided video codec setting into the store.
 *
 * If the provided video codec is not part of the available video codecs
 * the store operation will not be executed and NO will be returned.
 * @param videoCodec settings the string to be stored.
 * @return YES/NO depending on success.
 */
- (BOOL)storeVideoCodecSetting:(NSString *)videoCodec;

- (int)currentVideoDegradationFromStore;
- (void)storeVideoDegradation:(int)val;

- (BOOL)storeEncryptModeSetting:(NSString *)encryptMode;

/**
 * Stores the provided subscribe mode setting into the store.
 *
 * If the provided subscribe mode is not part of the available subscribe modes
 * the store operation will not be executed and NO will be returned.
 * @param subscribeMode settings the string to be stored.
 * @return YES/NO depending on success.
 */
- (BOOL)storeSubscribeModeSetting:(NSString *)subscribeMode;

/**
 * Returns current subscribe count setting from store if present.
 */
- (nullable NSNumber *)currentSubscribeCountSettingFromStore;

/**
 * Stores the provided subscribe count into the store.
 *
 * @param subscribeCount NSNumber representation of the subscribe count value.
 */
- (void)storeSubscribeCountSetting:(nullable NSNumber *)subscribeCount;

- (nullable NSNumber *)currentMinBitrateSettingFromStore;
- (void)storeMinBitrateSetting:(nullable NSNumber *)bitrate;

/**
 * Returns current max bitrate setting from store if present.
 */
- (nullable NSNumber *)currentMaxBitrateSettingFromStore;

/**
 * Stores the provided bitrate value into the store.
 *
 * @param bitrate NSNumber representation of the max bitrate value.
 */
- (void)storeMaxBitrateSetting:(nullable NSNumber *)bitrate;

/**
 * Returns current session mode setting from store if present or default (NO) otherwise.
 */
- (BOOL)currentSessionModeSettingFromStore;

/**
 * Stores the provided session mode setting into the store.
 *
 * @param sessionMode the boolean value to be stored.
 */
- (void)storeSessionModeSetting:(BOOL)sessionMode;

/**
 * Returns current create AecDump setting from store if present or default (NO) otherwise.
 */
- (BOOL)currentCreateAecDumpSettingFromStore;

/**
 * Stores the provided create AecDump setting into the store.
 *
 * @param createAecDump the boolean value to be stored.
 */
- (void)storeCreateAecDumpSetting:(BOOL)createAecDump;

/**
 * Returns current setting whether to use level controller from store if present or default (NO)
 * otherwise.
 */
- (BOOL)currentUseLevelControllerSettingFromStore;

/**
 * Stores the provided use level controller setting into the store.
 *
 * @param useLevelController the boolean value to be stored.
 */
- (void)storeUseLevelControllerSetting:(BOOL)useLevelController;

/**
 * Returns current setting whether to use manual audio config from store if present or default (YES)
 * otherwise.
 */
- (BOOL)currentUseManualAudioConfigSettingFromStore;

/**
 * Stores the provided use manual audio config setting into the store.
 *
 * @param useManualAudioConfig the boolean value to be stored.
 */
- (void)storeUseManualAudioConfigSetting:(BOOL)useManualAudioConfig;

//audioDispose
- (BOOL)currentEchoCancellationSettingFromStore;

- (void)storeEchoCancellationSetting:(BOOL)echoCancel;

- (BOOL)currentNoiseSuppressionSettingFromStore;

- (void)storeNoiseSuppressionSetting:(BOOL)noiceSuppression;

- (BOOL)currentVoiceGainSettingFromStore;

- (void)storeVoiceGainSetting:(BOOL)noicseSuppress;

//for log setting
- (BOOL)currentLogQualityMonitorSetting;

- (void)storeLogQualityMonitorSetting:(BOOL)isMonitor;

- (BOOL)currentLogWeakNetQualityReportSetting;

- (void)storeLogWeakNetQualityReportSetting:(BOOL)isReport;

- (BOOL)currentLogEnableVerboseSetting;

- (void)storeLogEnableVerboseSetting:(BOOL)enable;

// lastmile
- (NSString *)currentProbeServerUrlSettingFromStore;
- (void)storeProbeServerUrlSetting:(NSString *)url;

- (NSString *)currentProbeUplinkKbpsSettingFromStore;
- (void)storeProbeUplinkKbpsSetting:(NSString *)kbps;

- (NSString *)currentProbeDownlinkKbpsSettingFromStore;
- (void)storeProbeDownlinkKbpsSetting:(NSString *)kbps;

//for server setting
- (NSString *)currentRoomNameSettingFromStore;

- (void)storeRoomNameSetting:(NSString *)roomName;

- (NSString *)currentServerHostSettingFromStore;

- (void)storeServerHostSetting:(NSString *)host;

- (NSString *) currentServerAppIdSettingFromStore;

- (void)storeServerAppIdSetting:(NSString *)appId;

- (NSString *) currentServerTokenSettingFromStore;

- (void)storeServerTokenSetting:(NSString *)token;

- (NSString *) currentServerUserIdSettingFromStore;

- (void)storeServerUserIdSetting:(NSString *)userId;

- (NSString *)currentMediaServerIpSettingFromStore;

- (void)storeMediaServerIpSetting:(NSString *)mediaServerIp;

- (BOOL)currentShownMeetingModeFromStore;

- (void)storeShownMeetingMode:(BOOL)isMeetingMode;

//hasVideo
- (BOOL)currentHasVideoSettingFromStore;
- (void)storeHasVideoSetting:(BOOL)hasVideo;

- (BOOL)currentHasRemoteVideoSettingFromStore;
- (void)storeHasRemoteVideoSetting:(BOOL)hasRemoteVideo;

//videoDispose
- (BOOL)currentVideoEnhanceFromStore;

- (void)storeVideoEnhance:(BOOL)videoEnhance;

- (BOOL)currentSuperResolutionFromStore;

- (void)storeSuperResolution:(BOOL)sr;

- (BOOL)currentWaterMarkFromStore;

- (void)storeWaterMark:(BOOL)waterMark;

- (BOOL)currentLockCameraOrient;
- (void)storeLockCameraOrient:(BOOL)lock;

- (BOOL)currentVideoBeautyFromStore;

- (void)storeVideoBeauty:(BOOL)videoBeauty;

- (BOOL)currentEnableAudioVolumeIndicationFromStore;
- (void)storeEnableAudioVolumeIndication:(BOOL)enable;

//hasAudio
- (BOOL)currentHasAudioSettingFromStore;
- (void)storeHasAudioSetting:(BOOL)hasAudio;

- (BOOL)currentHasRemoteAudioSettingFromStore;
- (void)storeHasRemoteAudioSetting:(BOOL)hasRemoteAudio;

//audioProfile
- (NSNumber *)currentAudioProfileSettingFromStore;

- (BOOL)storeAudioProfileSetting:(NSNumber *)audioProfile;

//audioScenario
- (NSNumber *)currentAudioScenarioSettingFromStore;

- (BOOL)storeAudioScenarioSetting:(NSNumber *)audioScenario;

//audioCodec
- (NSString *)currentAudioCodecSettingFromStore;

- (BOOL)storeAudioCodecSetting:(NSString *)audioCodec;

/**
 *  Get the mode of Video background streaming.
 */
- (NSNumber *)currentCaptureVideoBgPushModeSettingFromStore;

/**
 *  Stores the mode of Video background streaming.
 */
- (BOOL)storeCaptureVideoBgPushModeSetting:(NSNumber *)videoBackgroundPushMode;

//isAutoPublish
- (BOOL)currentIsAutoPublishSettingFromStore;

- (void)storeIsAutoPublishSetting:(BOOL)isAutoPublish;

//isAutoASubscribe
- (BOOL)currentIsAutoSubscribeSettingFromStore;

- (void)storeIsAutoSubscribeSetting:(BOOL)isAutoSubscribe;

//isUseDataChannel
- (BOOL)currentIsMessageModeChannelDataFromStore;

- (void)storeIsMessageModeChannelDataSetting:(BOOL)isUseDataChannel;

// video pull demote
- (BOOL)currentIsVideoPullDemoteFromStore;

- (void)storeIsVideoPullDemoteSetting:(BOOL)isVideoPullDemote;

// isMockSdp
- (BOOL)currentIsMockSdpFromStore;

// SignalMode
- (NSNumber *)currentSignalModeFromStore;

- (void)storeSignalModeSetting:(NSNumber *)signalMode;

// multiStreamMode
- (BOOL)currentIsMultiStreamModeFromStore;

- (void)storeIsMultiStreamModeSetting:(BOOL)isMultiStreamMode;

// online mode
- (BOOL)currentIsOnlineModeFromStore;

- (void)storeIsOnlineModeSetting:(BOOL)isOnlineMode;

// h263 report watch sli
- (BOOL)currentIsReportWatchSliFromStore;

- (void)storeIsReportWatchSliSetting:(BOOL)isReportWatchSli;

/**
 *   Live server transfer configuration related.
 */
//live url
- (NSString*)currentLiveUrlSettingFromStore;

- (void)storeLiveUrlSetting:(NSString*)liveUrl;

//live isMix
- (BOOL)currentLiveMixSettingFromStore;

- (void)storeLiveMixSetting:(BOOL)isLiveMix;

//live isRecord
- (BOOL)currentLiveRecordSettingFromStore;

- (void)storeLiveRecordSetting:(BOOL)isLiveRecord;

//live mix template
- (NSString *)currentLiveMixTemplateSettingFromStore;

- (void)storeLiveMixTemplateSetting:(NSString *)liveMixTemplate;

//live transfer mode
- (NSString *)currentLiveTransferModSettingFromStore;

- (void)storeLiveTransferModeSetting:(NSString *)liveTransferMode;

//subscribe mode
- (BOOL)currentRemoteSubscribeSettingFromStore;

- (void)storeRemoteSubscribeSetting:(BOOL)isOptmode;

- (BOOL)currentCallMode1v1SettingFromStore;

- (void)storeCallMode1v1Setting:(BOOL)is1V1;

#pragma mark - Media Control

- (BOOL)currentUsingFrontCameraSettingFromStore;
- (void)storeUsingFrontCameraSetting:(BOOL)usingFrontCamera;

#pragma mark - Screen Share

/**
 * Returns current video resolution string for screen sharing.
 *
 * If no resolution is in store, default value of 1080x1920 is returned.
 * When defaulting to value, the default is saved in store for consistency reasons.
 */
- (NSString *)currentScreenShareVideoResolutionSettingFromStore;
- (int)currentScreenShareVideoResolutionWidthFromStore;
- (int)currentScreenShareVideoResolutionHeightFromStore;

/**
 * Stores the provided video resolution string for screen sharing into the store.
 *
 * If the provided resolution is no part of the available video resolutions
 * the store operation will not be executed and NO will be returned.
 * @param resolution the string to be stored.
 * @return YES/NO depending on success.
 */
- (BOOL)storeScreenShareVideoResolutionSetting:(NSString *)resolution;

/**
 * Returns current video fps nsnumber for screen sharing.
 * If no fps is in store, default value of 15 is returned.
 */
- (NSNumber *)currentScreenShareVideoFpsSettingFromStore;

/**
 * Stores the provided fps value for screen sharing into the store.
 *
 * @param fps NSNumber representation of capture fps value.
 */
- (BOOL)storeScreenShareVideoFpsSetting:(NSNumber *)fps;


- (nullable NSNumber *)currentScreenShareMinBitrateSettingFromStore;
- (BOOL)storeScreenShareMinBitrateSetting:(nullable NSNumber *)bitrate;

/**
 * Returns current max bitrate setting for screen sharing from store if present.
 */
- (nullable NSNumber *)currentScreenShareMaxBitrateSettingFromStore;

/**
 * Stores the provided bitrate value into the store.
 *
 * @param bitrate NSNumber representation of the max bitrate value.
 * @discussion when storing resolution for screen sharing, this bitrate will
 * automatically changed to the matched value, you can then call this method
 * to overwrite it .
 */
- (BOOL)storeScreenShareMaxBitrateSetting:(nullable NSNumber *)bitrate;

/**
 * WhiteBoard background transparency
 */
- (NSNumber *)currentBoardTransparencyFromStore;
- (void)storeBoardTransparency:(NSNumber *)transparency;
/**
 * WhiteBoard tools type index
 */
- (NSNumber *)currentBoardToolTypeFromStore;
- (void)storeBoardToolType:(NSNumber *)type;
/**
 * WhiteBoard tools color index
 */
- (NSNumber *)currentBoardToolColorFromStore;
- (void)storeBoardToolColor:(NSNumber *)color;
/**
 * WhiteBoard background color index
 */
- (NSNumber *)currentBoardBgColorFromStore;
- (void)storeBoardBgColor:(NSNumber *)color;
/**
 * WhiteBoard role is Audience
 */
- (BOOL)currentBoardAudienceFromStore;
- (void)storeBoardAudience:(BOOL)audience;

- (void)sync;
@end
NS_ASSUME_NONNULL_END

#endif /* RTCSettingsModel_h */
