#import "RTCBoardCallViewController.h"
#import "RTCBoardCallView.h"
#import <BaiduRtcBoard/BaiduRtcBoardApi.h>

#import <Photos/Photos.h>
#import <WebKit/WebKit.h>

@interface RTCBoardCallViewController () <RTCBoardCallViewDelegate, BaiduRtcBoardDelegate, BaiduRtcBoardWKDelegate>

@property (nonatomic, strong) RTCBoardParam *boardParam;

@end

@implementation RTCBoardCallViewController {
    RTCBoardCallView *_callView;
}
#pragma mark - Life Cycle

- (void)dealloc {
    [UIApplication sharedApplication].idleTimerDisabled = NO;
    NSLog(@"[wb] RTCBoardCallViewController dealloc~");
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    if (@available(iOS 11.0, *)) {
        
    } else {
        self.automaticallyAdjustsScrollViewInsets = NO;
    }

    // [self setupLayout];
    
    // [_webView loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:_boardParam.url]]];
    
    [UIApplication sharedApplication].idleTimerDisabled = YES;
    
    [[BaiduRtcBoardApi sharedManager] setBaiduRtcBoardDelegate:self];
    [[BaiduRtcBoardApi sharedManager] setBaiduRtcBoardWKDelegate:self];
}

- (void)loadView {
    _callView = [[RTCBoardCallView alloc] initWithFrame:CGRectZero param:_boardParam];
    _callView.delegate = self;
    self.view = _callView;
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];

    // disable rest screen
    [[UIApplication sharedApplication] setIdleTimerDisabled:NO];
}

#pragma mark - Public

- (instancetype)initWithRTCBoardParam:(RTCBoardParam *)param {
    self = [super init];
    if (self) {
        _boardParam = param;
    }
    
    return self;
}

#pragma mark - Private

- (void)setupLayout {
    UIEdgeInsets safeAreaInsets = UIEdgeInsetsZero;
    if (@available(iOS 11.0, *)) {
        safeAreaInsets = [UIApplication sharedApplication].keyWindow.safeAreaInsets;
    } else {
        if ([UIDevice currentDevice].orientation == UIDeviceOrientationPortrait) {
            safeAreaInsets = UIEdgeInsetsMake(20, 0, 0, 0);
        }
    }
}

- (void)handleResult:(NSString *)result {
    if (result && result.length > 0) {
        // [self.view makeToast:result duration:2.0 position:CSToastPositionCenter];
        [self leaveRoom];
    }
}

- (void)leaveRoom {
    [[BaiduRtcBoardApi sharedManager] callWebLogout];

    [_callView stopLoading];
    [self clearWebViewCache];
}

- (void)clearWebViewCache {
    if ([[[UIDevice currentDevice]systemVersion]intValue ] >= 9.0) {
        NSArray * types = @[WKWebsiteDataTypeMemoryCache,WKWebsiteDataTypeDiskCache];
        NSSet *websiteDataTypes = [NSSet setWithArray:types];
        NSDate *dateFrom = [NSDate dateWithTimeIntervalSince1970:0];
        [[WKWebsiteDataStore defaultDataStore] removeDataOfTypes:websiteDataTypes modifiedSince:dateFrom completionHandler:^{}];
    } else {
        NSString *libraryPath = [NSSearchPathForDirectoriesInDomains(NSLibraryDirectory,NSUserDomainMask,YES) objectAtIndex:0];
        NSString *cookiesFolderPath = [libraryPath stringByAppendingString:@"/Cookies"];
        NSLog(@"%@", cookiesFolderPath);
        NSError *errors;
        [[NSFileManager defaultManager] removeItemAtPath:cookiesFolderPath error:&errors];
    }
}

- (BoardLoginParam *)generateWebLoginParamWithParam:(RTCBoardParam *)param {
    BoardLoginParam *loginParam = [[BoardLoginParam alloc] init];
    loginParam.channelName = param.channelName;
    loginParam.appId = param.appId;
    loginParam.token = param.token;
    loginParam.uid = param.uid;
    loginParam.debug = YES;
    loginParam.audience = param.audience;
    
    return loginParam;
}

#pragma mark - HeaderViewDelegate

- (void)onActionLeave {
    [self leaveRoom];
    [self dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark - BaiduRtcBoardDelegate

- (void)onRTCBoardLoaded {
    NSLog(@"[wb] onRTCBoardLoaded");
    BoardLoginParam *loginParam = [self generateWebLoginParamWithParam:_boardParam];
    [[BaiduRtcBoardApi sharedManager] callWebLoginWithParam:loginParam];
}

- (void)onRTCBoardCreateSucceed {
}

- (void)onRTCBoardJoinSucceed {
    NSLog(@"[wb] onRTCBoardJoinSucceed");
    [_callView onBoardCreateSucceed];
    [[BaiduRtcBoardApi sharedManager] callWebEnableDraw:YES];
}

- (void)onRTCBoardJoinFailed:(NSInteger)code error:(NSString *)error {
    NSLog(@"[wb] onRTCBoardJoinFailed: %ld, %@",(long)code, error);

    [self handleResult:error];
}

- (void)onRTCBoardCreateFailed:(NSInteger)code error:(NSString *)error {
    NSLog(@"[wb] onRTCBoardCreateFailed: %ld, %@",(long)code, error);
    
    [self handleResult:error];
}

- (void)onRTCBoardLeave {
    NSLog(@"[wb] onRTCBoardLeave");

    [_callView stopLoading];
    [self clearWebViewCache];
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (void)onRTCBoardError:(NSInteger)code error:(NSString *)error {
    NSLog(@"[wb] onRTCBoardError:%ld, %@",(long)code, error);
    
    [self handleResult:error];
}

- (void)onWebJsError:(NSString *)error {
    NSLog(@"[wb] onWebJsError : %@", error);
}

- (void)onWebGetAuth {
    NSLog(@"[wb] onWebGetAuth");
    
    [[BaiduRtcBoardApi sharedManager] callWebSendAuthWithAppSecret:_boardParam.token];
}

- (void)onRTCBoardStateChanged:(BoardRoomState *)state {
    // NSLog(@"[wb] onRTCBoardStateChanged");
    [_callView changedBoardState:state];
}

#pragma mark - BaiduRtcBoardWKDelegate

- (void)onDecidePolicyForNavigationAction:(WKNavigationAction *)navigationAction decisionHandler:(void (^)(WKNavigationActionPolicy))decisionHandler {
    if ([self needSaveImage:navigationAction]) {
        decisionHandler(WKNavigationActionPolicyCancel);
    } else {
        decisionHandler(WKNavigationActionPolicyAllow);
    }
}

- (void)onDecidePolicyForNavigationResponse:(WKNavigationResponse *)navigationResponse decisionHandler:(void (^)(WKNavigationResponsePolicy))decisionHandler {
    decisionHandler(WKNavigationResponsePolicyAllow);
}

#pragma mark - Save Image
- (void)onSnapshotTaken {
    [[BaiduRtcBoardApi sharedManager] captureBaiduRtcBoard:^(UIImage *capturedImage) {
        UIImageWriteToSavedPhotosAlbum(capturedImage, self, @selector(image:didFinishSavingWithError:contextInfo:), (__bridge void*)self);
        if ([[[UIDevice currentDevice]systemVersion] floatValue] <= 8.0) {
            UIAlertView *tmpAlertView = [[UIAlertView alloc] initWithTitle:@"" message:@"保存到相册成功！" delegate:self cancelButtonTitle:@"知道了" otherButtonTitles:nil];
            [tmpAlertView show];
        }else {
            UIAlertController *alterVc = [UIAlertController alertControllerWithTitle:@"" message:@"保存到相册成功！" preferredStyle:UIAlertControllerStyleAlert];
            UIAlertAction *okAction = [UIAlertAction actionWithTitle:@"知道了" style:UIAlertActionStyleDefault handler:nil];
            [alterVc addAction:okAction];
            [self presentViewController:alterVc animated:YES completion:nil];
        }

    }];
}

// save webview's element of image link
- (BOOL)needSaveImage:(WKNavigationAction *)navigationAction {
    NSString *requestString = navigationAction.request.URL.absoluteString;
    if ((navigationAction.navigationType == WKNavigationTypeLinkActivated) && [requestString rangeOfString:@"data:image/png;base64,"].location != NSNotFound) {
        NSString *dataString = [requestString stringByReplacingOccurrencesOfString:@"data:image/png;base64," withString:@""];
        NSData *imageData = [[NSData alloc] initWithBase64EncodedString:dataString options:NSDataBase64DecodingIgnoreUnknownCharacters];
        UIImage *image = [UIImage imageWithData:imageData];
        PHAuthorizationStatus status = [PHPhotoLibrary authorizationStatus];
        if (status == PHAuthorizationStatusNotDetermined) {
            [PHPhotoLibrary requestAuthorization:^(PHAuthorizationStatus status) {
                
            }];
        }
        if (status == PHAuthorizationStatusRestricted ||
            status == PHAuthorizationStatusDenied) {
            // [self.view makeToast:@"请开启相册权限" duration:2.0 position:CSToastPositionCenter];
        } else {
            UIImageWriteToSavedPhotosAlbum(image, self, @selector(image:didFinishSavingWithError:contextInfo:), (__bridge void*)self);
        }
        
        return YES;
    }
    
    return NO;
}

- (void)image:(UIImage *)image didFinishSavingWithError:(NSError *)error contextInfo: (void *)contextInfo {
    if (error != nil) {
        NSLog(@"Image Can not be saved");
        NSString *errMsg = [NSString stringWithFormat:@"图片保存失败%@", error.localizedDescription];
        // [self.view makeToast:errMsg duration:2.0 position:CSToastPositionCenter];
    } else {
        NSLog(@"Successfully saved Image");
        // [self.view makeToast:@"图片保存成功" duration:2.0 position:CSToastPositionCenter];
    }
}

- (UIModalPresentationStyle)modalPresentationStyle {
    return UIModalPresentationOverCurrentContext; // UIModalPresentationFullScreen;
}

@end
