//
//  RTCBoardCallView.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef RTCBoardCallView_h
#define RTCBoardCallView_h
#import <UIKit/UIKit.h>
#import "RTCBoardParam.h"
#import <BaiduRtcBoard/BaiduRtcBoardApi.h>
#import "RTCViewLayoutMacro.h"

@class RTCBoardCallView;

@protocol RTCBoardCallViewDelegate <NSObject>

- (void)mainViewAlertMessage:(NSString *)message;

- (void)onActionLeave;

- (void)onSnapshotTaken;

@end

// The main view of AppRTCMobile. It contains an input field for entering a room
// name on apprtc to connect to.
@interface RTCBoardCallView : UIView

- (instancetype)initWithFrame:(CGRect)frame param:(RTCBoardParam *)param;

@property(nonatomic, weak) id<RTCBoardCallViewDelegate> delegate;

- (void)setParams:(NSString *)uid roomName:(NSString *)roomName;

- (void)stopLoading;

- (void)changedBoardState:(BoardRoomState *)state;

- (void)onBoardCreateSucceed;

@end

typedef NS_ENUM(NSInteger, RTCRadioButtonType)
{
    RTC_RADIO_BUTTON_TYPE_COLOR              = 0,
    RTC_RADIO_BUTTON_TYPE_TOOLS              = 1,
};

#define UIColorFromRGBA(rgbValue, alphaValue) [UIColor \
colorWithRed:((float)((rgbValue & 0xFF0000) >> 16))/255.0 \
green:((float)((rgbValue & 0x00FF00) >> 8))/255.0 \
blue:((float)(rgbValue & 0x0000FF))/255.0 \
alpha:alphaValue]

@protocol RTCRadioButtonDelegate <NSObject>

- (void)onRadioButtonAdd:(RTCRadioButtonType)type button:(UIButton *)button index:(int)index;

- (void)onRadioButtonSelect:(RTCRadioButtonType)type button:(UIButton *)button index:(int)index;

@end

@interface RTCRadioButtonViews : UIView

- (instancetype)initWithFrame:(CGRect)frame hasBorder:(BOOL)hasBorder type:(RTCRadioButtonType)type
        viewWidth:(CGFloat)viewWidth viewCount:(int)viewCount index:(int)index
        delegate:(id<RTCRadioButtonDelegate>)delegate;

@property(nonatomic, weak) id<RTCRadioButtonDelegate> delegate;

@property(nonatomic, assign) RTCRadioButtonType type;

@end

@protocol RTCBoardSettingDelegate <NSObject>

- (void)onBackgroundTransparencyChanged:(int)value;

- (void)onBackgroundColorChanged:(int)index;

- (void)onSnapshotTaken;

@end

@interface RTCBoardSettingView : UIView

- (instancetype)initWithFrame:(CGRect)frame
                 transparency:(int)transparency
                   colorIndex:(int)colorIndex
                     delegate:(id<RTCBoardSettingDelegate>)delegate;

@property(nonatomic, weak) id<RTCBoardSettingDelegate> delegate;

@end

#endif /* RTCBoardCallView_h */
