//
//  RTCVoiceChangePanelView.m
//  rtc_sdk_ios
//
//  Created by 曹士谦 on 2022/7/27.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCVoiceChangePanelView.h"
#import <BaiduRtcRoom/BaiduRtcAudioProcessManager.h>

@interface RTCVoiceChangePanelView ()<UIPickerViewDelegate, UIPickerViewDataSource>

@property (nonatomic, strong) UIPickerView *pickerView;

@end

@implementation RTCVoiceChangePanelView

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self initView];
    }
    return self;
}

- (void)initView {
    [self addSubview:self.pickerView];
    [self.pickerView reloadAllComponents];
}

- (void)setSelectedVoiceChangeType:(int)selectedVoiceChangeType {
    _selectedVoiceChangeType = selectedVoiceChangeType;
    [self.pickerView selectRow:selectedVoiceChangeType inComponent:0 animated:NO];
}

#pragma mark - UIPickerViewDelegate & UIPickerViewDataSource

- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView {
    return 1;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component {
    return self.lastType + 1;
}

- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component {
    return [self titleForVoiceChangeType:(RtcVoiceChangeType)row];
}

- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component {
    if (self.selectedVoiceChangeTypeChanged) {
        self.selectedVoiceChangeTypeChanged((int)row);
    }
}

#pragma mark - Privates

- (NSString *)titleForVoiceChangeType:(RtcVoiceChangeType)type {
    switch (type) {
        case RtcVoiceChangeTypeOriginal: return @"原声";
        case RtcVoiceChangeTypeLuoli: return @"萝莉";
        case RtcVoiceChangeTypeDaShu: return @"大叔";
        case RtcVoiceChangeTypeZhengTai: return @"正太";
        case RtcVoiceChangeTypeFeiZai: return @"肥宅";
        case RtcVoiceChangeTypeKTV: return @"KTV";
        case RtcVoiceChangeTypeFo: return @"佛祖";
        default: return @"";
    }
}

- (RtcVoiceChangeType)lastType {
    return RtcVoiceChangeTypeFo;
}

- (UIPickerView *)pickerView {
    if (!_pickerView) {
        _pickerView = [[UIPickerView alloc] initWithFrame:CGRectMake(0, 0, self.frame.size.width, 250)];
        _pickerView.layer.masksToBounds = YES;
        _pickerView.backgroundColor = [UIColor whiteColor];
        _pickerView.delegate = self;
        _pickerView.dataSource = self;
    }
    return _pickerView;
}

@end
