//
//  RTCTextField.m
//  RtcBoxApp
//
//  Created by 曹士谦 on 2024/3/19.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import "RTCTextField.h"

@implementation RTCTextField {
    UITextField *_roomText;
    UIView *_roomTextUnderLine;
}

- (instancetype)initWithFrame:(CGRect)frame {
    return [self initWithFrame:frame delegate:nil];
}

- (instancetype)initWithFrame:(CGRect)frame delegate:(id<NoticeextFieldSaveDelegate>)noticeFieldDelegate {
    if (self = [super initWithFrame:frame]) {
        _roomText = [[UITextField alloc] initWithFrame:CGRectZero];
        _roomText.borderStyle = UITextBorderStyleNone;
        _roomText.font = [UIFont fontWithName:@"Roboto" size:12];
        _roomText.placeholder = @"请输入房间号";
//        _roomText.autocorrectionType = UITextAutocorrectionTypeNo;
//        _roomText.autocapitalizationType = UITextAutocapitalizationTypeNone;
//        _roomText.clearButtonMode = UITextFieldViewModeAlways;
        _roomText.delegate = self;
        [self addSubview:_roomText];
        
        _delegate = noticeFieldDelegate;

        // Give rounded corners and a light gray border.
//        self.layer.borderWidth = 1;
//        self.layer.borderColor = [[UIColor lightGrayColor] CGColor];
//        self.layer.cornerRadius = 2;
    }
    return self;
}
- (void)dealloc {
}
- (void)layoutSubviews {
    _roomText.frame =
    CGRectMake(kRoomTextFieldMargin, 0, CGRectGetWidth(self.bounds) - kRoomTextFieldMargin,
               kRoomTextFieldHeight);
    _roomTextUnderLine = [[UIView alloc] initWithFrame:CGRectMake(0,
                                                                 _roomText.frame.size.height - 2,
                                                                 _roomText.frame.size.width, 1)];
    _roomTextUnderLine.backgroundColor = [UIColor grayColor];
    [_roomText addSubview:_roomTextUnderLine];
}

- (CGSize)sizeThatFits:(CGSize)size {
    size.height = kRoomTextFieldHeight;
    return size;
}

- (NSString *)roomText {
    return _roomText.text;
}

- (void)setRoomText:(NSString *)roomText {
    _roomText.text = roomText;
}

- (void)setPlaceHolder:(NSString *)ph {
    _roomText.placeholder = ph;
}

- (void)setTextFieldEnable:(BOOL)bEnable {
    _roomText.enabled = bEnable;
}

#pragma mark - UITextFieldDelegate

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    // There is no other control that can take focus, so manually resign focus
    // when return (Join) is pressed to trigger |textFieldDidEndEditing|.
    if (_roomText.text.length != 0) {
        _roomTextUnderLine.backgroundColor = [UIColor systemBlueColor];
    } else {
        _roomTextUnderLine.backgroundColor = [UIColor grayColor];
    }
    [textField resignFirstResponder];
    
    if ([self.delegate respondsToSelector:@selector(onNoticeSave:)]) {
        [self.delegate onNoticeSave:self];
    }
    return YES;
}
@end
