//
//  RTCStatsView.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCStatsView.h"
#import <BaiduRtcRoom/BaiduRtcRoom.h>

@interface RTCStatsView ()
@property (nonatomic, strong) BRTC_TYPE(RTCStatsBuilder) *statsBuilder;
@end

@implementation RTCStatsView {
    UILabel *_statsLabel;
}

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        _statsLabel = [[UILabel alloc] initWithFrame:CGRectZero];
        _statsLabel.numberOfLines = 0;
        _statsLabel.font = [UIFont fontWithName:@"AppleGothic" size:10];
        _statsLabel.adjustsFontSizeToFitWidth = YES;
        _statsLabel.minimumScaleFactor = 0.6;
        _statsLabel.textColor = [UIColor whiteColor];
        [self addSubview:_statsLabel];
        self.backgroundColor = [UIColor colorWithWhite:0 alpha:0.2];
        UITapGestureRecognizer *tapRecognizerOfStates =
        [[UITapGestureRecognizer alloc]
         initWithTarget:self
         action:@selector(onTapScreen:)];
        tapRecognizerOfStates.numberOfTapsRequired = 3;
        [self addGestureRecognizer:tapRecognizerOfStates];
        self.roomAttribute = nil;
    }
    return self;
}
- (void)resetResource {
    _statsBuilder =  nil;
}

- (BRTC_TYPE(RTCStatsBuilder) *)statsBuilder {
    if (!_statsBuilder) {
        _statsBuilder = [[BRTC_TYPE(RTCStatsBuilder) alloc] init];
    }
    return  _statsBuilder;
}
- (void)setStats:(NSArray *)stats {
    [self.statsBuilder parseStatsArray:stats];
    if (self.roomAttribute) {
        NSString *outStr = [NSString stringWithFormat:@"%@ %@\n %@",
                        self.sdkVerion, self.roomAttribute, self.statsBuilder.statsString];
        _statsLabel.text = outStr;
    } else {
        NSString *outStr = [NSString stringWithFormat:@"%@\n %@",
                        self.sdkVerion, self.statsBuilder.statsString];
        _statsLabel.text = outStr;
    }
}

- (void)resetRecvStats {
    [self.statsBuilder resetRecvStats];
}

- (void)startRecvStats {
    [self.statsBuilder startRecvStats];
}

- (void)setRenderStepTs:(int)state
                 result:(int)result
                   time:(uint64_t)time {
    [self.statsBuilder setRenderStepTs:state result:result time:time];
}

- (void)setNetworkDemoteState:(NSString *)state {
    [self.statsBuilder setNetworkDemoteState:state];
}

- (void)layoutSubviews {
    _statsLabel.frame = self.bounds;
}

- (CGSize)sizeThatFits:(CGSize)size {
    return [_statsLabel sizeThatFits:size];
}

- (void)onTapScreen:(UITapGestureRecognizer *)recognizer {
    [self.videoCallViewDelegate didTripleTap:recognizer];
}

@end

