//
//  RTCStatsView.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef RTCStatsView_h
#define RTCStatsView_h
#import <UIKit/UIKit.h>

@protocol VideoCallViewDelegate <NSObject>
- (void)didTripleTap:(UITapGestureRecognizer *)recognizer;
@end

@interface RTCStatsView : UIView
@property (nonatomic, copy) NSString *sdkVerion;
@property (nonatomic, copy) NSString *roomAttribute;
@property (nonatomic, weak) id<VideoCallViewDelegate> videoCallViewDelegate;
- (void)setStats:(NSArray *)stats;
- (void)resetResource;
- (void)setRenderStepTs:(int)state
                 result:(int)result
                   time:(uint64_t)time;
- (void)setNetworkDemoteState:(NSString *)state;
- (void)resetRecvStats;
- (void)startRecvStats;
@end

#endif /* RTCStatsView_h */
