//
//  RTCSettingsViewController.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCSettingsViewController.h"
#import "RTCSettingsTextTableViewCell.h"
#import "BaiduRtcRoom/BaiduRtcRoom.h"
#import "RTCSettingsModel.h"
#import "RTCSettingsParametersController.h"
#import "RTCSettingsSignalController.h"
#import "RTCSettingsAudioController.h"
#import "RTCSettingsVideoController.h"
#import "RTCSettingsScreenController.h"
#import "RTCSettingsLastmileController.h"
#import "RTCSettingsLiveController.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(int, RTCSettingsSections) {
    RTCSettingsSectionBasicSettings = 0,
    RTCSettingsSectionLogMode,
    RTCSettingsSectionWhiteBoard,
    __RTCSettingsSectionsEnd
};

typedef NS_ENUM(int, RTCBasicSectionOptions) {
    RTCBasicSectionSignal = 0,
    RTCBasicSectionAudio,
    RTCBasicSectionVideo,
    RTCBasicSectionParams,
    RTCBasicSectionScreen,
    RTCBasicSectionLive,
    RTCBasicSectionLastmile,
    RTCBasicSectionMax,
};

typedef NS_ENUM(int, RTCLogSettingsOptions) {
    RTCLogQualityMonitorSettings = 0,
    RTCLogWeakNetQualityReportSettings,
    RTCLogEnableVerboseSettings,
};

typedef NS_ENUM(int, RTCBoardSettingsOptions) {
    RTCBoardAudienceSettings = 0,
};

typedef NS_ENUM(int, RTCVideoShowingOptions) {
    RTCSessionModeTwoPlayers,
    RTCSessionModeMultiPlayers,
};

@interface RTCSettingsViewController () <UITextFieldDelegate, RTCSettingsTextTableViewCellDelegate> {
    RTCSettingsModel *_settingsModel;
}
@end

@implementation RTCSettingsViewController

- (instancetype)initWithStyle:(UITableViewStyle)style
                settingsModel:(RTCSettingsModel *)settingsModel {
    self = [super initWithStyle:style];
    if (self) {
        _settingsModel = settingsModel;
    }
    return self;
}

- (void)dealloc {
    [_settingsModel sync];
}

#pragma mark - View lifecycle
- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"设置";
    [self addDoneBarButton];
}

#pragma mark -
- (void)addDoneBarButton {
    UIBarButtonItem *barItem = [[UIBarButtonItem alloc]
                                    initWithBarButtonSystemItem:UIBarButtonSystemItemDone
                                                         target:self
                                                         action:@selector(dismissModally:)];
    self.navigationItem.leftBarButtonItem = barItem;
}

- (void)dismissModally:(id)sender {
    [self dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark - Table view data source
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return __RTCSettingsSectionsEnd;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    switch (section) {
        case RTCSettingsSectionBasicSettings:
            return RTCBasicSectionMax;
        case RTCSettingsSectionLogMode:
            return 3;
        case RTCSettingsSectionWhiteBoard:
            return 1;
        default:
            return 1;
    }
}

#pragma mark - Table view delegate
- (nullable NSString *)tableView:(UITableView *)tableView
         titleForHeaderInSection:(NSInteger)section {
    switch (section) {
        case RTCSettingsSectionBasicSettings:
            return @"基础设置";
        case RTCSettingsSectionLogMode:
            return @"日志";
        case RTCSettingsSectionWhiteBoard:
            return @"白板";
        default:
            return @"";
    }
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    switch (indexPath.section) {
        case RTCSettingsSectionBasicSettings:
            return [self BasicTableViewCellForTableView:tableView atIndexPath:indexPath];
        case RTCSettingsSectionLogMode:
            return [self logSettingsTableViewCellForTableView:tableView atIndexPath:indexPath];
        case RTCSettingsSectionWhiteBoard:
            return [self boardSettingsTableViewCellForTableView:tableView atIndexPath:indexPath];
        default:
            return [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                          reuseIdentifier:@"identifier"];
    }
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    switch (indexPath.section) {
        case RTCSettingsSectionBasicSettings:
            [self tableView:tableView didSelectBasicCellAtIndexPath:indexPath];
            [self.tableView reloadData];
            break;
    }
}
- (void)settingsTextCellDidEngEditing:(RTCSettingsTextTableViewCell *)cell {
    
}
#pragma mark - Table view delegate (VideoBgPushMode)
- (UITableViewCell *)BasicTableViewCellForTableView:(UITableView *)tableView
                                             atIndexPath:(NSIndexPath *)indexPath {
    NSString *title = nil;
    switch (indexPath.row) {
        case RTCBasicSectionSignal:
            title = @"信令设置";
            break;
        case RTCBasicSectionAudio:
            title = @"音频设置";
            break;
        case RTCBasicSectionVideo:
            title = @"视频设置";
            break;
        case RTCBasicSectionParams:
            title = @"参数设置";
            break;
        case RTCBasicSectionScreen:
            title = @"屏幕共享";
            break;
        case RTCBasicSectionLive:
            title = @"直播转推";
            break;
        case RTCBasicSectionLastmile:
            title = @"网络测速";
            break;
    }
    NSString * identifier = @"RTCSettingsBasicCellIdentifier";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                    reuseIdentifier:identifier];
    }
    cell.textLabel.text = title;
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    return cell;
}

- (void)tableView:(UITableView *)tableView
        didSelectBasicCellAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewController *controller;
    switch (indexPath.row) {
        case RTCBasicSectionSignal:
            controller = [[RTCSettingsSignalController alloc] initWithStyle:UITableViewStyleGrouped
                                    settingsModel:_settingsModel];
            break;
        case RTCBasicSectionAudio:
            controller = [[RTCSettingsAudioController alloc] initWithStyle:UITableViewStyleGrouped
                                    settingsModel:_settingsModel];
            break;
        case RTCBasicSectionVideo:
            controller = [[RTCSettingsVideoController alloc] initWithStyle:UITableViewStyleGrouped
                                    settingsModel:_settingsModel];
            break;
        case RTCBasicSectionParams:
            controller = [[RTCSettingsParametersController alloc] initWithStyle:UITableViewStyleGrouped
                                    settingsModel:_settingsModel];
            break;
        case RTCBasicSectionScreen:
            controller = [[RTCSettingsScreenController alloc] initWithStyle:UITableViewStyleGrouped
                                    settingsModel:_settingsModel];
            break;
        case RTCBasicSectionLive:
            controller = [[RTCSettingsLiveController alloc] initWithStyle:UITableViewStyleGrouped
                                    settingsModel:_settingsModel];
            break;
        case RTCBasicSectionLastmile:
            controller = [[RTCSettingsLastmileController alloc] initWithStyle:UITableViewStyleGrouped
                                    settingsModel:_settingsModel];
            break;
    }

    UINavigationController *navigationController =
    [[UINavigationController alloc] initWithRootViewController:controller];
    [navigationController setModalTransitionStyle:UIModalTransitionStyleCrossDissolve];
    [self presentViewController:navigationController animated:YES completion:nil];
}

#pragma mark - Table view delegate(Session mode settings)
- (UITableViewCell *)sessionSettingsTableViewCellForTableView:(UITableView *)tableView
                                                atIndexPath:(NSIndexPath *)indexPath {
    NSString *dequeueIdentifier = @"RTCSettingsSessionSettingsCellIdentifier";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:dequeueIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                      reuseIdentifier:dequeueIdentifier];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        UISwitch *switchView = [[UISwitch alloc] initWithFrame:CGRectZero];
        switchView.tag = indexPath.row;
        [switchView addTarget:self
                       action:@selector(sessionSettingSwitchChanged:)
             forControlEvents:UIControlEventValueChanged];
        cell.accessoryView = switchView;
    }

    cell.textLabel.text = [self labelForSessionSettingAtIndexPathRow:indexPath.row];
    UISwitch *switchView = (UISwitch *)cell.accessoryView;
    switchView.on = [self valueForSessionSettingAtIndexPathRow:indexPath.row];
    return cell;
}

- (void)sessionSettingSwitchChanged:(UISwitch *) sender {
    switch (sender.tag) {
        case RTCSessionModeTwoPlayers: {
            [_settingsModel storeSessionModeSetting:sender.isOn];
            break;
        }
        case RTCSessionModeMultiPlayers: {
            //[_settingsModel storeSessionModeSetting:sender.isOn];
            break;
        }
        default:
            break;
    }
}

- (NSString *)labelForSessionSettingAtIndexPathRow:(NSInteger)setting {
    switch (setting) {
        case RTCSessionModeTwoPlayers:
            return @"多人会话(3人及以上)";
        case RTCSessionModeMultiPlayers:
            return @"";
        default:
            return @"";
    }
}

- (BOOL)valueForSessionSettingAtIndexPathRow:(NSInteger)setting {
    switch (setting) {
        case RTCSessionModeTwoPlayers:
            return [_settingsModel currentSessionModeSettingFromStore];
        case RTCSessionModeMultiPlayers:
            //return [_settingsModel currentSessionModeSettingFromStore];
        default:
            return NO;
    }
}

- (NSString *)labelForLogSettingAtIndexPathRow:(NSInteger)setting {
    switch (setting) {
        case RTCLogQualityMonitorSettings:
            return @"质量监控日志";
        case RTCLogWeakNetQualityReportSettings:
            return @"弱网质量上报";
        case RTCLogEnableVerboseSettings:
            return @"本地调试日志";
        default:
            return @"";
    }
}

- (BOOL)valueForLogSettingAtIndexPathRow:(NSInteger)setting {
    switch(setting) {
        case RTCLogQualityMonitorSettings:
            return  [_settingsModel currentLogQualityMonitorSetting];
        case RTCLogWeakNetQualityReportSettings:
            return [_settingsModel currentLogWeakNetQualityReportSetting];
        case RTCLogEnableVerboseSettings:
            return [_settingsModel currentLogEnableVerboseSetting];
        default:
            return NO;
    }
}

#pragma mark -Table view delegete(log setting)
- (UITableViewCell *)logSettingsTableViewCellForTableView:(UITableView *)tableView
                                        atIndexPath:(NSIndexPath *)indexPath {
    NSString *dequeueIdentifier = @"RTCSettingsLogViewCellIdentifier";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:dequeueIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                    reuseIdentifier:dequeueIdentifier];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        UISwitch *switchView = [[UISwitch alloc] initWithFrame:CGRectZero];
        switchView.tag = indexPath.row;
        [switchView addTarget:self
                    action:@selector(logSettingSwitchChanged:)
            forControlEvents:UIControlEventValueChanged];
        cell.accessoryView = switchView;
    }
    cell.textLabel.text = [self labelForLogSettingAtIndexPathRow:indexPath.row];
    UISwitch *switchView = (UISwitch *)cell.accessoryView;
    switchView.on = [self valueForLogSettingAtIndexPathRow:indexPath.row];
    return cell;
}

- (void)logSettingSwitchChanged:(UISwitch *) sender {
    switch (sender.tag) {
        case RTCLogQualityMonitorSettings: {
            [_settingsModel storeLogQualityMonitorSetting:sender.isOn];
            break;
        }
        case RTCLogWeakNetQualityReportSettings: {
            [_settingsModel storeLogWeakNetQualityReportSetting:sender.isOn];
            break;
        }
        case RTCLogEnableVerboseSettings: {
            [_settingsModel storeLogEnableVerboseSetting:sender.isOn];
            break;
        }
        default:
            break;
    }
}

#pragma mark -Table view delegete(whiteboard setting)
- (UITableViewCell *)boardSettingsTableViewCellForTableView:(UITableView *)tableView
                                        atIndexPath:(NSIndexPath *)indexPath {
    NSString *dequeueIdentifier = @"RTCSettingsBoardViewCellIdentifier";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:dequeueIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                    reuseIdentifier:dequeueIdentifier];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        UISwitch *switchView = [[UISwitch alloc] initWithFrame:CGRectZero];
        switchView.tag = indexPath.row;
        [switchView addTarget:self
                    action:@selector(boardSettingSwitchChanged:)
            forControlEvents:UIControlEventValueChanged];
        cell.accessoryView = switchView;
    }
    cell.textLabel.text = [self labelForBoardSettingAtIndexPathRow:indexPath.row];
    UISwitch *switchView = (UISwitch *)cell.accessoryView;
    switchView.on = [self valueForBoardSettingAtIndexPathRow:indexPath.row];
    return cell;
}

- (void)boardSettingSwitchChanged:(UISwitch *) sender {
    switch (sender.tag) {
        case RTCBoardAudienceSettings: {
            [_settingsModel storeBoardAudience:sender.isOn];
            break;
        }
        default:
            break;
    }
}

- (NSString *)labelForBoardSettingAtIndexPathRow:(NSInteger)setting {
    switch (setting) {
        case RTCBoardAudienceSettings:
            return @"观众模式";
        default:
            return @"";
    }
}

- (BOOL)valueForBoardSettingAtIndexPathRow:(NSInteger)setting {
    switch(setting) {
        case RTCBoardAudienceSettings:
            return  [_settingsModel currentBoardAudienceFromStore];
        default:
            return NO;
    }
}

#pragma mark - Table view delegtate(server Settings)
- (void)liveMixTemplateTextFieldDidEndEditing:(id)sender {
    [self.view endEditing:YES];
}

@end
NS_ASSUME_NONNULL_END

