//
//  RTCSettingsVideoController.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCSettingsVideoController.h"
#import "RTCSettingsTextTableViewCell.h"
#import "BaiduRtcRoom/BaiduRtcRoom.h"
#import "RTCSettingsModel.h"

NS_ASSUME_NONNULL_BEGIN

static NSArray<NSString *> *degragationSaticValues() {
    return @[@"保持帧率", @"保持分辨率", @"平衡模式"];
}

typedef NS_ENUM(int, RTCSettingsSections) {
    RTCSettingsSectionVideoCodec = 0,
    RTCSettingsSectionVideoFps,
    RTCSettingsSectionMinBitRate,
    RTCSettingsSectionMaxBitRate,
    RTCSettingsSectionVideoSettings,
    __RTCSettingsSectionsEnd
};

typedef NS_ENUM(int, RTCReslutionBitrate) {
    RTCBitrate_3840x2160 = 10000,
    RTCBitrate_2160x1440 = 5000,
    RTCBitrate_1920x1080 = 2500,
    RTCBitrate_1280x720  = 1500,
    RTCBitrate_640x480   =  600,
    RTCBitrate_480x360   =  500,
    RTCBitrate_352x288   =  400,
    RTCBitrate_176x144   =  256,
    RTCBitrateDefault    =  600,
};

static NSArray<NSNumber *> *videoResolutionBitrates() {
    return @[
        @(RTCBitrate_3840x2160 ),
        @(RTCBitrate_2160x1440 ),
        @(RTCBitrate_1920x1080 ),
        @(RTCBitrate_1280x720  ),
        @(RTCBitrate_640x480   ),
        @(RTCBitrate_480x360   ),
        @(RTCBitrate_352x288   ),
        @(RTCBitrate_176x144   ),
        @(RTCBitrateDefault    ),
    ];
}

typedef NS_ENUM(int, RTCVideoSettingsOptions) {
    RTCVideoSettingsVideoFixedResolution = 0,
    RTCVideoSettingsUsingFrontCamera
};

typedef NS_ENUM(int, RTCVideoSectionOptions) {
    RTCVideoSectionCodec = 0,
    RTCVideoSectionCaptureResolution,
    RTCVideoSectionEncodeResolution,
    RTCVideoSectionDegradation,
    RTCVideoSectionMax,
};

@interface RTCSettingsVideoController () {
}
@property (nonatomic, strong)  RTCSettingsModel *settingsModel;

@end

@implementation RTCSettingsVideoController

- (instancetype)initWithStyle:(UITableViewStyle)style
                settingsModel:(RTCSettingsModel *)settingsModel {
    self = [super initWithStyle:style];
    if (self) {
        self.settingsModel = settingsModel;
    }
    return self;
}

- (void)dealloc {
    [_settingsModel sync];
}

#pragma mark - Data source
- (NSArray<NSString *> *)videoCaptureResolutionArray {
    return [_settingsModel outputVideoCaptureResultions];
}

- (NSArray<NSString *> *)videoEncoderResolutionArray {
    return [_settingsModel outputVideoEncoderResultions];
}

- (NSArray<NSString *> *)videoCodecArray {
    return [_settingsModel availableVideoCodecs];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return __RTCSettingsSectionsEnd;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    switch (section) {
        case RTCSettingsSectionVideoFps:
            return 1;
        case RTCSettingsSectionVideoSettings:
            return 2;
        case RTCSettingsSectionVideoCodec:
            return RTCVideoSectionMax;
        default:
            return 1;
    }
}

- (nullable NSString *)tableView:(UITableView *)tableView
         titleForHeaderInSection:(NSInteger)section {
    switch (section) {
        case RTCSettingsSectionVideoFps:
            return @"视频帧率(fps)";
        case RTCSettingsSectionVideoSettings:
            return @"视频";
        case RTCSettingsSectionVideoCodec:
            return @"视频编解码";
        case RTCSettingsSectionMinBitRate:
            return @"最小码率";
        case RTCSettingsSectionMaxBitRate:
            return @"最大码率";
        default:
            return @"";
    }
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    switch (indexPath.section) {
        case RTCSettingsSectionVideoFps:
            return [self fpsTableViewCellForTableView:tableView atIndexPath:indexPath forSetion:RTCSettingsSectionVideoFps];
        case RTCSettingsSectionVideoSettings:
            return [self videoSettingsTableViewCellForTableView:tableView atIndexPath:indexPath];
        case RTCSettingsSectionVideoCodec:
            return [self videoCodecTableViewCellForTableView:tableView atIndexPath:indexPath];
        case RTCSettingsSectionMaxBitRate:
            return [self bitrateTableViewCellForTableView:tableView atIndexPath:indexPath forSection:RTCSettingsSectionMaxBitRate];
        case RTCSettingsSectionMinBitRate:
            return [self bitrateTableViewCellForTableView:tableView atIndexPath:indexPath forSection:RTCSettingsSectionMinBitRate];
        default:
            return [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                          reuseIdentifier:@"identifier"];
    }
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    switch (indexPath.section) {
        case RTCSettingsSectionVideoCodec:
            [self tableView:tableView didSelectVideoCodecCellAtIndexPath:indexPath];
            [self.tableView reloadData];
            break;
        case RTCSettingsSectionVideoFps:
        case RTCSettingsSectionMinBitRate:
        case RTCSettingsSectionMaxBitRate:
            [self tableView:tableView defSelectRowAtIndexPath:indexPath];
            break;
    }
}

#pragma mark - Table view delegate(fps)
- (UITableViewCell *)fpsTableViewCellForTableView:(UITableView *)tableView atIndexPath:(NSIndexPath *)indexPath forSetion:(RTCSettingsSections)section {
    SEL sel = @selector(currentVideoFpsSettingFromStore);
    UITableViewCell *cell = [self baseTextTableViewCellForTableView:tableView section:section valueSEL:sel placeHolder:@"请输入视频帧率(fps)" isNumber:YES settingsModel:_settingsModel];
    return cell;
}

#pragma mark - Table view delegate(Video Resolution)
- (UITableViewCell *)videoSettingsTableViewCellForTableView:(UITableView *)tableView atIndexPath:(NSIndexPath *)indexPath {
    NSString *dequeueIdentifier = @"RTCSettingsVideoSettingsCellIdentifier";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:dequeueIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:dequeueIdentifier];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        UISwitch *switchView = [[UISwitch alloc] initWithFrame:CGRectZero];
        switchView.tag = indexPath.row;
        [switchView addTarget:self action:@selector(videoSettingsSwitchChanged:) forControlEvents:UIControlEventValueChanged];
        cell.accessoryView = switchView;
    }

    cell.textLabel.text = [self labelForVideoSettingAtIndexPathRow:indexPath.row];
    UISwitch *switchView = (UISwitch *)cell.accessoryView;
    switchView.on = [self valueForVideoSettingsAtIndexPathRow:indexPath.row];
    return cell;
}

- (NSInteger)resolutionTobitrate:(NSString*)resolution {
    RTCReslutionBitrate result = RTCBitrateDefault;
    NSUInteger idx = [self.videoEncoderResolutionArray indexOfObject:resolution];
    if (idx != NSNotFound) {
        NSArray *bitrates = videoResolutionBitrates();
        if (bitrates.count > idx) {
            return [bitrates[idx] integerValue];
        }
    }
    return  result;
}

#pragma mark - Table view delegate(Video Codec)
- (UITableViewCell *)videoCodecTableViewCellForTableView:(UITableView *)tableView
                                             atIndexPath:(NSIndexPath *)indexPath {
    NSString *title = nil, *key = nil;
    switch (indexPath.row) {
        case RTCVideoSectionCodec:
            title = @"编解码";
            key = [_settingsModel currentVideoCodecSettingFromStore];
            break;
        case RTCVideoSectionCaptureResolution: {
            title = @"采集分辨率";
            key = [_settingsModel currentCaptureVideoResolutionSettingFromStore];
            break;
        }
        case RTCVideoSectionEncodeResolution: {
            title = @"编码分辨率";
            key = [_settingsModel currentVideoResolutionSettingFromStore];
            break;
        }
        case RTCVideoSectionDegradation: {
            title = @"降级策略";
            int index = [_settingsModel currentVideoDegradationFromStore];
            key = degragationSaticValues()[index];
            break;
        }
    }
    return [self tableCellForTableView:tableView
                            identifier:@"RTCSettingsVideoCodecCellIdentifier"
                                 title:title
                                   key:key
                           atIndexPath:indexPath];
}

- (void)tableView:(UITableView *)tableView
        didSelectVideoCodecCellAtIndexPath:(NSIndexPath *)indexPath {
    NSArray<NSString *> *arraySelect = nil;
    switch (indexPath.row) {
        case RTCVideoSectionCodec:
            arraySelect = self.videoCodecArray;
            break;
        case RTCVideoSectionCaptureResolution:
            arraySelect = [_settingsModel outputVideoCaptureResultions];
            break;
        case RTCVideoSectionEncodeResolution:
            arraySelect = [self videoEncoderResolutionArray];
            break;
        case RTCVideoSectionDegradation:
            arraySelect = degragationSaticValues();
            break;
    }
    [self tableView:tableView arraySelect:arraySelect success:^(int index) {
        switch (indexPath.row) {
            case RTCVideoSectionCodec: {
                NSString *videoCodec = self.videoCodecArray[index];
                [self.settingsModel storeVideoCodecSetting:videoCodec];
                break;
            }
            case RTCVideoSectionCaptureResolution:
                [self.settingsModel storeCaptureVideoResolutionSetting:[self.settingsModel outputVideoCaptureResultions][index]];
                break;
            case RTCVideoSectionEncodeResolution: {
                NSString *videoResolution = self.videoEncoderResolutionArray[index];
                NSInteger maxBitrate = [self resolutionTobitrate:videoResolution];
                [self.settingsModel storeMaxBitrateSetting:[NSNumber numberWithInteger:maxBitrate]];
                [self.settingsModel storeVideoResolutionSetting:videoResolution];
                break;
            }
            case RTCVideoSectionDegradation:
                [self.settingsModel storeVideoDegradation:index];
                break;
        }
    }];
}

#pragma mark - Table view delegate(Bitrate)
- (UITableViewCell *)bitrateTableViewCellForTableView:(UITableView *)tableView atIndexPath:(NSIndexPath *)indexPath forSection:(RTCSettingsSections)section {
//    SEL sel = section == RTCSettingsSectionBitRate ? @selector(currentMaxBitrateSettingFromStore) : @selector(currentScreenShareMaxBitrateSettingFromStore);
    if (section == RTCSettingsSectionMaxBitRate) {
        SEL sel = @selector(currentMaxBitrateSettingFromStore);
        UITableViewCell *cell = [self baseTextTableViewCellForTableView:tableView section:section valueSEL:sel placeHolder:@"输入最大的码率(kbps)" isNumber:YES settingsModel:_settingsModel];
        return cell;
    }
    if (section == RTCSettingsSectionMinBitRate) {
        SEL sel = @selector(currentMinBitrateSettingFromStore);
        UITableViewCell *cell = [self baseTextTableViewCellForTableView:tableView section:section valueSEL:sel placeHolder:@"输入最小的码率(kbps)" isNumber:YES settingsModel:_settingsModel];
        return cell;
    }
    return nil;
}

- (void)settingsTextCellDidEngEditing:(RTCSettingsTextTableViewCell *)cell {
    if (cell.text.length == 0) return;
    
    NSNumber *val = [NSNumber numberWithInteger:cell.text.integerValue];
    switch ((RTCSettingsSections)cell.section) {
        case RTCSettingsSectionVideoFps:
            [_settingsModel storeVideoFpsSetting:val];
            break;
        case RTCSettingsSectionMinBitRate:
            [_settingsModel storeMinBitrateSetting:val];
            break;
        case RTCSettingsSectionMaxBitRate:
            [_settingsModel storeMaxBitrateSetting:val];
            break;
        default:
            break;
    }
}

- (NSString *)labelForVideoSettingAtIndexPathRow:(NSInteger)setting {
    switch (setting) {
        case RTCVideoSettingsVideoFixedResolution:
            return @"是否开启固定分辨率";
        case RTCVideoSettingsUsingFrontCamera:
            return @"是否前置摄像头";
        default:
            return @"";
    }
}

- (BOOL)valueForVideoSettingsAtIndexPathRow:(NSInteger)setting {
    switch (setting) {
        case RTCVideoSettingsVideoFixedResolution:
            return [_settingsModel currentIsFixedResolutionSettingFromStore];
        case RTCVideoSettingsUsingFrontCamera:
            return [_settingsModel currentUsingFrontCameraSettingFromStore];
        default:
            return NO;
    }
}

- (void)videoSettingsSwitchChanged:(UISwitch *)sender {
    switch (sender.tag) {
        case RTCVideoSettingsVideoFixedResolution:
            [_settingsModel storeIsFixedResolutionSetting:sender.isOn];
            break;
        case RTCVideoSettingsUsingFrontCamera:
            [_settingsModel storeUsingFrontCameraSetting:sender.isOn];
            break;
        default:
            return;
    }
}

#pragma mark - View lifecycle
- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"视频设置";
    [self addDoneBarButton];
}

@end
NS_ASSUME_NONNULL_END

