//
//  RTCSettingsTextTableViewCell.m
//  rtc_sdk_ios
//
//  Created by 曹士谦 on 2022/3/1.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCSettingsTextTableViewCell.h"

@interface RTCSettingsTextTableViewCell()<UITextFieldDelegate>

@property (nonatomic, strong) UITextField *textField;
@property (nonatomic, weak) UIView *hostView;

@end

@implementation RTCSettingsTextTableViewCell

- (instancetype)initWithHostView:(UIView *)hostView {
    if (self = [super initWithStyle:UITableViewCellStyleDefault reuseIdentifier:RTCSettingsTextTableViewCellIdentifier]) {
        _enableEdit = YES;
        _hostView = hostView;
        [self initView];
    }
    return self;
}

- (void)initView {
    UITextField *textField = [[UITextField alloc]
                              initWithFrame:CGRectMake(10, 0, self.bounds.size.width - 20, self.bounds.size.height)];
    textField.keyboardType = self.keyboardType;
    textField.delegate = self;
    textField.userInteractionEnabled = YES;

    // Numerical keyboards have no return button, we need to add one manually.
    UIToolbar *numberToolbar = [[UIToolbar alloc] initWithFrame:CGRectMake(0, 0, self.hostView.bounds.size.width, 50)];
    UIBarButtonItem *applyBtn = [[UIBarButtonItem alloc] initWithTitle:@"应用" style:UIBarButtonItemStyleDone target:self
                                                                action:@selector(numberTextFieldDidEndEditing:)];
    numberToolbar.items = @[
                            [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace
                                                                          target:nil
                                                                          action:nil],
                            applyBtn];
    [numberToolbar sizeToFit];

    textField.inputAccessoryView = numberToolbar;
    [self addSubview:textField];
    self.textField = textField;
}

- (void)setKeyboardType:(UIKeyboardType)keyboardType {
    _keyboardType = keyboardType;
    self.textField.keyboardType = keyboardType;
}

- (void)setPlaceholder:(NSString *)placeholder {
    _placeholder = placeholder;
    self.textField.placeholder = placeholder;
}

- (void)setText:(NSString *)text {
    _text = text;
    self.textField.text = text;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

- (void)numberTextFieldDidEndEditing:(UIBarButtonItem *)sender {
    self.text = self.textField.text;
    if ([self.delegate respondsToSelector:@selector(settingsTextCellDidEngEditing:)]) {
        [self.delegate settingsTextCellDidEngEditing:self];
    }
    [self.hostView endEditing:YES];
}

#pragma mark - UITextFieldDelegte

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField {
    return self.enableEdit;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    self.text = textField.text;
    [textField endEditing:YES];
    if ([self.delegate respondsToSelector:@selector(settingsTextCellDidEngEditing:)]) {
        [self.delegate settingsTextCellDidEngEditing:self];
    }
}

- (UIView *)hitTest:(CGPoint)point withEvent:(UIEvent *)event {
    BOOL inside = [self.textField pointInside:point withEvent:event];
    if (inside) {
        return self.textField;
    }
    return [super hitTest:point withEvent:event];
}

@end
