//
//  RTCSettingsTextTableViewCell.h
//  rtc_sdk_ios
//
//  Created by 曹士谦 on 2022/3/1.
//  Copyright © 2022 Sun,Jian(ACU-T102). All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

static NSString *RTCSettingsTextTableViewCellIdentifier = @"RTCSettingsTextCellIdentifier";

@class RTCSettingsTextTableViewCell;

@protocol RTCSettingsTextTableViewCellDelegate <NSObject>

- (void)settingsTextCellDidEngEditing:(RTCSettingsTextTableViewCell *)cell;

@end

@interface RTCSettingsTextTableViewCell : UITableViewCell

@property (nonatomic, weak) id<RTCSettingsTextTableViewCellDelegate> delegate;

@property (nonatomic, strong, readonly) UITextField *textField;
@property (nonatomic, assign) int section;
@property (nonatomic, assign) BOOL enableEdit;
@property (nonatomic, copy) NSString *placeholder;
@property (nonatomic, copy) NSString *text;
@property (nonatomic, assign) UIKeyboardType keyboardType;

- (instancetype)initWithHostView:(UIView *)hostView;

@end

NS_ASSUME_NONNULL_END
