//
//  RTCSettingsSignalController.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCSettingsSignalController.h"
#import "RTCSettingsTextTableViewCell.h"
#import "BaiduRtcRoom/BaiduRtcRoom.h"
#import "RTCSettingsModel.h"

NS_ASSUME_NONNULL_BEGIN

static NSArray<NSString *> *signalModeSaticValues() {
    return @[@"TCP", @"QUIC", @"UDP"];
}

typedef NS_ENUM(int, RTCSettingsSections) {
    RTCSettingsSectionEncryptMode = 0,
    RTCSettingsSectionsServerHost,
    RTCSettingsSectionSubscribeCount,
    RTCSettingsSectionsServerSet,
    __RTCSettingsSectionsEnd
};

typedef NS_ENUM(int, RTCSignalSectionOptions) {
    RTCSignalSectionEncrypt = 0,
    RTCSignalSectionSignalMode,
    RTCSignalSectionSubscribeMode,
};

typedef NS_ENUM(int, RTCServerSettingsOptions) {
    RTCServerSettingsAppId = 0,
    RTCServerSettingsToken,
    RTCServerSettingsUserId,
    RTCServerSettingsServerIp,
};

@interface RTCSettingsSignalController () {
    UITextField *_serverAPPID;
    UITextField *_serverToken;
    UITextField *_serverUerId;
    UITextField *_serverAPPIDInfo;
    UITextField *_serverTokenInfo;
    UITextField *_serverUerIdInfo;
    UITextField *_serverMediaIp;
    UITextField *_serverMediaIpInfo;
}
@property (nonatomic, strong) RTCSettingsModel *settingsModel;

@end

@implementation RTCSettingsSignalController

- (instancetype)initWithStyle:(UITableViewStyle)style
                settingsModel:(RTCSettingsModel *)settingsModel {
    self = [super initWithStyle:style];
    if (self) {
        self.settingsModel = settingsModel;
    }
    return self;
}

- (void)dealloc {
    [_settingsModel sync];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return __RTCSettingsSectionsEnd;
}

- (NSArray<NSString *> *)subscribeModeArray {
    return [_settingsModel availableSubscribeMode];
}

- (NSArray<NSString *> *)encryptModeArray {
    return [_settingsModel availableEncryptMode];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    switch (section) {
        case RTCSettingsSectionsServerSet:
            return 4;
        case RTCSettingsSectionEncryptMode:
            return 3;
        default:
            return 1;
    }
}

- (nullable NSString *)tableView:(UITableView *)tableView
         titleForHeaderInSection:(NSInteger)section {
    switch (section) {
        case RTCSettingsSectionsServerHost:
            return @"信令地址";
        case RTCSettingsSectionsServerSet:
            return @"服务设置";
        case RTCSettingsSectionEncryptMode:
            return @"密钥交换方式";
        case RTCSettingsSectionSubscribeCount:
            return @"v4 订阅数量";
        default:
            return @"";
    }
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    switch (indexPath.section) {
        case RTCSettingsSectionsServerHost:
            return [self serverHostTableViewCellForTableView:tableView atIndexPath:indexPath forSection:RTCSettingsSectionsServerHost];
        case RTCSettingsSectionsServerSet:
            return [self serverSettingsTableViewCellForTableView:tableView atIndexPath:indexPath];
        case RTCSettingsSectionEncryptMode:
            return [self encryptModeTableViewCellForTableView:tableView atIndexPath:indexPath];
        case RTCSettingsSectionSubscribeCount:
            return [self subscribeCountTableViewCellForTableView:tableView atIndexPath:indexPath forSection:RTCSettingsSectionSubscribeCount];
        default:
            return [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                          reuseIdentifier:@"identifier"];
    }
}

- (void)settingsTextCellDidEngEditing:(RTCSettingsTextTableViewCell *)cell {
    switch ((RTCSettingsSections)cell.section) {
        case RTCSettingsSectionsServerHost:
            [_settingsModel storeServerHostSetting:cell.text.length == 0 ? @"" : cell.text];
            break;
        case RTCSettingsSectionSubscribeCount: {
            if (cell.text.length == 0) {
                return;
            }
            NSNumber *val = [NSNumber numberWithInteger:cell.text.integerValue];
            [_settingsModel storeSubscribeCountSetting:val];
            break;
        }
        default:
            break;
    }
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    switch (indexPath.section) {
        case RTCSettingsSectionsServerHost:
        case RTCSettingsSectionSubscribeCount:
        case RTCSettingsSectionsServerSet:
            [self tableView:tableView defSelectRowAtIndexPath:indexPath];
            break;
        case RTCSettingsSectionEncryptMode:
            [self tableView:tableView didSelectEncryptModeCellAtIndexPath:indexPath];
            [self.tableView reloadData];
            break;
    }
}

- (UITableViewCell *)encryptModeTableViewCellForTableView:(UITableView *)tableView
                                                atIndexPath:(NSIndexPath *)indexPath {
    NSString *title = nil, *key = nil;
    switch (indexPath.row) {
        case RTCSignalSectionEncrypt:
            title = @"密钥类型";
            key = [_settingsModel currentEncryptModeSettingFromStore];
            break;
        case RTCSignalSectionSignalMode: {
            title = @"信令协议";
            int index = (int)[_settingsModel currentSignalModeFromStore].integerValue;
            key = signalModeSaticValues()[index];
            break;
        }
        case RTCSignalSectionSubscribeMode: {
            title = @"v4订阅模式";
            key = [_settingsModel currentSubscribeModeSettingFromStore];
            break;
        }
    }
    return [self tableCellForTableView:tableView
                            identifier:@"RTCSettingsSubscribeModeCellIdentifier"
                                 title:title
                                   key:key
                           atIndexPath:indexPath];
}

- (void)tableView:(UITableView *)tableView
        didSelectEncryptModeCellAtIndexPath:(NSIndexPath *)indexPath {
    NSArray<NSString *> *arraySelect = nil;
    switch (indexPath.row) {
        case RTCSignalSectionEncrypt:
            arraySelect = self.encryptModeArray;
            break;
        case RTCSignalSectionSignalMode:
            arraySelect = signalModeSaticValues();
            break;
        case RTCSignalSectionSubscribeMode:
            arraySelect = self.subscribeModeArray;
            break;
    }
    [self tableView:tableView arraySelect:arraySelect success:^(int index) {
        switch (indexPath.row) {
            case RTCSignalSectionEncrypt: {
                NSString *encryptMode = self.encryptModeArray[index];
                [self.settingsModel storeEncryptModeSetting:encryptMode];
                break;
            }
            case RTCSignalSectionSignalMode:
                [self.settingsModel storeSignalModeSetting:@(index)];
                break;
            case RTCSignalSectionSubscribeMode: {
                NSString *subscribeMode = self.subscribeModeArray[index];
                [self.settingsModel storeSubscribeModeSetting:subscribeMode];
                break;
            }
        }
    }];
}

- (UITableViewCell *)subscribeCountTableViewCellForTableView:(UITableView *)tableView atIndexPath:(NSIndexPath *)indexPath forSection:(RTCSettingsSections)section {
    SEL sel = @selector(currentSubscribeCountSettingFromStore);
    UITableViewCell *cell = [self baseTextTableViewCellForTableView:tableView section:section valueSEL:sel placeHolder:@"输入订阅数量" isNumber:YES settingsModel:_settingsModel];
    return cell;
}

- (UITableViewCell *)serverHostTableViewCellForTableView:(UITableView *)tableView atIndexPath:(NSIndexPath *)indexPath forSection:(RTCSettingsSections)section {
    SEL sel = @selector(currentServerHostSettingFromStore);
    UITableViewCell *cell = [self baseTextTableViewCellForTableView:tableView section:section valueSEL:sel placeHolder:@"输入信令服务器地址" isNumber:NO settingsModel:_settingsModel];
    return cell;
}

- (UITableViewCell *)serverSettingsTableViewCellForTableView:(UITableView *)tableView
                                        atIndexPath:(NSIndexPath *)indexPath {
    NSString *dequeueIdentifier = @"RTCSettingsServerViewCellIdentifier";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:dequeueIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                reuseIdentifier:dequeueIdentifier];
        NSString *pholder;
        NSString *textValue = @"default";
        switch (indexPath.row) {
            case RTCServerSettingsAppId:
                pholder = @"AppID:";
                textValue = [_settingsModel currentServerAppIdSettingFromStore];
                _serverAPPIDInfo = [self generateTextField:CGRectMake(10, 4, cell.bounds.size.width - 20, cell.bounds.size.height*7/24)
                                               placeholder:pholder text:pholder];
                _serverAPPID = [self generateTextField:CGRectMake(10, cell.bounds.size.height/3, cell.bounds.size.width - 20, cell.bounds.size.height*3/4)
                                           placeholder:textValue.length > 0 ? textValue :@"default appid" text:textValue];
//                NSString *rtmpUrl = [_settingsModel currentLiveUrlSettingFromStore];
                [cell addSubview:_serverAPPIDInfo];
                [cell addSubview:_serverAPPID];
                break;
            case RTCServerSettingsToken:
                pholder = @"Token:";
                textValue = [_settingsModel currentServerTokenSettingFromStore];
                _serverTokenInfo = [self generateTextField:CGRectMake(10, 4, cell.bounds.size.width - 20, cell.bounds.size.height*7/24)
                                               placeholder:pholder text:pholder];
                _serverToken = [self generateTextField:CGRectMake(10, cell.bounds.size.height/3, cell.bounds.size.width - 20, cell.bounds.size.height*3/4)
                                           placeholder:textValue.length > 0 ? textValue : @"default token" text:textValue];
//                NSString *rtmpUrl = [_settingsModel currentLiveUrlSettingFromStore];
                [cell addSubview:_serverTokenInfo];
                [cell addSubview:_serverToken];
                break;
            case RTCServerSettingsUserId:
                pholder = @"userID:";
                textValue = [_settingsModel currentServerUserIdSettingFromStore];
                _serverUerIdInfo = [self generateTextField:CGRectMake(10, 4, cell.bounds.size.width - 20, cell.bounds.size.height*7/24)
                                               placeholder:pholder text:pholder];
                _serverUerId = [self generateTextField:CGRectMake(10, cell.bounds.size.height/3, cell.bounds.size.width - 20, cell.bounds.size.height*3/4)
                                           placeholder:textValue.length > 0 ? textValue :@"default userId" text:textValue];
                [cell addSubview:_serverUerIdInfo];
                [cell addSubview:_serverUerId];
                break;
            case RTCServerSettingsServerIp:
                pholder = @"Media Server IP";
                textValue = [_settingsModel currentMediaServerIpSettingFromStore];
                _serverMediaIpInfo = [self generateTextField:CGRectMake(10, 4, cell.bounds.size.width - 20, cell.bounds.size.height*7/24)
                                               placeholder:pholder text:pholder];
                _serverMediaIp = [self generateTextField:CGRectMake(10, cell.bounds.size.height/3, cell.bounds.size.width - 20, cell.bounds.size.height*3/4)
                                           placeholder:textValue.length > 0 ? textValue :@"default Media Server IP" text:textValue];
                [cell addSubview:_serverMediaIpInfo];
                [cell addSubview:_serverMediaIp];
                break;
            default:
                break;
        }
    }
    return cell;
 }

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField {
    if (textField == _serverTokenInfo ||
        textField == _serverAPPIDInfo ||
        textField == _serverUerIdInfo ||
        textField == _serverMediaIpInfo) {
        return  NO;
    }
    return YES;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    if (![[_settingsModel currentServerAppIdSettingFromStore] isEqual:_serverAPPID.text]) {
        [_settingsModel storeServerAppIdSetting:_serverAPPID.text];
    }
    if (![[_settingsModel currentServerTokenSettingFromStore] isEqual:_serverToken.text]) {
        [_settingsModel storeServerTokenSetting:_serverToken.text];
    }
    if (![[_settingsModel currentServerUserIdSettingFromStore] isEqual:_serverUerId.text]) {
        [_settingsModel storeServerUserIdSetting:_serverUerId.text];
    }
    if (![[_settingsModel currentMediaServerIpSettingFromStore] isEqual:_serverMediaIp.text]) {
        [_settingsModel storeMediaServerIpSetting:_serverMediaIp.text];
    }
}

#pragma mark - View lifecycle
- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"信令设置";
    [self addDoneBarButton];
}

@end
NS_ASSUME_NONNULL_END
