//
//  RTCSettingsScreenController.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCSettingsScreenController.h"
#import "RTCSettingsTextTableViewCell.h"
#import "BaiduRtcRoom/BaiduRtcRoom.h"
#import "RTCSettingsModel.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(int, RTCReslutionBitrate) {
    RTCBitrate_3840x2160 = 10000,
    RTCBitrate_2160x1440 = 5000,
    RTCBitrate_1920x1080 = 2500,
    RTCBitrate_1280x720  = 1500,
    RTCBitrate_640x480   =  600,
    RTCBitrate_480x360   =  500,
    RTCBitrate_352x288   =  400,
    RTCBitrate_176x144   =  256,
    RTCBitrateDefault    =  600,
};

static NSArray<NSNumber *> *videoResolutionBitrates() {
    return @[
        @(RTCBitrate_3840x2160 ),
        @(RTCBitrate_2160x1440 ),
        @(RTCBitrate_1920x1080 ),
        @(RTCBitrate_1280x720  ),
        @(RTCBitrate_640x480   ),
        @(RTCBitrate_480x360   ),
        @(RTCBitrate_352x288   ),
        @(RTCBitrate_176x144   ),
        @(RTCBitrateDefault    ),
    ];
}

typedef void (^BSPopupSelectBlock)(int index);

typedef NS_ENUM(int, RTCSettingsSections) {
    RTCSettingsSectionsShareScreenFps,
    RTCSettingsSectionsShareScreenResolution,
    RTCSettingsSectionsShareScreenMinBitrate,
    RTCSettingsSectionsShareScreenMaxBitrate,

    __RTCSettingsSectionsEnd
};

@interface RTCSettingsScreenController () {
}
@property (nonatomic, strong) RTCSettingsModel *settingsModel;

@end

@implementation RTCSettingsScreenController

- (instancetype)initWithStyle:(UITableViewStyle)style
                settingsModel:(RTCSettingsModel *)settingsModel {
    self = [super initWithStyle:style];
    if (self) {
        self.settingsModel = settingsModel;
    }
    return self;
}

- (void)dealloc {
    [_settingsModel sync];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return __RTCSettingsSectionsEnd;
}

- (NSArray<NSString *> *)videoEncoderResolutionArray {
    return [_settingsModel outputVideoEncoderResultions];
}

- (NSInteger)resolutionTobitrate:(NSString*)resolution {
    RTCReslutionBitrate result = RTCBitrateDefault;
    NSUInteger idx = [self.videoEncoderResolutionArray indexOfObject:resolution];
    if (idx != NSNotFound) {
        NSArray *bitrates = videoResolutionBitrates();
        if (bitrates.count > idx) {
            return [bitrates[idx] integerValue];
        }
    }
    return  result;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    switch (section) {
        case RTCSettingsSectionsShareScreenFps:
            return 1;
        case RTCSettingsSectionsShareScreenResolution:
            return 1;
        case RTCSettingsSectionsShareScreenMaxBitrate:
            return 1;
        case RTCSettingsSectionsShareScreenMinBitrate:
            return 1;
        default:
            return 1;
    }
}

- (nullable NSString *)tableView:(UITableView *)tableView
         titleForHeaderInSection:(NSInteger)section {
    switch (section) {
        case RTCSettingsSectionsShareScreenFps:
            return @"屏幕分享帧率";
        case RTCSettingsSectionsShareScreenResolution:
            return @"屏幕分享分辨率";
        case RTCSettingsSectionsShareScreenMinBitrate:
            return @"屏幕分享最小码率(kbps)";
        case RTCSettingsSectionsShareScreenMaxBitrate:
            return @"屏幕分享最大码率(kbps)";
        default:
            return @"";
    }
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    switch (indexPath.section) {
        case RTCSettingsSectionsShareScreenResolution:
            return [self screenSharevideoResolutionTableViewCellForTableView:tableView atIndexPath:indexPath];
            
        case RTCSettingsSectionsShareScreenFps:
            return [self fpsTableViewCellForTableView:tableView atIndexPath:indexPath forSetion:RTCSettingsSectionsShareScreenFps];

        case RTCSettingsSectionsShareScreenMinBitrate:
            return [self bitrateTableViewCellForTableView:tableView atIndexPath:indexPath forSection:RTCSettingsSectionsShareScreenMinBitrate];

        case RTCSettingsSectionsShareScreenMaxBitrate:
            return [self bitrateTableViewCellForTableView:tableView atIndexPath:indexPath forSection:RTCSettingsSectionsShareScreenMaxBitrate];
        default:
            return [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                          reuseIdentifier:@"identifier"];
    }
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    switch (indexPath.section) {
        case RTCSettingsSectionsShareScreenResolution:
            [self tableView:tableView didSelectScreenShareVideoResolutionAtIndex:indexPath];
            [self.tableView reloadData];
            break;
        case RTCSettingsSectionsShareScreenMinBitrate:
        case RTCSettingsSectionsShareScreenMaxBitrate:
        case RTCSettingsSectionsShareScreenFps:
            [self tableView:tableView defSelectRowAtIndexPath:indexPath];
            break;
    }
}

- (void)tableView:(UITableView *)tableView didSelectScreenShareVideoResolutionAtIndex:(NSIndexPath *)indexPath {
    [self tableView:tableView arraySelect:[self videoEncoderResolutionArray] success:^(int index) {
        NSString *videoResolution = self.videoEncoderResolutionArray[index];
        NSInteger maxBitrate = [self resolutionTobitrate:videoResolution];
        
        [self.settingsModel storeScreenShareMaxBitrateSetting:[NSNumber numberWithInteger:maxBitrate]];
        [self.settingsModel storeScreenShareVideoResolutionSetting:videoResolution];
    }];
}

- (UITableViewCell *)screenSharevideoResolutionTableViewCellForTableView:(UITableView *)tableView atIndexPath:(NSIndexPath *)indexPath {
    return [self tableCellForTableView:tableView
                            identifier:@"RTCSettingsVideoResolutionViewCellIdentifier"
                                 title:@"分辨率"
                                   key:[_settingsModel currentScreenShareVideoResolutionSettingFromStore]
                           atIndexPath:indexPath];
}

- (UITableViewCell *)bitrateTableViewCellForTableView:(UITableView *)tableView atIndexPath:(NSIndexPath *)indexPath forSection:(RTCSettingsSections)section {
    if (section == RTCSettingsSectionsShareScreenMaxBitrate) {
        SEL sel = @selector(currentScreenShareMaxBitrateSettingFromStore);
        UITableViewCell *cell = [self baseTextTableViewCellForTableView:tableView section:section valueSEL:sel placeHolder:@"输入最大的码率(kbps)" isNumber:YES settingsModel:_settingsModel];
        return cell;
    }
    if (section == RTCSettingsSectionsShareScreenMinBitrate) {
        SEL sel = @selector(currentScreenShareMinBitrateSettingFromStore);
        UITableViewCell *cell = [self baseTextTableViewCellForTableView:tableView section:section valueSEL:sel placeHolder:@"输入最小的码率(kbps)" isNumber:YES settingsModel:_settingsModel];
        return cell;
    }
    return nil;
}

- (void)settingsTextCellDidEngEditing:(RTCSettingsTextTableViewCell *)cell {
    if (cell.text.length == 0) return;

    NSNumber *val = [NSNumber numberWithInteger:cell.text.integerValue];
    switch ((RTCSettingsSections)cell.section) {
        case RTCSettingsSectionsShareScreenFps:
            [_settingsModel storeScreenShareVideoFpsSetting:val];
            break;
        case RTCSettingsSectionsShareScreenMaxBitrate:
            [_settingsModel storeScreenShareMaxBitrateSetting:val];
            break;
        case RTCSettingsSectionsShareScreenMinBitrate:
            [_settingsModel storeScreenShareMinBitrateSetting:val];
            break;
        default:
            break;
    }
}

- (UITableViewCell *)fpsTableViewCellForTableView:(UITableView *)tableView atIndexPath:(NSIndexPath *)indexPath forSetion:(RTCSettingsSections)section {
    SEL sel = @selector(currentScreenShareVideoFpsSettingFromStore);
    UITableViewCell *cell = [self baseTextTableViewCellForTableView:tableView section:section valueSEL:sel placeHolder:@"请输入视频帧率(fps)" isNumber:YES settingsModel:_settingsModel];
    return cell;
}

#pragma mark - View lifecycle
- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"屏幕共享";
    [self addDoneBarButton];
}

@end
NS_ASSUME_NONNULL_END

