//
//  RTCSettingsParametersController.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCSettingsParametersController.h"
#import "RTCSettingsTextTableViewCell.h"
#import "BaiduRtcRoom/BaiduRtcRoom.h"
#import "RTCSettingsModel.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(int, RtcModeTransferSetOptions) {
    RtcLiveModeOptionsMeeting = 0,
    RtcLiveModeOptions1v1,
    RtcLiveModeOptionsManulPublish,
    RtcLiveModeOptiossManulSubscribe,
    RtcModeOptionAutoSubscribeAudio,
    RtcModeOptionAutoSubscribeVideo,
    RtcModeVideoPullDemote,
    RtcH263ReportWatchSli,
    RtcLiveModeCaptureExtral,
    RtcMessageModeSelceted,
    RtcIsCompulsiveMode,
    RtcAutoReconnect,
    RtcMaxModeCount
};

@interface RTCSettingsParametersController () {
    RTCSettingsModel *_settingsModel;
}
@end

@implementation RTCSettingsParametersController

- (instancetype)initWithStyle:(UITableViewStyle)style
                settingsModel:(RTCSettingsModel *)settingsModel {
    self = [super initWithStyle:style];
    if (self) {
        _settingsModel = settingsModel;
    }
    return self;
}

- (void)dealloc {
    [_settingsModel sync];
}

- (nullable NSString *)tableView:(UITableView *)tableView
         titleForHeaderInSection:(NSInteger)section {
    return @"模式设置";
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return RtcMaxModeCount;
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    return [self remoteScribeTableViewCellForTableView:tableView atIndexPath:indexPath];
}

- (UITableViewCell *)remoteScribeTableViewCellForTableView:(UITableView *)tableView
                                               atIndexPath:(NSIndexPath *)indexPath {
    NSString *dequeueIdentifier = @"RTCSettingsRemoteSubscribeCellIdentifier";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:dequeueIdentifier];
                                                   
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                    reuseIdentifier:dequeueIdentifier];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        UISwitch *switchView = [[UISwitch alloc] initWithFrame:CGRectZero];
        switchView.tag = indexPath.row;
        [switchView addTarget:self
                    action:@selector(remoteSubscribeSwitchChanged:)
            forControlEvents:UIControlEventValueChanged];
        cell.accessoryView = switchView;
    }
    cell.textLabel.text = [self labelForremoteScribeTableViewAtIndexPathRow:indexPath.row];
    UISwitch *switchView = (UISwitch *)cell.accessoryView;
    switchView.on = [self valueModeOfMeetingPathRow:indexPath.row];
    return cell;
}

- (bool)valueModeOfMeetingPathRow:(NSInteger)setting {
    bool  isOpen = false;
    switch (setting) {
        case RtcLiveModeOptionsMeeting:
            isOpen = [_settingsModel currentRemoteSubscribeSettingFromStore];
            break;
        case RtcLiveModeOptions1v1:
            isOpen = [_settingsModel currentCallMode1v1SettingFromStore];
            break;
        case RtcLiveModeOptionsManulPublish:
            isOpen = [_settingsModel currentIsAutoPublishSettingFromStore];
            break;
        case RtcLiveModeOptiossManulSubscribe:
            isOpen = [_settingsModel currentIsAutoSubscribeSettingFromStore];
            break;
        case RtcModeOptionAutoSubscribeAudio:
            isOpen = [_settingsModel currentHasRemoteAudioSettingFromStore];
            break;
        case RtcModeOptionAutoSubscribeVideo:
            isOpen = [_settingsModel currentHasRemoteVideoSettingFromStore];
            break;
        case RtcModeVideoPullDemote:
            isOpen = [_settingsModel currentIsVideoPullDemoteFromStore];
            break;
        case RtcH263ReportWatchSli:
            isOpen = [_settingsModel currentIsReportWatchSliFromStore];
            break;
        case RtcMessageModeSelceted:
            isOpen = [_settingsModel currentIsMessageModeChannelDataFromStore];
            break;
        case RtcLiveModeCaptureExtral:
            isOpen = [_settingsModel currentCaptureExternalModeSettingFromStore];
            break;
        case RtcIsCompulsiveMode:
            isOpen = [_settingsModel currentCompulsiveModeSettingFromStore];
            break;
        case RtcAutoReconnect:
            isOpen = [_settingsModel currentAutoReconnectFromStore];
            break;
        default:
            isOpen = false;
    }
    return isOpen;
}

- (NSString*)labelForremoteScribeTableViewAtIndexPathRow:(NSInteger)setting {
    switch (setting) {
        case RtcLiveModeOptionsMeeting:
            return @"拉流会议模式";
        case RtcLiveModeOptions1v1:
            return @"1v1通话模式";
        case RtcLiveModeOptionsManulPublish:
            return @"自动推流模式";
        case RtcLiveModeOptiossManulSubscribe:
            return @"自动拉流模式";
        case RtcModeOptionAutoSubscribeAudio: return @"订阅远端音频";
        case RtcModeOptionAutoSubscribeVideo: return @"订阅远端视频";
        case RtcModeVideoPullDemote:
            return @"远端视频升降级";
        case RtcH263ReportWatchSli:
            return @"H263上报手表信息";
        case RtcLiveModeCaptureExtral:
            return @"视频外部采集模式";
        case RtcMessageModeSelceted:
            return @"发送消息DataChannel";
        case RtcIsCompulsiveMode:
            return @"强制登录模式";
        case RtcAutoReconnect:
            return @"自动重连接";
        default:
            return @"";
    }
}

- (void)remoteSubscribeSwitchChanged:(UISwitch *) sender {
    switch (sender.tag) {
        case RtcLiveModeOptionsMeeting: {
            [_settingsModel storeRemoteSubscribeSetting:sender.isOn];
            break;
        case RtcLiveModeOptions1v1:
            [_settingsModel storeCallMode1v1Setting:sender.isOn];
            break;
        case RtcLiveModeOptionsManulPublish:
            [_settingsModel storeIsAutoPublishSetting:sender.isOn];
            break;
        case RtcLiveModeOptiossManulSubscribe:
            [_settingsModel storeIsAutoSubscribeSetting:sender.isOn];
            break;
        case RtcModeOptionAutoSubscribeAudio:
            [_settingsModel storeHasRemoteAudioSetting:sender.isOn];
            break;
        case RtcModeOptionAutoSubscribeVideo:
            [_settingsModel storeHasRemoteVideoSetting:sender.isOn];
            break;
        case RtcModeVideoPullDemote:
            [_settingsModel storeIsVideoPullDemoteSetting:sender.isOn];
            break;
        case RtcH263ReportWatchSli:
            [_settingsModel storeIsReportWatchSliSetting:sender.isOn];
            break;
        case RtcMessageModeSelceted:
            [_settingsModel storeIsMessageModeChannelDataSetting:sender.isOn];
            break;
        case RtcLiveModeCaptureExtral:
            [_settingsModel storeCaptureExternalModeSetting:sender.isOn];
            break;
        case RtcIsCompulsiveMode:
            [_settingsModel storeCompulsiveModeSetting:sender.isOn];
        case RtcAutoReconnect:
            [_settingsModel storeAutoReconnectSetting:sender.isOn];
            break;
        }
    }
}

#pragma mark - View lifecycle
- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"参数设置";
    [self addDoneBarButton];
}

@end
NS_ASSUME_NONNULL_END

