//
//  RTCSettingsLiveController.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCSettingsLiveController.h"
#import "RTCSettingsTextTableViewCell.h"
#import "BaiduRtcRoom/BaiduRtcRoom.h"
#import "RTCSettingsModel.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(int, RTCSettingsSections) {
    RTCSettingsSectionsLiveUrl = 0,
    RTCSettingsSectionsLiveMix,
    RTCSettingsSectionsLiveRecord,
    RTCSettingsSectionsLiveTransferMode,
    RTCSettingsSectionsLiveMixTemplate,
    __RTCSettingsSectionsEnd
};

typedef NS_ENUM(int, RTCLiveMixSettingsOptions) {
    RTCLiveSettingsOptionsIsMix = 0,
};

typedef NS_ENUM(int, RTCLiveRecordSettingsOptions) {
    RTCLiveRecordSettingsOptionsIsRecord = 0,
};

typedef NS_ENUM(int, RtcLiveTransferModeOptions) {
    RtcLiveTransferModeOptionsAnchor = 0,
    RtcLiveTransferModeOptionsRoom,
};

@interface RTCSettingsLiveController () {
    RTCSettingsModel *_settingsModel;
}
@end

@implementation RTCSettingsLiveController

- (instancetype)initWithStyle:(UITableViewStyle)style
                settingsModel:(RTCSettingsModel *)settingsModel {
    self = [super initWithStyle:style];
    if (self) {
        _settingsModel = settingsModel;
    }
    return self;
}

- (void)dealloc {
    [_settingsModel sync];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return __RTCSettingsSectionsEnd;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    switch (section) {
        case RTCSettingsSectionsLiveUrl:
            return 1;
        case RTCSettingsSectionsLiveMix:
            return 1;
        case RTCSettingsSectionsLiveRecord:
            return 1;
        case RTCSettingsSectionsLiveTransferMode:
            return 2;
        case RTCSettingsSectionsLiveMixTemplate:
            return 1;
        default:
            return 1;
    }
}

- (nullable NSString *)tableView:(UITableView *)tableView
         titleForHeaderInSection:(NSInteger)section {
    switch (section) {
        case RTCSettingsSectionsLiveUrl:
            return @"直播地址";
        case RTCSettingsSectionsLiveMix:
            return @"直播混流";
        case RTCSettingsSectionsLiveRecord:
            return @"直播录制";
        case RTCSettingsSectionsLiveTransferMode:
            return @"转推模式";
        case RTCSettingsSectionsLiveMixTemplate:
            return @"混流模版";
        default:
            return @"";
    }
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    switch (indexPath.section) {
        case RTCSettingsSectionsLiveUrl:
            return [self liveUrlTableViewCellForTableView:tableView atIndexPath:indexPath];

        case RTCSettingsSectionsLiveMix:
            return [self liveMixSettingsTableViewCellForTableView:tableView atIndexPath:indexPath];

        case RTCSettingsSectionsLiveRecord:
            return [self liveRecordSettingsTableViewCellForTableView:tableView atIndexPath:indexPath];

        case RTCSettingsSectionsLiveTransferMode:
            return [self liveTransferTableViewCellForTableView:tableView atIndexPath:indexPath];

        case RTCSettingsSectionsLiveMixTemplate:
            return [self liveMixTemplateTableViewCellForTableView:tableView atIndexPath:indexPath];
        default:
            return [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                          reuseIdentifier:@"identifier"];
    }
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
   switch (indexPath.section) {
       case RTCSettingsSectionsLiveTransferMode:
            [self tableView:tableView didSelectLiveTransferModeAtIndex:indexPath];
            break;
        case RTCSettingsSectionsLiveUrl:
        case RTCSettingsSectionsLiveMixTemplate:
            [self tableView:tableView defSelectRowAtIndexPath:indexPath];
            break;
   }
}


#pragma mark - Table view delegate(Live url settings)
- (UITableViewCell *)liveUrlTableViewCellForTableView:(UITableView *)tableView
                                      atIndexPath:(NSIndexPath *)indexPath {
    
    SEL sel = @selector(currentLiveUrlSettingFromStore);
    NSString *placeHolder = @"请输入直播转推地址(rtmp://xxxx)";
    RTCSettingsSections section = RTCSettingsSectionsLiveUrl;
    UITableViewCell *cell = [self baseTextTableViewCellForTableView:tableView section:section valueSEL:sel placeHolder:placeHolder isNumber:NO settingsModel:_settingsModel];
    return cell;
}

- (void)liveUrlNumberTextFieldDidEndEditing:(id)sender {
    [self.view endEditing:YES];
}

#pragma mark - Table view delegate(Live mix settings)
- (UITableViewCell *)liveMixSettingsTableViewCellForTableView:(UITableView *)tableView
                                                atIndexPath:(NSIndexPath *)indexPath {
    NSString *dequeueIdentifier = @"RTCSettingsLiveMixSettingsCellIdentifier";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:dequeueIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                      reuseIdentifier:dequeueIdentifier];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        UISwitch *switchView = [[UISwitch alloc] initWithFrame:CGRectZero];
        switchView.tag = indexPath.row;
        [switchView addTarget:self
                       action:@selector(liveMixSettingSwitchChanged:)
             forControlEvents:UIControlEventValueChanged];
        cell.accessoryView = switchView;
    }
    
    cell.textLabel.text = [self labelForLiveMixSettingAtIndexPathRow:indexPath.row];
    UISwitch *switchView = (UISwitch *)cell.accessoryView;
    switchView.on = [self valueForLiveMixSettingAtIndexPathRow:indexPath.row];
    return cell;
}

- (NSString *)labelForLiveMixSettingAtIndexPathRow:(NSInteger)setting {
    switch (setting) {
        case RTCLiveSettingsOptionsIsMix:
            return @"是否开启混流";
        default:
            return @"";
    }
}

- (BOOL)valueForLiveMixSettingAtIndexPathRow:(NSInteger)setting {
    switch (setting) {
        case RTCLiveSettingsOptionsIsMix:
            return [_settingsModel currentLiveMixSettingFromStore];
        default:
            return NO;
    }
}

- (void)liveMixSettingSwitchChanged:(UISwitch *)sender {
    switch (sender.tag) {
        case RTCLiveSettingsOptionsIsMix: {
            [_settingsModel storeLiveMixSetting:sender.isOn];
            break;
        }
        default:
            break;
    }
}

#pragma mark - Table view delegate(Live record settings)
- (UITableViewCell *)liveRecordSettingsTableViewCellForTableView:(UITableView *)tableView
                                                  atIndexPath:(NSIndexPath *)indexPath {
    NSString *dequeueIdentifier = @"RTCSettingsLiveRecordSettingsCellIdentifier";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:dequeueIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                      reuseIdentifier:dequeueIdentifier];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        UISwitch *switchView = [[UISwitch alloc] initWithFrame:CGRectZero];
        switchView.tag = indexPath.row;
        [switchView addTarget:self
                       action:@selector(liveRecordSettingSwitchChanged:)
             forControlEvents:UIControlEventValueChanged];
        cell.accessoryView = switchView;
    }
    
    cell.textLabel.text = [self labelForLiveRecordSettingAtIndexPathRow:indexPath.row];
    UISwitch *switchView = (UISwitch *)cell.accessoryView;
    switchView.on = [self valueForLiveRecordSettingAtIndexPathRow:indexPath.row];
    return cell;
}

- (NSString *)labelForLiveRecordSettingAtIndexPathRow:(NSInteger)setting {
    switch (setting) {
        case RTCLiveRecordSettingsOptionsIsRecord:
            return @"是否开启录制";
        default:
            return @"";
    }
}

- (BOOL)valueForLiveRecordSettingAtIndexPathRow:(NSInteger)setting {
    switch (setting) {
        case RTCLiveRecordSettingsOptionsIsRecord:
            return [_settingsModel currentLiveRecordSettingFromStore];
        default:
            return NO;
    }
}

- (void)liveRecordSettingSwitchChanged:(UISwitch *)sender {
    switch (sender.tag) {
        case RTCLiveRecordSettingsOptionsIsRecord: {
            [_settingsModel storeLiveRecordSetting:sender.isOn];
            break;
        }
        default:
            break;
    }
}

#pragma mark - Table view delegate(Live transfer mode)
- (UITableViewCell *)liveTransferTableViewCellForTableView:(UITableView *)tableView
                                                  atIndexPath:(NSIndexPath *)indexPath {
    NSString *dequeueIdentifier = @"RTCSettingsLiveTransferViewCellIdentifier";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:dequeueIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                      reuseIdentifier:dequeueIdentifier];
    }
    NSString* transferMode = [self labelForLiveTransferModeSettingAtIndexPathRow:indexPath.row];
    cell.textLabel.text = transferMode;
    if ([transferMode isEqualToString:[_settingsModel currentLiveTransferModSettingFromStore]]) {
        cell.accessoryType = UITableViewCellAccessoryCheckmark;
    } else {
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
    
    return cell;
}

- (NSString*)labelForLiveTransferModeSettingAtIndexPathRow:(NSInteger)setting {
    switch (setting) {
        case RtcLiveTransferModeOptionsAnchor:
            return @"主播转推";
        case RtcLiveTransferModeOptionsRoom:
            return @"房间转推";
        default:
            return @"";
    }
}

- (NSArray<NSString *> *)transferModeArray {
    NSArray *transferMode = @[
                             @"主播转推",
                             @"房间转推"
                             ];
    return transferMode;
}

- (void)tableView:(UITableView *)tableView
     didSelectLiveTransferModeAtIndex:(NSIndexPath *)indexPath {
    [self tableView:tableView
          updateListSelectionAtIndexPath:indexPath
          inSection:RTCSettingsSectionsLiveTransferMode];

    NSString *transferMode = self.transferModeArray[indexPath.row];
    [_settingsModel storeLiveTransferModeSetting:transferMode];
}

#pragma mark - Table view delegate(Live mix template settings)
- (UITableViewCell *)liveMixTemplateTableViewCellForTableView:(UITableView *)tableView
                                          atIndexPath:(NSIndexPath *)indexPath {
    
    SEL sel = @selector(currentLiveMixTemplateSettingFromStore);
    NSString *placeHolder = @"side_by_side_primary_720p_16_9";
    RTCSettingsSections section = RTCSettingsSectionsLiveMixTemplate;
    UITableViewCell *cell = [self baseTextTableViewCellForTableView:tableView section:section valueSEL:sel placeHolder:placeHolder isNumber:NO settingsModel:_settingsModel];
    return cell;
}

#pragma mark - RTCSettingsTextTableViewCellDelegate

- (void)settingsTextCellDidEngEditing:(RTCSettingsTextTableViewCell *)cell {
    if (cell.text.length == 0) return;

    switch ((RTCSettingsSections)cell.section) {
        case RTCSettingsSectionsLiveUrl:
        case RTCSettingsSectionsLiveMixTemplate:
            [_settingsModel storeLiveUrlSetting:cell.text];
            break;
        default:
            break;
    }
}

#pragma mark - Table view delegate helpers
- (void)removeAllAccessories:(UITableView *)tableView
                   inSection:(int)section {
    for (int i = 0; i < [tableView numberOfRowsInSection:section]; i++) {
        NSIndexPath *rowPath = [NSIndexPath indexPathForRow:i inSection:section];
        UITableViewCell *cell = [tableView cellForRowAtIndexPath:rowPath];
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
}

- (void)tableView:(UITableView *)tableView
        updateListSelectionAtIndexPath:(NSIndexPath *)indexPath
        inSection:(int)section {
    [self removeAllAccessories:tableView inSection:section];
    UITableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
    cell.accessoryType = UITableViewCellAccessoryCheckmark;
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
}

#pragma mark - View lifecycle
- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"直播转推";
    [self addDoneBarButton];
}

@end
NS_ASSUME_NONNULL_END

