//
//  RTCSettingsLastmileController.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCSettingsLastmileController.h"
#import "RTCSettingsTextTableViewCell.h"
#import "BaiduRtcRoom/BaiduRtcRoom.h"
#import "RTCSettingsModel.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(int, RTCSettingsSections) {
    RTCSettingsSectionLastmile = 0,
    __RTCSettingsSectionsEnd
};

typedef NS_ENUM(int, RTCLastmileSettingsOptions) {
    RTCLastmileSettingsServerUrl = 0,
    RTCLastmileSettingsUplink,
    RTCLastmileSettingsDownlink,
};

@interface RTCSettingsLastmileController () {
    RTCSettingsModel *_settingsModel;

    UITextField *_lastmileServerUrl;
    UITextField *_lastmileServerUrlInfo;
    UITextField *_lastmileUplinkKbps;
    UITextField *_lastmileUplinkKbpsInfo;
    UITextField *_lastmileDownlinkKbps;
    UITextField *_lastmileDownlinkKbpsInfo;
}
@end

@implementation RTCSettingsLastmileController

- (instancetype)initWithStyle:(UITableViewStyle)style
               settingsModel:(RTCSettingsModel *)settingsModel {
   self = [super initWithStyle:style];
   if (self) {
       _settingsModel = settingsModel;
   }
   return self;
}

- (void)dealloc {
    [_settingsModel sync];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    switch (section) {
        case RTCSettingsSectionLastmile:
            return 3;
        default:
            return 1;
    }
}

- (nullable NSString *)tableView:(UITableView *)tableView
         titleForHeaderInSection:(NSInteger)section {
    switch (section) {
        case RTCSettingsSectionLastmile:
            return @"网络测速";
        default:
            return @"";
    }
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    switch (indexPath.section) {
        case RTCSettingsSectionLastmile:
            return [self lastmileSettingsTableViewCellForTableView:tableView atIndexPath:indexPath];
        default:
            return [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                          reuseIdentifier:@"identifier"];
    }
}

- (UITableViewCell *)lastmileSettingsTableViewCellForTableView:(UITableView *)tableView
                                        atIndexPath:(NSIndexPath *)indexPath {
    NSString *dequeueIdentifier = @"RTCSettingsLastmileViewCellIdentifier";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:dequeueIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                    reuseIdentifier:dequeueIdentifier];
        NSString *pholder;
        NSString *textValue = @"default";
        switch (indexPath.row) {
            case RTCLastmileSettingsServerUrl:
                pholder = @"Lastmile Server Url:";
                textValue = [_settingsModel currentProbeServerUrlSettingFromStore];
                _lastmileServerUrlInfo = [self
                        generateTextField:CGRectMake(10, 4, cell.bounds.size.width - 20,
                                    cell.bounds.size.height * 7 / 24)
                              placeholder:pholder
                                     text:pholder];
                _lastmileServerUrl = [self
                        generateTextField:CGRectMake(10, cell.bounds.size.height / 3,
                                    cell.bounds.size.width - 20, cell.bounds.size.height * 3 / 4)
                              placeholder:textValue.length > 0 ? textValue : @"https://rtc-ss.su.baidubce.com"
                                     text:textValue];
                [cell addSubview:_lastmileServerUrlInfo];
                [cell addSubview:_lastmileServerUrl];
                break;
            case RTCLastmileSettingsUplink:
                pholder = @"Lastmile Uplink Kbps";
                textValue = [_settingsModel currentProbeUplinkKbpsSettingFromStore];
                _lastmileUplinkKbpsInfo = [self generateTextField:CGRectMake(10, 4, cell.bounds.size.width - 20, cell.bounds.size.height*7/24) placeholder:pholder text:pholder];
                _lastmileUplinkKbps = [self generateTextField:CGRectMake(10, cell.bounds.size.height/3, cell.bounds.size.width - 20, cell.bounds.size.height*3/4) placeholder:textValue.length>0 ? textValue : @"2000" text:textValue];
                [cell addSubview:_lastmileUplinkKbpsInfo];
                [cell addSubview:_lastmileUplinkKbps];
                break;
            case RTCLastmileSettingsDownlink:
                pholder = @"Lastmile Downlink Kbps:";
                textValue = [_settingsModel currentProbeDownlinkKbpsSettingFromStore];
                _lastmileDownlinkKbpsInfo = [self generateTextField:CGRectMake(10, 4, cell.bounds.size.width - 20, cell.bounds.size.height*7/24)
                                               placeholder:pholder text:pholder];
                _lastmileDownlinkKbps = [self generateTextField:CGRectMake(10, cell.bounds.size.height/3, cell.bounds.size.width - 20, cell.bounds.size.height*3/4)
                                           placeholder:textValue.length>0 ? textValue :@"3000" text:textValue];
                [cell addSubview:_lastmileDownlinkKbpsInfo];
                [cell addSubview:_lastmileDownlinkKbps];
                break;
            default:
                break;
        }
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    switch (indexPath.section) {
        case RTCSettingsSectionLastmile:
            [self tableView:tableView defSelectRowAtIndexPath:indexPath];
            break;
    }
}

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField {
    if (textField == _lastmileUplinkKbpsInfo ||
        textField == _lastmileDownlinkKbpsInfo ||
        textField == _lastmileServerUrlInfo) {
        return NO;
    }
    return YES;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    if (![[_settingsModel currentProbeServerUrlSettingFromStore] isEqual:_lastmileServerUrl.text]) {
        [_settingsModel storeProbeServerUrlSetting:_lastmileServerUrl.text];
    }

    if (![[_settingsModel currentProbeUplinkKbpsSettingFromStore] isEqual:_lastmileUplinkKbps.text]) {
        [_settingsModel storeProbeUplinkKbpsSetting:_lastmileUplinkKbps.text];
    }

    if (![[_settingsModel currentProbeDownlinkKbpsSettingFromStore] isEqual:_lastmileDownlinkKbps.text]) {
        [_settingsModel storeProbeDownlinkKbpsSetting:_lastmileDownlinkKbps.text];
    }
}

#pragma mark - View lifecycle
- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"网络测速";
    [self addDoneBarButton];
}

@end
NS_ASSUME_NONNULL_END
