//
//  RTCSettingsLastmileController.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef RTCSettingsLastmileController_h
#define RTCSettingsLastmileController_h
#import <UIKit/UIKit.h>
#import "RTCSettingsBaseController.h"

@class RTCSettingsModel;

NS_ASSUME_NONNULL_BEGIN
/**
 * Displays settings options.
 */
@interface RTCSettingsLastmileController : RTCSettingsBaseController

/**
 * Creates new instance.
 *
 * @param style the table view style that should be used
 * @param settingsModel model class for the user settings.
 */
- (instancetype)initWithStyle:(UITableViewStyle)style
                settingsModel:(RTCSettingsModel *)settingsModel;

#pragma mark - Unavailable

- (instancetype)initWithStyle:(UITableViewStyle)style NS_UNAVAILABLE;
- (instancetype)init NS_UNAVAILABLE;
+ (instancetype) new NS_UNAVAILABLE;

@end
NS_ASSUME_NONNULL_END


#endif /* RTCSettingsLastmileController_h */
