//
//  RTCSettingsBaseController.m
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCSettingsBaseController.h"
#import "RTCSettingsTextTableViewCell.h"
#import "BaiduRtcRoom/BaiduRtcRoom.h"
#import "RTCSettingsModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface RTCSettingsBaseController () <UITextFieldDelegate, RTCSettingsTextTableViewCellDelegate>
@end

@implementation RTCSettingsBaseController

- (UITableViewCell *)tableCellForTableView:(UITableView *)tableView
                                identifier:(NSString *)identifier
                                     title:(NSString *)title
                                       key:(NSString *)key
                               atIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                      reuseIdentifier:identifier];
        int labelX = 48, labelY = 6;
        UILabel *labelView = [[UILabel alloc] initWithFrame:CGRectMake(labelX, labelY, cell.bounds.size.width - labelX,
                                    (cell.bounds.size.height - labelY) / 2)];
        labelView.tag = indexPath.row;
        labelView.textAlignment = NSTextAlignmentRight;   
        labelView.textColor = [UIColor blueColor];
        cell.accessoryView = labelView;
    }
    cell.textLabel.text = title;
    cell.textLabel.font = [UIFont systemFontOfSize:12.0];
    cell.accessoryType = UITableViewCellAccessoryNone;
    UILabel *labelView = (UILabel *)cell.accessoryView;
    labelView.text = key;
    return cell;
}

- (void)tableView:(UITableView *)tableView arraySelect:(NSArray<NSString *> *)arraySelect success:(BSPopupSelectBlock)success {
    UIAlertController *alertController = [UIAlertController
                                            alertControllerWithTitle:NULL
                                                             message:NULL
                                                      preferredStyle:UIAlertControllerStyleActionSheet];
    for (int index = 0; index < arraySelect.count; index++) {
        [alertController addAction:[UIAlertAction actionWithTitle:arraySelect[index]
                                                style:UIAlertActionStyleDefault
                                                handler:^(UIAlertAction * _Nonnull action) {
            if (success != nil) {
                success(index);
            }
            [tableView reloadData];
        }]];
    }
    [alertController addAction:[UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:NULL]];

    [self presentViewController:alertController animated:YES completion:nil];
}

- (void)tableView:(UITableView *)tableView defSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    UITableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
    for (int i = 0; i < cell.subviews.count; i++) {
        UIView *subView = cell.subviews[i];
        if ([subView isKindOfClass:[UITextField class]]) {
            [subView becomeFirstResponder];
        }
    }
}

- (UITextField *)generateTextField:(CGRect)rect placeholder:(NSString*)pholder text:(NSString*)context {
    UITextField* uiTextField =  [[UITextField alloc] initWithFrame:rect];
    uiTextField.text = context;
    uiTextField.placeholder = pholder;
    uiTextField.delegate = self;
    // Numerical keyboards have no return button, we need to add one manually.
    UIToolbar *numberToolbar =
    [[UIToolbar alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, 50)];
    numberToolbar.items = @[
                            [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace
                                                                          target:nil
                                                                          action:nil],
                            [[UIBarButtonItem alloc] initWithTitle:@"应用"
                                                             style:UIBarButtonItemStyleDone
                                                            target:self
                                                            action:@selector(serverSettingTextFieldDidEndEditing:)]
                            ];
    [numberToolbar sizeToFit];
    uiTextField.inputAccessoryView = numberToolbar;
    return uiTextField;
}

- (UITableViewCell *)baseTextTableViewCellForTableView:(UITableView *)tableView
                                               section:(int)section
                                              valueSEL:(SEL)valueSEL
                                           placeHolder:(NSString *)placeHolder
                                              isNumber:(BOOL)isNumber
                                         settingsModel:(RTCSettingsModel *)settingsModel {
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Warc-performSelector-leaks"
    NSString *curentVal = @"";
    if ([settingsModel respondsToSelector:valueSEL]) {
        id val = [settingsModel performSelector:valueSEL];
        if ([val isKindOfClass:[NSString class]]) {
            curentVal = (NSString *)val;
        } else {
            curentVal = [(NSNumber *)[settingsModel performSelector:valueSEL] stringValue];
        }
    }
#pragma clang diagnostic pop
    
    RTCSettingsTextTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:RTCSettingsTextTableViewCellIdentifier];
    if (!cell) {
        cell = [[RTCSettingsTextTableViewCell alloc] initWithHostView:self.view];
        cell.delegate = self;
    }
    cell.section = section;
    cell.placeholder = placeHolder;
    cell.text = curentVal;
    if (isNumber) {
        cell.keyboardType = UIKeyboardTypeNumberPad;
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.userInteractionEnabled = YES;
    return cell;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    
}

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField {
    return YES;
}

- (void)settingsTextCellDidEngEditing:(RTCSettingsTextTableViewCell *)cell {
    
}

- (void)serverSettingTextFieldDidEndEditing:(id)sender {
    [self.view endEditing:YES];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
}

#pragma mark -
- (void)addDoneBarButton {
    UIBarButtonItem *barItem = [[UIBarButtonItem alloc]
                                initWithTitle:@"Settings"
                                        style:UIBarButtonItemStyleDone
                                       target:self
                                       action:@selector(dismissModally:)];
    self.navigationItem.leftBarButtonItem = barItem;
}

- (void)dismissModally:(id)sender {
    [self dismissViewControllerAnimated:YES completion:nil];
}

@end

NS_ASSUME_NONNULL_END
