//
//  RTCSettingsBaseController.h
//  rtc_sdk_ios
//
//  Created by Sun,Jian(ACU-T102) on 2018/12/31.
//  Copyright © 2018年 Sun,Jian(ACU-T102). All rights reserved.
//

#ifndef RTCSettingsBaseController_h
#define RTCSettingsBaseController_h
#import <UIKit/UIKit.h>

@class RTCSettingsModel;

NS_ASSUME_NONNULL_BEGIN

#define BD_SYMBOL_CONCAT(a, b) a##b

typedef void (^BSPopupSelectBlock)(int index);

@interface RTCSettingsBaseController : UITableViewController

- (UITableViewCell *)tableCellForTableView:(UITableView *)tableView
                                identifier:(NSString *)identifier
                                     title:(NSString *)title
                                       key:(NSString *)key
                               atIndexPath:(NSIndexPath *)indexPath;

- (void)tableView:(UITableView *)tableView
      arraySelect:(NSArray<NSString *> *)arraySelect
          success:(BSPopupSelectBlock)success;

- (UITableViewCell *)baseTextTableViewCellForTableView:(UITableView *)tableView
                                               section:(int)section
                                              valueSEL:(SEL)valueSEL
                                           placeHolder:(NSString *)placeHolder
                                              isNumber:(BOOL)isNumber
                                         settingsModel:(RTCSettingsModel *)settingsModel;

- (UITextField *)generateTextField:(CGRect)rect placeholder:(NSString*)pholder text:(NSString*)context;

- (void)tableView:(UITableView *)tableView defSelectRowAtIndexPath:(NSIndexPath *)indexPath;

- (void)addDoneBarButton;
@end

NS_ASSUME_NONNULL_END

#endif /* RTCSettingsBaseController_h */
