//
//  RTCScrollSubView.m
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/8/15.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCScrollSubView.h"
#import <AVFoundation/AVFoundation.h>

@implementation RTCsubviewInfo

- (instancetype)initWithParams:(BOOL)local uid:(NSString*)userId view:(UIView*)subView size:(CGSize)videoResolution {
    if (self = [super init]) {
        self.userId = userId;
        self.isLocal = local;
        self.showView = subView;
        self.videoResolution = videoResolution;
    }
    return self;
}

@end

@interface RTCScrollSubView ()


@property (nonatomic,strong) NSMutableDictionary *shownVideoViews;

@property (nonatomic,assign) int viewIndex;

@end




@implementation RTCScrollSubView

@synthesize  remoteUids = _remoteUids;

- (void)dealloc {
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

- (instancetype)initWithFrame:(CGRect)frame {
    
    if (self = [super initWithFrame:frame]) {
        _shownVideoViews = [NSMutableDictionary dictionary];
        _viewIndex = 0;
    }
    self.autoresizingMask = UIViewAutoresizingFlexibleLeftMargin|
                            UIViewAutoresizingFlexibleWidth|
                            UIViewAutoresizingFlexibleRightMargin|
                            UIViewAutoresizingFlexibleTopMargin|
                            UIViewAutoresizingFlexibleHeight|
                            UIViewAutoresizingFlexibleBottomMargin;
    return  self;
}

- (NSMutableArray *) remoteUids {
    if(!_remoteUids) {
        _remoteUids = [NSMutableArray array];
    }
    return _remoteUids;
}

- (void)addRTCsubView:(NSString*)uId local:(BOOL)isLocal view:(UIView*)subview size:(CGSize)videoRelution {
    
    NSLog(@"addRTCsubView: self : %@, view : %@, size : %f, %f", self, subview, videoRelution.width, videoRelution.height);
    if (subview) {
        RTCsubviewInfo* rtcSubviewInfo = [[RTCsubviewInfo alloc] initWithParams:isLocal uid:uId view:subview size:videoRelution];
        [_shownVideoViews setObject:rtcSubviewInfo forKey:uId];
        [self addSubview:subview];
        [self setNeedsLayout];
    }
    if (!isLocal) {
        [self.remoteUids addObject:uId];
    }
}
- (void)removeRTCsubView:(NSString*)uId {
    RTCsubviewInfo* subviewInfo = [_shownVideoViews objectForKey:uId];
    if ( subviewInfo.showView != nil) {
        [subviewInfo.showView removeFromSuperview];
        subviewInfo.showView = nil;
        [_shownVideoViews removeObjectForKey:uId];
        [self setNeedsLayout];
    }
}

- (void)layoutSubviews {

    [super layoutSubviews];
 
    NSMutableArray *videoViews = [NSMutableArray array];
    [videoViews addObjectsFromArray:[_shownVideoViews allValues]];
    
    if (videoViews.count == 1) {
        if(((RTCsubviewInfo*)videoViews[0]).isLocal) {
            CGRect rectMid = CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height);
            ((RTCsubviewInfo*)videoViews[0]).showView.frame = rectMid;
        } else {
            CGRect rectMid = CGRectMake(0, 0, self.bounds.size.width, self.bounds.size.height);
            
            CGSize dest = ((RTCsubviewInfo*)videoViews[0]).videoResolution;
            if (dest.width > 0 && dest.height > 0) {
                CGRect videoViewFrame = AVMakeRectWithAspectRatioInsideRect(dest, rectMid);
                ((RTCsubviewInfo*)videoViews[0]).showView.frame = videoViewFrame;
            } else {
                ((RTCsubviewInfo*)videoViews[0]).showView.frame = rectMid;
            }
        }
        
    } else if (videoViews.count == 2) {
        
        if(((RTCsubviewInfo*)videoViews[0]).isLocal) {
            CGRect rectMid = CGRectMake(0, self.bounds.size.height/4, self.bounds.size.width/2, self.bounds.size.height/2);
            ((RTCsubviewInfo*)videoViews[0]).showView.frame = rectMid;
        } else {
            CGRect rectMid = CGRectMake(0, self.bounds.size.height/4, self.bounds.size.width/2, self.bounds.size.height/2);
            
            CGSize dest = ((RTCsubviewInfo*)videoViews[0]).videoResolution;
            if (dest.width > 0 && dest.height > 0) {
                CGRect videoViewFrame = AVMakeRectWithAspectRatioInsideRect(dest, rectMid);
                ((RTCsubviewInfo*)videoViews[0]).showView.frame = videoViewFrame;
            } else {
                ((RTCsubviewInfo*)videoViews[0]).showView.frame = rectMid;
            }
        }
        
        if(((RTCsubviewInfo*)videoViews[1]).isLocal) {
            CGRect rectMidOther = CGRectMake(0, self.bounds.size.height/4, self.bounds.size.width/2, self.bounds.size.height/2);
            ((RTCsubviewInfo*)videoViews[1]).showView.frame = rectMidOther;
        }else{
            CGRect rectMidOther = CGRectMake(self.bounds.size.width/2, self.bounds.size.height/4, self.bounds.size.width/2, self.bounds.size.height/2);
            
            CGSize dest = ((RTCsubviewInfo*)videoViews[1]).videoResolution;
            if (dest.width > 0 && dest.height > 0) {
                CGRect videoViewFrame = AVMakeRectWithAspectRatioInsideRect(dest, rectMidOther);
                ((RTCsubviewInfo*)videoViews[1]).showView.frame = videoViewFrame;
            } else {
                ((RTCsubviewInfo*)videoViews[1]).showView.frame = rectMidOther;
            }
        }
    } else {
        
        BOOL hasLocalView = NO; //标识：本地视频是不是这个滑动页有
        BOOL  boAreadySerial = NO; //标识：本地视频是不是排进去啦
        for (int i=0; i < [videoViews count]; i++) {
            if (((RTCsubviewInfo*)videoViews[i]).isLocal) {
                hasLocalView = YES;
            }
        }
        for (int i=0; i < [videoViews count]; i++) {
            CGRect frame;
            if(((RTCsubviewInfo*)videoViews[i]).isLocal) {
                //offset = 1;
                frame = [self frameAtPosition:0];
                boAreadySerial = YES;
                ((RTCsubviewInfo*)videoViews[i]).showView.frame = frame;
            }else{
                if (hasLocalView) {
                    if (boAreadySerial) {
                        frame = [self frameAtPosition:i];
                    } else {
                        frame = [self frameAtPosition:i + 1];
                    }
                } else {
                    frame = [self frameAtPosition:i];
                }
                
                CGSize dest = ((RTCsubviewInfo*)videoViews[i]).videoResolution;
                if (dest.width > 0 && dest.height > 0) {
                    CGRect videoViewFrame = AVMakeRectWithAspectRatioInsideRect(dest, frame);
                    ((RTCsubviewInfo*)videoViews[i]).showView.frame = videoViewFrame;
                } else {
                    ((RTCsubviewInfo*)videoViews[i]).showView.frame = frame;
                }

//                NSLog(@"index:%d updateSubView:videoView  width:%f height:%f", i, dest.width, dest.height);
            }
        }
    }
}

- (CGRect)frameAtPosition:(int)postion {
    
    CGRect bounds = self.bounds;
    CGFloat width = bounds.size.width / 2;
    CGFloat height = bounds.size.height  / 2;
    CGFloat x = (postion%2) * width;
    CGFloat y = (postion/2) * height;
    CGRect frame = CGRectMake(x, y, width, height);
    return frame;
}
@end
