//
//  RTCScrollSubView.h
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/8/15.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN
@interface RTCsubviewInfo : NSObject
@property (nonatomic, copy) NSString *userId;
@property (nonatomic, assign) BOOL isLocal;
@property (nonatomic, assign) CGSize videoResolution;
@property (nonatomic, strong) UIView *showView;

- (instancetype)initWithParams:(BOOL)local uid:(NSString*)userId view:(UIView*)subView size:(CGSize)videoResolution;
@end

@interface RTCScrollSubView : UIView

@property(nonatomic, strong) NSMutableArray<NSString *> *remoteUids;


- (instancetype)initWithFrame:(CGRect)frame;

- (void)addRTCsubView:(NSString *)uId local:(BOOL)isLocal view:(UIView *)subview size:(CGSize)videoRelution;

- (void)removeRTCsubView:(NSString *)uId;

@end

NS_ASSUME_NONNULL_END
