//
//  RTCCallingSettingsPanelView.m
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/8/8.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import "RTCCallingSettingsPanelView.h"
#import "BaiduRtcRoom/BaiduRtcRoom.h"
#import "RTCCallingSettingScreenView.h"
#import "UIView+BBAUtility.h"
#import <BaiduRtcRoom/BaiduRtcRoomApiDefines.h>
#import "RTCSettingsModel.h"

static int const kSettingSwitchTagVideoEnhance  = 100;
static int const kSettingSwitchTagWatermark     = 101;
static int const kSettingSwitchTagAudioPlayLoopback     = 102;
static int const kSettingSwitchTagAudioIndication       = 103;
static int const kSettingSwitchTagCameraOrient          = 104;
static int const kSettingSwitchTagSuperResolution       = 105;
static int const kSettingSwitchTagPushStream            = 106;

@interface RTCCallingSettingsPanelView ()<UITextFieldDelegate, RTCCallingSettingScreenViewDelegate>

@property (nonatomic, strong) UISegmentedControl *segmentedControlSetting;
@property (nonatomic, strong) NSArray<UIView *> *settingViews;
@property (nonatomic, assign) NSInteger  nsegmentShownIndex;
@property (nonatomic, assign) CGRect rectScroll;
@property (nonatomic, assign) NSInteger audioPlayerState;
@property (nonatomic, assign) BOOL isStartStressDataChannelTest;
@property (nonatomic, assign) BOOL isSendDataReliable;
@end

@implementation RTCCallingSettingsPanelView {
    
    UIScrollView   *_viewAudioSetting;
    UIScrollView   *_viewVideoSetting;
    UIScrollView   *_viewRoomSetting;
    UIScrollView   *_viewOperateSetting;
    UIScrollView   *_viewMessageSetting;
    UIScrollView   *_viewStreamSetting;
    RTCCallingSettingScreenView   *_viewScreenSetting;
    
    //for controler in _viewAudioSetting
    UIButton    *_startPlayerButton;
    UIButton    *_endPlayerButton;
    UILabel     *_loopbackLabel;
    UITextField *_cycleTextField;
    UISwitch    *_loopbackSwitch;
    
    UILabel     *_audioLevelLabel;
    UITextField *_audioLevelTextField;
    UISwitch    *_audioLevelSwitch;
    
    //for controler in _viewVideoSetting
    UILabel *_cameraOrientField;
    UILabel *_imageEnhancementField;
    UILabel *_superResolutionField;
    UILabel *_timeWatermark;
    UILabel *_pushStreamField;

    UITextField *_screenShotTextField; // userId
    UISwitch    *_cameraOrientSwitch;
    UISwitch    *_imageQEswitch;
    UISwitch    *_superResolutionSwitch;
    UISwitch    *_waterMaskEswitch;
    UISwitch    *_pushStreamswitch;
    UIButton    *_screenshotButton;
    UIButton    *_recordTypeButton;
    int         _recordType;
    UIButton    *_recordMixLayoutButton;
    int         _recordMixLayout;
    UIButton    *_startRecord;
    
    //for controler in _viewRoomSetting
    UILabel *_roomIdField;
    UILabel *_userIdField;
    UITextField *_roomIdContentField;
    UITextField *_suerIdContentField;
    UIButton    *_callButton;
    UIButton    *_callStopButton;
    UIButton    *_callStopAllButton;
    
    //for controler in _viewOperateSetting
    UITextField *_userIdShutupField;
    UIButton    *_shutupOnButton;
    UIButton    *_removeButton;
    UITextField *_userIdOperateField;
    UIButton    *_shutupOffButton;
    UIButton    *_removeOperateButton;
    UIButton    *_shutupAllButton;
    UIButton    *_disbanRoomButton;
    UIButton    *_speakerStatusButton;
    UIButton    *_switchRoleButton;

    //for controler in _videoMessageSetting
    UILabel     *_roomBroadcastLabel;
    UITextField *_messageField;
    UIButton    *_sendButton;
    UILabel     *_userBroadcastLabel;
    UITextField *_userIdMessageField;
    UITextField *_userMessageField;
    UIButton    *_sendMessageButton;
    // reconstruct mode data channel stress test
    UILabel     *_userDataChanneLabel;
    UIButton    *_sendDataReliableButton;
    UIButton    *_sendDataChannelButton;
    UITextField *_sendDataFrequencyField;
    UILabel     *_userDataFrequencyLabel;
    UITextField *_sendDataKBytesField;
    UILabel     *_userDataKBytesLabel;
    
    //for controler in _viewStreamSetting
    UITextField *_userIdSubribeField;
    UIButton    *_subribeButton;
    UITextField *_userIdCancelField;
    UIButton    *_cancelSubribeButton;
    UIButton    *_updateSubribeButton;
}

/*UITextFieldDelegate
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

- (void)dealloc {
}

- (void)buildUI {
    [self addSubview:[self segmentedControlSetting]];
    _nsegmentShownIndex = 0; //默认显示video设置
    _isStartStressDataChannelTest = NO;
    _isSendDataReliable = NO;
    
    [self buildUIForAudio];
    [self buildUIForVideo];
    [self buildUIForRoom];
    [self buildUIForOperate];
    [self buildUIForMessage];
    [self buildUIForStream];
    [self buildUIForScreen];
    
    self.settingViews = @[
        _viewAudioSetting, _viewVideoSetting, _viewRoomSetting, _viewOperateSetting, _viewMessageSetting, _viewStreamSetting, _viewScreenSetting
    ];
}

- (void)buildUIForAudio {
    _viewAudioSetting = [self createSettingBaseView];
    [self addSubview:_viewAudioSetting];
    
    _startPlayerButton = [self newBtnForTitle:@"播放音乐" titleColor:[UIColor whiteColor] bgColor:[UIColor systemBlueColor]];
    [_startPlayerButton addTarget:self action:@selector(startPlayer:) forControlEvents:UIControlEventTouchUpInside];
    [_viewAudioSetting addSubview:_startPlayerButton];
    _endPlayerButton = [self newBtnForTitle:@"停止播放" titleColor:[UIColor whiteColor] bgColor:[UIColor systemBlueColor]];
    [_endPlayerButton addTarget:self action:@selector(endPlayer:) forControlEvents:UIControlEventTouchUpInside];
    [_viewAudioSetting addSubview:_endPlayerButton];
    
    _loopbackLabel = [self generateLabelForTitle:@"循环"];
    [_viewAudioSetting addSubview:_loopbackLabel];
    _cycleTextField = [self generateNumberField:CGRectZero placeholder:@"播放次数" text:@""];
    _cycleTextField.text = @"-1";
    [_viewAudioSetting addSubview:_cycleTextField];
    _loopbackSwitch = [self generateSwitch:_viewAudioSetting tag:kSettingSwitchTagAudioPlayLoopback];
    [_viewAudioSetting addSubview:_loopbackSwitch];
    
    _audioLevelLabel = [self generateLabelForTitle:@"音量提示"];
    [_viewAudioSetting addSubview:_audioLevelLabel];
    _audioLevelTextField = [self generateNumberField:CGRectZero placeholder:@"间隔" text:@""];
    _audioLevelTextField.text = @"200";
    [_viewAudioSetting addSubview:_audioLevelTextField];
    _audioLevelSwitch = [self generateSwitch:_viewAudioSetting tag:kSettingSwitchTagAudioIndication];
    _audioLevelSwitch.on = [[RTCSettingsModel sharedInstance] currentEnableAudioVolumeIndicationFromStore];
    [_viewAudioSetting addSubview:_audioLevelSwitch];
}

- (void)buildUIForVideo {
    //for settiong in calling
    _viewVideoSetting = [self createSettingBaseView];
    [self addSubview:_viewVideoSetting];
    
    _imageEnhancementField = [self generateLabelForTitle:@"画质增强"];
    [_viewVideoSetting addSubview:_imageEnhancementField];
    _imageQEswitch = [self generateSwitch:_viewVideoSetting tag:kSettingSwitchTagVideoEnhance];
    
    _imageQEswitch.on =  [[RTCSettingsModel sharedInstance] currentVideoEnhanceFromStore];
//    if ([[RTCSettingsModel sharedInstance] currentVideoEnhanceFromStore]) {
//        [self.avVideoEffect setVideoEnhanceEX:1   contrast:3.003 saturation:0.999];
//        [self.avVideoEffect resetVideoEnhanceEX:YES];
//    } else {
//        [self.avVideoEffect resetVideoEnhanceEX:YES];
//
//    }
     
    [_viewVideoSetting addSubview:_imageQEswitch];
    
    _superResolutionField = [self generateLabelForTitle:@"超分"];
    [_viewVideoSetting addSubview:_superResolutionField];
    _superResolutionSwitch = [self generateSwitch:_viewVideoSetting tag:kSettingSwitchTagSuperResolution];
    _superResolutionSwitch.on = [[RTCSettingsModel sharedInstance] currentSuperResolutionFromStore];
    [_viewVideoSetting addSubview:_superResolutionSwitch];
    
    _pushStreamField = [self generateLabelForTitle:@"开始推流"];
    [_viewVideoSetting addSubview:_pushStreamField];
    _pushStreamswitch = [self generateSwitch:_viewVideoSetting tag:kSettingSwitchTagPushStream];
    _pushStreamswitch.on = [RTCSettingsModel sharedInstance].pushStream;
    [_viewVideoSetting addSubview:_pushStreamswitch];
    

    _timeWatermark = [self generateLabelForTitle:@"水印"];
    [_viewVideoSetting addSubview:_timeWatermark];
    _waterMaskEswitch = [self generateSwitch:_viewVideoSetting tag:kSettingSwitchTagWatermark];
    _waterMaskEswitch.on =  [[RTCSettingsModel sharedInstance] currentWaterMarkFromStore];
    [_viewVideoSetting addSubview:_waterMaskEswitch];
    
    _cameraOrientField = [self generateLabelForTitle:@"相机方向锁定"];
    [_viewVideoSetting addSubview:_cameraOrientField];
    _cameraOrientSwitch = [self generateSwitch:_viewVideoSetting tag:kSettingSwitchTagCameraOrient];
    _cameraOrientSwitch.on = [[RTCSettingsModel sharedInstance] currentLockCameraOrient];
    [_viewVideoSetting addSubview:_cameraOrientSwitch];
    
    _screenShotTextField = [self generateNumberField:CGRectZero placeholder:@"userId" text:@""];
    [_viewVideoSetting addSubview:_screenShotTextField];
    _screenshotButton = [self newBtnForTitle:@"截图" titleColor:[UIColor whiteColor] bgColor:[UIColor systemBlueColor]];
    [_screenshotButton addTarget:self action:@selector(snapshot:) forControlEvents:UIControlEventTouchUpInside];
    [_viewVideoSetting addSubview:_screenshotButton];
    
    // 录制配置
    _recordTypeButton = [self newBtnForTitle:@"" titleColor:[UIColor systemBlueColor] bgColor:[UIColor whiteColor]];
    [_recordTypeButton addTarget:self action:@selector(changeRecordType:) forControlEvents:UIControlEventTouchUpInside];
    [self updateRecordTypeText:2];
    _recordMixLayoutButton = [self newBtnForTitle:@"" titleColor:[UIColor systemBlueColor] bgColor:[UIColor whiteColor]];
    [_recordMixLayoutButton addTarget:self action:@selector(changeRecordMixLayout:) forControlEvents:UIControlEventTouchUpInside];
    [self updateRecordMixLayoutText:0];
    
    [_viewVideoSetting addSubview:_recordTypeButton];
    [_viewVideoSetting addSubview:_recordMixLayoutButton];
    
    // 录制控制
    _startRecord = [self newBtnForTitle:@"开始录制" titleColor:[UIColor whiteColor] bgColor:[UIColor systemBlueColor]];
    [_startRecord addTarget:self action:@selector(startRecord:) forControlEvents:UIControlEventTouchUpInside];
    [_viewVideoSetting addSubview:_startRecord];
}

- (void)buildUIForRoom {
    //for beautyFace in calling
    _viewRoomSetting = [self createSettingBaseView];
    [self addSubview:_viewRoomSetting];
    _roomIdField = [self generateLabelForTitle:@"房间ID"];
    [_viewRoomSetting addSubview:_roomIdField];
    _roomIdContentField = [self generateTextField:CGRectZero placeholder:@"单行输入" text:@""];
    [_viewRoomSetting addSubview:_roomIdContentField];
    _userIdField = [self generateLabelForTitle:@"UserID"];
    [_viewRoomSetting addSubview:_userIdField];
    _suerIdContentField = [self generateTextField:CGRectZero placeholder:@"单行输入" text:@""];
    [_viewRoomSetting addSubview:_suerIdContentField];
    
    _callButton = [self newBtnForTitle:@"连麦" titleColor:[UIColor whiteColor] bgColor:[UIColor systemBlueColor]];
    [_callButton addTarget:self action:@selector(multiRoomJoin:) forControlEvents:UIControlEventTouchUpInside];
    [_viewRoomSetting addSubview:_callButton];
    _callStopButton = [self newBtnForTitle:@"停止连麦" titleColor:[UIColor whiteColor] bgColor:[UIColor systemBlueColor]];
    [_callStopButton addTarget:self action:@selector(multiRoomJoin:) forControlEvents:UIControlEventTouchUpInside];
    [_viewRoomSetting addSubview:_callStopButton];
    _callStopAllButton = [self newBtnForTitle:@"全部停止" titleColor:[UIColor whiteColor] bgColor:[UIColor systemBlueColor]];
    [_callStopAllButton addTarget:self action:@selector(multiRoomJoin:) forControlEvents:UIControlEventTouchUpInside];
    [_viewRoomSetting addSubview:_callStopAllButton];
}

- (void)buildUIForOperate {
    _viewOperateSetting = [self createSettingBaseView];
    [self addSubview:_viewOperateSetting];
    
    _userIdShutupField = [self generateTextField:CGRectZero placeholder:@"请输入UserId" text:@""];
    [_viewOperateSetting addSubview:_userIdShutupField];
    
    _shutupOnButton = [self newBtnForTitle:@"禁言" titleColor:[UIColor redColor] bgColor:nil];
    [_shutupOnButton addTarget:self action:@selector(shutupAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewOperateSetting addSubview:_shutupOnButton];
    
    _removeButton = [self newBtnForTitle:@"移出" titleColor:[UIColor redColor] bgColor:nil];
    [_removeButton addTarget:self action:@selector(removeFromRoomAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewOperateSetting addSubview:_removeButton];
    
    _userIdOperateField = [self generateTextField:CGRectZero placeholder:@"请输入UserId" text:@""];
    [_viewOperateSetting addSubview:_userIdOperateField];
    
    _shutupOffButton = [self newBtnForTitle:@"解除禁言" titleColor:[UIColor redColor] bgColor:nil];
    [_shutupOffButton addTarget:self action:@selector(shutupOffAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewOperateSetting addSubview:_shutupOffButton];
    
    _removeOperateButton = [self newBtnForTitle:@"移出" titleColor:[UIColor redColor] bgColor:nil];
    [_removeOperateButton addTarget:self action:@selector(removeFromRoom2Action:) forControlEvents:UIControlEventTouchUpInside];
    [_viewOperateSetting addSubview:_removeOperateButton];
    
    _shutupAllButton = [self newBtnForTitle:@"全部禁言" titleColor:[UIColor whiteColor] bgColor:[UIColor redColor] radius:3];
    [_shutupAllButton addTarget:self action:@selector(shutupAllAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewOperateSetting addSubview:_shutupAllButton];
    
    _disbanRoomButton = [self newBtnForTitle:@"解散房间" titleColor:[UIColor whiteColor] bgColor:[UIColor redColor] radius:3];
    [_disbanRoomButton addTarget:self action:@selector(disbandRoomAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewOperateSetting addSubview:_disbanRoomButton];
    
    _speakerStatusButton = [self newBtnForTitle:@"扬声器状态" titleColor:[UIColor whiteColor] bgColor:[UIColor systemBlueColor] radius:3];
    [_speakerStatusButton addTarget:self action:@selector(speakerStatusAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewOperateSetting addSubview:_speakerStatusButton];
    
    _switchRoleButton = [self newBtnForTitle:@"角色切换" titleColor:[UIColor whiteColor] bgColor:[UIColor systemBlueColor] radius:3];
    [_switchRoleButton addTarget:self action:@selector(switchRole:) forControlEvents:UIControlEventTouchUpInside];
    [_viewOperateSetting addSubview:_switchRoleButton];
}

- (void)buildUIForMessage {
    _viewMessageSetting = [self createSettingBaseView];
    [self addSubview:_viewMessageSetting];
    
    _roomBroadcastLabel = [self generateLabelForTitle:@"房间广播"];
    [_viewMessageSetting addSubview:_roomBroadcastLabel];
    
    _messageField = [self generateTextField:CGRectZero placeholder:@"单行输入" text:@""];
    [_viewMessageSetting addSubview:_messageField];
    
    _sendButton = [self newBtnForTitle:@"发送" titleColor:[UIColor systemBlueColor] bgColor:nil];
    [_sendButton addTarget:self action:@selector(sendMessageAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewMessageSetting addSubview:_sendButton];
    
    _userBroadcastLabel = [self generateLabelForTitle:@"指定用户"];
    [_viewMessageSetting addSubview:_userBroadcastLabel];
    
    _userIdMessageField = [self generateTextField:CGRectZero placeholder:@"用户ID" text:@""];
    [_viewMessageSetting addSubview:_userIdMessageField];
    
    _userMessageField = [self generateTextField:CGRectZero placeholder:@"单行输入" text:@""];
    [_viewMessageSetting addSubview:_userMessageField];
    
    _sendMessageButton = [self newBtnForTitle:@"发送" titleColor:[UIColor systemBlueColor] bgColor:nil];
    [_sendMessageButton addTarget:self action:@selector(sendMessageToUserAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewMessageSetting addSubview:_sendMessageButton];

    _userDataChanneLabel = [self generateLabelForTitle:@"DataChannel压测"];
    [_viewMessageSetting addSubview:_userDataChanneLabel];

    // datachannel stress test send frequency
    _sendDataFrequencyField = [self generateTextField:CGRectZero placeholder:@"1000" text:@""];
    [_viewMessageSetting addSubview:_sendDataFrequencyField];

    _userDataFrequencyLabel = [self generateLabelForTitle:@"条/秒"];
    [_viewMessageSetting addSubview:_userDataFrequencyLabel];

    // datachannel stress test send size
    _sendDataKBytesField = [self generateTextField:CGRectZero placeholder:@"200" text:@""];
    [_viewMessageSetting addSubview:_sendDataKBytesField];

    _userDataKBytesLabel = [self generateLabelForTitle:@"bps/条"];
    [_viewMessageSetting addSubview:_userDataKBytesLabel];

    _sendDataReliableButton = [self newBtnForTitle:@"不可靠" titleColor:[UIColor systemBlueColor] bgColor:nil];
    [_sendDataReliableButton addTarget:self action:@selector(sendDataReliableAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewMessageSetting addSubview:_sendDataReliableButton];

    _sendDataChannelButton = [self newBtnForTitle:@"开始" titleColor:[UIColor systemBlueColor] bgColor:nil];
    [_sendDataChannelButton addTarget:self action:@selector(startStressDataChannelAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewMessageSetting addSubview:_sendDataChannelButton];
}

- (void)buildUIForStream {
    _viewStreamSetting = [self createSettingBaseView];
    [self addSubview:_viewStreamSetting];
    
    _userIdSubribeField = [self generateTextField:CGRectZero placeholder:@"多个userId，用,分割" text:@""];
    [_viewStreamSetting addSubview:_userIdSubribeField];
    
    _subribeButton = [self newBtnForTitle:@"订阅" titleColor:[UIColor systemBlueColor] bgColor:nil];
    [_subribeButton addTarget:self action:@selector(subribeStreamAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewStreamSetting addSubview:_subribeButton];
    
    _userIdCancelField = [self generateTextField:CGRectZero placeholder:@"多个userId，用,分割" text:@""];
    [_viewStreamSetting addSubview:_userIdCancelField];
    
    _cancelSubribeButton = [self newBtnForTitle:@"取消订阅" titleColor:[UIColor systemBlueColor] bgColor:nil];
    [_cancelSubribeButton addTarget:self action:@selector(cancelSubribeStreamAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewStreamSetting addSubview:_cancelSubribeButton];
    
    _updateSubribeButton = [self newBtnForTitle:@"更新位置" titleColor:[UIColor systemBlueColor] bgColor:nil];
    [_updateSubribeButton addTarget:self action:@selector(updateSubribeStreamAction:) forControlEvents:UIControlEventTouchUpInside];
    [_viewStreamSetting addSubview:_updateSubribeButton];
}

- (void)buildUIForScreen {
    _viewScreenSetting = [[RTCCallingSettingScreenView alloc] init];
    _viewScreenSetting.delegate = self;
    [self addSubview:_viewScreenSetting];
}

- (instancetype)initWithFrame:(CGRect)frame {
    
    self = [super initWithFrame:frame];
    if (self) {
        [self buildUI];
    }
    
    return self;
}

- (void)stopScheduler {
    
    [[RTCSettingsModel sharedInstance] storeWaterMark:NO];
    [[RTCSettingsModel sharedInstance] storeVideoEnhance:NO];
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    CGFloat scrollViewW = self.frame.size.width;
    CGFloat scrollViewH = self.frame.size.height;
    CGFloat scrollViewX = 0;
    CGFloat scrollViewY = 0;
    CGFloat horPadding = 20, verPadding = 20;
    CGFloat horMargin = 5, verMargin = 10;
    CGFloat contentViewW = scrollViewW - horPadding * 2;
    _rectScroll = CGRectMake(scrollViewX,scrollViewY,scrollViewW,scrollViewH/7);
    
    _segmentedControlSetting.frame = _rectScroll;
   
    CGRect settingArea= CGRectMake(scrollViewX,scrollViewY+scrollViewH/7,scrollViewW,scrollViewH*6/7);
    [_viewRoomSetting setContentSize:CGSizeMake(scrollViewW, 400)];
    [_viewAudioSetting setContentSize:CGSizeMake(scrollViewW, 400)];
    [_viewOperateSetting setContentSize:CGSizeMake(scrollViewW, 400)];
    [_viewMessageSetting setContentSize:CGSizeMake(scrollViewW, 400)];
    [_viewStreamSetting setContentSize:CGSizeMake(scrollViewW, 400)];
    [_viewVideoSetting setContentSize:CGSizeMake(scrollViewW, 400)];
    
    
    _viewRoomSetting.frame  = settingArea;
    _viewAudioSetting.frame = settingArea;
    _viewVideoSetting.frame = settingArea;
    _viewOperateSetting.frame = settingArea;
    _viewMessageSetting.frame = settingArea;
    _viewStreamSetting.frame = settingArea;
    _viewScreenSetting.frame = settingArea;
    
    if ( 0 == _nsegmentShownIndex){
        _viewAudioSetting.hidden = NO;
        _viewVideoSetting.hidden = YES;
        _viewRoomSetting.hidden = YES;
        _viewOperateSetting.hidden = YES;
        _viewMessageSetting.hidden = YES;
        _viewStreamSetting.hidden = YES;
        _viewScreenSetting.hidden = YES;
    }
//    else {
//        _viewVideoSetting.hidden = YES;
//        _viewRoomSetting.hidden = NO;
//    }


    CGFloat heightField = scrollViewH/9;
    if (!_viewAudioSetting.hidden) {
        CGFloat y = verPadding;
        int btnNum = 2;
        CGFloat btnWidth = (contentViewW - horMargin * (btnNum - 1)) / btnNum;
        _startPlayerButton.frame = CGRectMake(horPadding, y, btnWidth, heightField);
        _endPlayerButton.frame = CGRectMake(CGRectGetMaxX(_startPlayerButton.frame) + horMargin, y, btnWidth, heightField);
        
        y += heightField + verMargin;
        _loopbackLabel.frame = CGRectMake(horPadding, y, scrollViewW/4, heightField);
        _cycleTextField.frame = CGRectMake(CGRectGetMaxX(_loopbackLabel.frame) + horMargin, y, scrollViewW/4, heightField);
        _loopbackSwitch.frame = CGRectMake(horPadding + contentViewW - scrollViewW/4, y, scrollViewW/4, heightField);
        
        y += heightField + verMargin;
        _audioLevelLabel.frame = CGRectMake(horPadding, y, scrollViewW/4, heightField);
        _audioLevelTextField.frame = CGRectMake(CGRectGetMaxX(_audioLevelLabel.frame) + horMargin, y, scrollViewW/4, heightField);
        _audioLevelSwitch.frame = CGRectMake(horPadding + contentViewW - scrollViewW/4, y, scrollViewW/4, heightField);
    }
    if (NO == _viewVideoSetting.hidden) {
        CGFloat y = 0;
        _imageEnhancementField.frame    = CGRectMake(horPadding, y, scrollViewW/2, heightField);
        _imageQEswitch.frame            = CGRectMake(horPadding + scrollViewW*2/3, y, scrollViewW/2, heightField);
        
        y += heightField + verMargin;
        _timeWatermark.frame            = CGRectMake(horPadding, y, scrollViewW/2, heightField);
        _waterMaskEswitch.frame         = CGRectMake(horPadding + scrollViewW*2/3, y, scrollViewW/2, heightField);
        
        y += heightField + verMargin;
        _cameraOrientField.frame        = CGRectMake(horPadding, y, scrollViewW/2, heightField);
        _cameraOrientSwitch.frame       = CGRectMake(horPadding + scrollViewW*2/3, y, scrollViewW/2, heightField);
        
        y += heightField + verMargin;
        _screenShotTextField.frame      = CGRectMake(horPadding, y, scrollViewW/2, heightField);
        _screenshotButton.frame         = CGRectMake(scrollViewW - verPadding - scrollViewW/4, y, scrollViewW/4, heightField);
        
        y += heightField + verMargin;
        _recordTypeButton.frame         = CGRectMake(horPadding, y, scrollViewW/4, heightField);
        _recordMixLayoutButton.frame    = CGRectMake(horPadding + scrollViewW/4 + horMargin, y, scrollViewW/4, heightField);
        _startRecord.frame              = CGRectMake(scrollViewW - scrollViewW/3 - horPadding, y, scrollViewW/3, heightField);


        y += heightField + verMargin;
        _superResolutionField.frame     = CGRectMake(horPadding, y, scrollViewW/2, heightField);
        _superResolutionSwitch.frame    = CGRectMake(horPadding + scrollViewW*2/3, y, scrollViewW/2, heightField);
        
        
        y += heightField + verMargin;
        _pushStreamField.frame          = CGRectMake(horPadding, y, scrollViewW/2, heightField);
        _pushStreamswitch.frame         = CGRectMake(horPadding + scrollViewW*2/3, y, scrollViewW/2, heightField);

    }
    if (NO == _viewRoomSetting.hidden) {
        _roomIdField.frame = CGRectMake(20, heightField,scrollViewW/2 , heightField);
        _roomIdContentField.frame    = CGRectMake(20+scrollViewW/2, heightField, scrollViewW/2, heightField);

        _userIdField.frame    = CGRectMake(20, heightField*3, scrollViewW/2, heightField);
        _suerIdContentField.frame = CGRectMake(20 + scrollViewW/2, heightField*3, scrollViewW/2, heightField);

        _callButton.frame  = CGRectMake(scrollViewW/12, heightField*5, scrollViewW/4, heightField);
        _callStopButton.frame  = CGRectMake(scrollViewW * 9/24, heightField*5, scrollViewW/4, heightField);
        _callStopAllButton.frame  = CGRectMake(scrollViewW * 2/3, heightField*5, scrollViewW/4, heightField);

    }
    
    if (NO == _viewOperateSetting.hidden) {
        _userIdShutupField.frame = CGRectMake(20, heightField, scrollViewW/3 + 10, heightField);
        _shutupOnButton.frame = CGRectMake(20 + scrollViewW/3 + 30, heightField, scrollViewW/4, heightField);
        _removeButton.frame = CGRectMake(20 + scrollViewW/3 + 30 + scrollViewW/4 + 10, heightField, scrollViewW/6, heightField);
        _userIdOperateField.frame = CGRectMake(20, heightField + heightField + 10 , scrollViewW/3 + 10, heightField);
        _shutupOffButton.frame = CGRectMake(20 + scrollViewW/3 + 30, heightField + heightField + 10, scrollViewW/4, heightField);
        _removeOperateButton.frame = CGRectMake(20 + scrollViewW/3 + 30 + scrollViewW/4 + 10, heightField + heightField + 10, scrollViewW/6, heightField);
        
        _shutupAllButton.frame  = CGRectMake(scrollViewW/12, heightField*5, scrollViewW/4, heightField);
        _disbanRoomButton.frame  = CGRectMake(scrollViewW * 9/24, heightField*5, scrollViewW/4, heightField);
        _speakerStatusButton.frame  = CGRectMake(scrollViewW * 2/3, heightField*5, scrollViewW/4 + 10, heightField);
        _switchRoleButton.frame  = CGRectMake(scrollViewW/12, heightField*6 + 10, scrollViewW/4 + 10, heightField);
    }
    
    if (NO == _viewMessageSetting.hidden) {
        _roomBroadcastLabel.frame = CGRectMake(20, 8, scrollViewW/3, heightField);
        _messageField.frame = CGRectMake(20, 8 + 5 + heightField, scrollViewW/6 + 10 + scrollViewW/2, heightField);
        _sendButton.frame = CGRectMake(scrollViewW - scrollViewW/8 - 20 , 8 + 5 + heightField, scrollViewW/8, heightField);
        _userBroadcastLabel.frame = CGRectMake(20, 8 + 5 + heightField +10 + heightField, scrollViewW/2, heightField);
        _userIdMessageField.frame = CGRectMake(20, 8 + heightField +10 + heightField + 10 + heightField, scrollViewW/6 + 15, heightField);
        _userMessageField.frame = CGRectMake(20 + scrollViewW/6 + 20 , 8 + heightField +10 + heightField + 10 + heightField, scrollViewW/2 - 10, heightField);
        _sendMessageButton.frame = CGRectMake(scrollViewW - scrollViewW/8 - 20  , 8 + heightField +10 + heightField + 10 + heightField, scrollViewW/8, heightField);

        // label
        int dataChannelY = heightField * 4 + 10 * 3 + 8;
        int dataChannelVY = dataChannelY + heightField + 8;
        _userDataChanneLabel.frame    = CGRectMake(20, dataChannelY, scrollViewW / 2 + 10, heightField);
        // frequency
        _sendDataFrequencyField.frame = CGRectMake(20, dataChannelVY, scrollViewW / 6 + 10, heightField);
        _userDataFrequencyLabel.frame = CGRectMake(20 + scrollViewW / 6 + 15, dataChannelVY, scrollViewW / 6, heightField);
        // kbytes
        _sendDataKBytesField.frame    = CGRectMake(20 + scrollViewW * 2 / 6 + 15, dataChannelVY, scrollViewW / 6 + 10, heightField);
        _userDataKBytesLabel.frame    = CGRectMake(20 + scrollViewW * 3 / 6 + 30, dataChannelVY, scrollViewW / 3, heightField);
        // reliable
        _sendDataReliableButton.frame = CGRectMake(20 + scrollViewW * 2 / 6 + 20, dataChannelY, scrollViewW / 4 + 8, heightField);
        // send
        _sendDataChannelButton.frame  = CGRectMake(scrollViewW - scrollViewW/8 - 20, dataChannelY, scrollViewW/8, heightField);
    }
    
    if (NO == _viewStreamSetting.hidden) {
        _userIdSubribeField.frame = CGRectMake(20, heightField, scrollViewW/2 + 20, heightField);
        _subribeButton.frame = CGRectMake(scrollViewW - scrollViewW/3, heightField, scrollViewW/3, heightField);
        _updateSubribeButton.frame = CGRectMake(scrollViewW - scrollViewW/3, heightField + 10 + heightField, scrollViewW/3, heightField);
        _userIdCancelField.frame = CGRectMake(20, heightField + 20 + heightField + heightField, scrollViewW/2 + 20, heightField);
        _cancelSubribeButton.frame = CGRectMake(scrollViewW - scrollViewW/3, heightField + 20 + heightField + heightField, scrollViewW/3, heightField);
    }
}


#pragma mark - segmented operation
- (UISegmentedControl *)segmentedControlSetting{
    if (nil == _segmentedControlSetting) {
        UIColor *blueColor = [UIColor systemBlueColor];
        UIFont *font = [UIFont systemFontOfSize:12];
        NSMutableDictionary *dic = [[NSMutableDictionary alloc] init];
        [dic setValue:blueColor forKey:NSForegroundColorAttributeName];
        [dic setValue:font forKey:NSFontAttributeName];
        

        _segmentedControlSetting = [[UISegmentedControl alloc]
                                    initWithItems:@[@"音频", @"视频", @"跨房", @"操作", @"消息", @"流控", @"屏幕"]];
//        _segmentedControlSetting.tintColor = [UIColor redColor];
        _segmentedControlSetting.backgroundColor = [UIColor whiteColor];
        _segmentedControlSetting.selectedSegmentIndex = 0;
        _segmentedControlSetting.tintColor = [UIColor systemBlueColor];
        [_segmentedControlSetting addTarget:self action:@selector(changeIndex)
                           forControlEvents:UIControlEventValueChanged];
        [_segmentedControlSetting setTitleTextAttributes:dic forState:UIControlStateNormal];
        
    }
    return _segmentedControlSetting;
}

-(void)changeIndex {
    _nsegmentShownIndex = self.segmentedControlSetting.selectedSegmentIndex;
    UIView *view = [self settingViewAtIndex:_nsegmentShownIndex];
    [self changeIndexToView:view];
    [self setNeedsLayout];
}

- (UIView *)settingViewAtIndex:(NSInteger)index {
    if (self.settingViews.count > index) {
        return [self.settingViews objectAtIndex:index];
    }
    return nil;
}

- (void)changeIndexToView:(UIView *)view {
    if (!view || ![self.settingViews containsObject:view]) return;
    for (UIView *settingView in self.settingViews) {
        settingView.hidden = settingView != view;
    }
}

- (void)textFieldDidEndEditing:(id)sender {
    [self endEditing:YES];
}
- (void)videoSetSwitchChanged:(UISwitch *) sender {
    // TODO: csq enhance
    switch (sender.tag) {
        case kSettingSwitchTagVideoEnhance:
//            [[RTCSettingsModel sharedInstance] storeVideoEnhance:_imageQEswitch.on];
//            if (_imageQEswitch.on) {
////                [self.avVideoEffect applyBeautyBaseVideoFx];
//                [self.avVideoEffect setVideoEnhanceEX:1   contrast:3.003 saturation:0.999];
//                [self.avVideoEffect resetVideoEnhanceEX:YES];
//
//            } else {
////                [self.avVideoEffect disabledBeautyBaseVideoFx];
//                [self.avVideoEffect resetVideoEnhanceEX:NO];
//            }
            break;
        case kSettingSwitchTagSuperResolution:
            [[RTCSettingsModel sharedInstance] storeSuperResolution:_superResolutionSwitch.on];
            if (self.delegate && [self.delegate respondsToSelector:@selector(enableSuperResolution:)]) {
                [self.delegate enableSuperResolution:_superResolutionSwitch.on];
            }
            break;
        case kSettingSwitchTagPushStream:
            [RTCSettingsModel sharedInstance].pushStream = _pushStreamswitch.on;
            if (self.delegate && [self.delegate respondsToSelector:@selector(enableManualPushStream:)]) {
                [self.delegate enableManualPushStream:_pushStreamswitch.on];
            }
            break;
        case kSettingSwitchTagWatermark:
            [[RTCSettingsModel sharedInstance] storeWaterMark:_waterMaskEswitch.on];
            if (self.delegate && [self.delegate respondsToSelector:@selector(enableWatermark:)]) {
                [self.delegate enableWatermark:_waterMaskEswitch.on];
            }
            break;
        case kSettingSwitchTagCameraOrient:
            [[RTCSettingsModel sharedInstance] storeLockCameraOrient:_cameraOrientSwitch.on];
            if (self.delegate && [self.delegate respondsToSelector:@selector(lockCameraOrient:)]) {
                [self.delegate lockCameraOrient:_cameraOrientSwitch.on];
            }
            break;
        case kSettingSwitchTagAudioPlayLoopback:
            // 音乐播放循环，随播控生效，开关时不处理
            break;
        case kSettingSwitchTagAudioIndication:
            [[RTCSettingsModel sharedInstance] storeEnableAudioVolumeIndication:_audioLevelSwitch.on];
            if ([self.delegate respondsToSelector:@selector(enableAudioVolumeIndication:interval:)]) {
                [self.delegate enableAudioVolumeIndication:_audioLevelSwitch.on interval:_audioLevelTextField.text.intValue];
            }
            break;
        default:
            break;
    }
}

- (void)snapshot:(id)sender {
    NSInteger userId = _screenShotTextField.text.integerValue;
    NSLog(@"[Call] snapshot: %ld", userId);
    if ([self.delegate respondsToSelector:@selector(settingPanelSnapshot:)]) {
        [self.delegate settingPanelSnapshot:userId];
    }
}

- (void)changeRecordType:(UIButton *)btn {
    int type = _recordType == 5 ? 2 : 5; // Both, MixBoth
    [self updateRecordTypeText:type];
    if ([self.delegate respondsToSelector:@selector(settingViewRecordTypeDidChange:)]) {
        [self.delegate settingViewRecordTypeDidChange:_recordType];
    }
}

- (void)updateRecordTypeText:(int)type {
    _recordType = type;
    NSString *str = @"";
    switch (type) {
        case 2: str = @"本地录制"; break;
        case 5: str = @"混流录制"; break;
        default: break;
    }
    [_recordTypeButton setTitle:str forState:UIControlStateNormal];
}

- (void)changeRecordMixLayout:(UIButton *)btn {
    [self updateRecordMixLayoutText:(_recordMixLayout + 1) % 3]; // max: tile = 2
    if (self.delegate && [self.delegate respondsToSelector:@selector(settingViewRecordMixLayoutDidChange:)]) {
        [self.delegate settingViewRecordMixLayoutDidChange:_recordMixLayout];
    }
}

- (void)updateRecordMixLayoutText:(int)layout {
    _recordMixLayout = layout;
    NSString *str = @"";
    switch (layout) {
        case 0: str = @"画中画"; break;
        case 1: str = @"主次平铺"; break;
        case 2: str = @"平铺"; break;
        default: break;
    }
    [_recordMixLayoutButton setTitle:str forState:UIControlStateNormal];
}

- (void)startRecord:(UIButton *)btn {
    if (self.mediaRecordState) {
        if (self.delegate && [self.delegate respondsToSelector:@selector(stopRecorderMedia)]) {
            [self.delegate stopRecorderMedia];
        }
    } else {
        if (self.delegate && [self.delegate respondsToSelector:@selector(startRecorderMedia)]) {
            [self.delegate startRecorderMedia];
        }
    }
}

- (void)startPlayer:(UIButton *)btn {
    btn.userInteractionEnabled = NO;
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.5 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        btn.userInteractionEnabled = YES;
    });
    switch (self.audioPlayerState) {
        case 0: // stopped -> playing
            if ([self.delegate respondsToSelector:@selector(startPlayerMediaWithLoopback:cycle:)]) {
                NSUInteger cycle = [_cycleTextField.text intValue];
                [self.delegate startPlayerMediaWithLoopback:_loopbackSwitch.on cycle:cycle];
            }
            self.audioPlayerState = 1;
            break;
        case 1: // playing -> paused
            if ([self.delegate respondsToSelector:@selector(pausePlayerMedia)]) {
                [self.delegate pausePlayerMedia];
            }
            self.audioPlayerState = 2;
            break;
        case 2: // paused -> playing
            if ([self.delegate respondsToSelector:@selector(resumePlayerMedia)]) {
                [self.delegate resumePlayerMedia];
            }
            self.audioPlayerState = 1;
            break;
        default:
            break;
    }
}

- (void)endPlayer:(UIButton *)btn {
    if (self.delegate && [self.delegate respondsToSelector:@selector(stopPlayerMedia)]) {
        [self.delegate stopPlayerMedia];
    }
    // playing -> stopped
    self.audioPlayerState = 0;
}

- (void)setAudioPlayerState:(NSInteger)audioPlayerState {
    _audioPlayerState = audioPlayerState;
    NSString *title = @"播放音乐";
    if (audioPlayerState == 1) title = @"暂停音乐";
    else if (audioPlayerState == 2) title = @"恢复音乐";
    [_startPlayerButton setTitle:title forState:UIControlStateNormal];
}

- (void)multiRoomJoin:(id)sender {
    NSLog(@"multiRoomJoin");
    RelayOperateType rot = RELAY_START;
    if (sender == _callStopButton) {
        rot = RELAY_STOP;
    } else  if (sender == _callStopAllButton) {
        rot = RELAY_STOP_ALL;
    }
    if ([self.delegate
         respondsToSelector:@selector(roomDelayRoomStart:user:relay:)]) {
        NSInteger userRelay = [_suerIdContentField.text intValue];
        [self.delegate roomDelayRoomStart:_roomIdContentField.text user:userRelay relay:rot];
    }
}

//禁言
- (void)shutupAction:(UIButton *)btn {
    if (_userIdShutupField.text.length == 0) return;
    if ([self.delegate respondsToSelector:@selector(shutUpUserWithId:isDisable:)]) {
        [self.delegate shutUpUserWithId:_userIdShutupField.text isDisable:NO];
    }
}

//移出房间
- (void)removeFromRoomAction:(UIButton *)btn {
    if (_userIdShutupField.text.length == 0) return;
    if ([self.delegate respondsToSelector:@selector(kickOffUserWithId:)]) {
        [self.delegate kickOffUserWithId:_userIdShutupField.text];
    }
}

//解除禁言
- (void)shutupOffAction:(UIButton *)btn {
    if (_userIdOperateField.text.length == 0) return;
    if ([self.delegate respondsToSelector:@selector(shutUpUserWithId:isDisable:)]) {
        [self.delegate shutUpUserWithId:_userIdOperateField.text isDisable:YES];
    }
}

//移出房间
- (void)removeFromRoom2Action:(UIButton *)btn {
    if (_userIdOperateField.text.length == 0) return;
    if ([self.delegate respondsToSelector:@selector(kickOffUserWithId:)]) {
        [self.delegate kickOffUserWithId:_userIdOperateField.text];
    }
}

//全部禁言
- (void)shutupAllAction:(UIButton *)btn {
    if ([self.delegate respondsToSelector:@selector(shutupAllUser)]) {
        [self.delegate shutupAllUser];
    }
}

//解散房间
- (void)disbandRoomAction:(UIButton *)btn {
    if ([self.delegate respondsToSelector:@selector(disbandRoom)]) {
        [self.delegate disbandRoom];
    }
}

- (void)speakerStatusAction:(UIButton *)btn {
    if ([self.delegate respondsToSelector:@selector(showSpeakerStatus)]) {
        [self.delegate showSpeakerStatus];
    }
}

- (void)switchRole:(UIButton *)btn {
    if (self.delegate && [self.delegate respondsToSelector:@selector(switchRole)]) {
        [self.delegate switchRole];
    }
}

- (void)sendMessageAction:(UIButton *)btn {
    if ([self.delegate respondsToSelector:@selector(sendMessage:)]) {
        [self.delegate sendMessage:_messageField.text];
    }
}

- (void)sendMessageToUserAction:(UIButton *)btn {
    if ([self.delegate respondsToSelector:@selector(sendMessage:toUser:)]) {
        [self.delegate sendMessage:_userMessageField.text toUser:_userIdMessageField.text];
    }
}

- (void)startStressDataChannelAction:(UIButton *)btn {
    if ([self.delegate respondsToSelector:@selector(sendStressDataChannel:frequency:bps:reliable:)]) {
        _isStartStressDataChannelTest = !_isStartStressDataChannelTest;
        [_sendDataChannelButton setTitle:(_isStartStressDataChannelTest ? @"停止" : @"开始") forState:UIControlStateNormal];
        [self.delegate sendStressDataChannel:_isStartStressDataChannelTest frequency:_sendDataFrequencyField.text.intValue bps:_sendDataKBytesField.text.intValue reliable:_isSendDataReliable];
    }
}

- (void)sendDataReliableAction:(UIButton *)btn {
    _isSendDataReliable = !_isSendDataReliable;
    [_sendDataReliableButton setTitle:(_isSendDataReliable ? @"可靠" : @"不可靠") forState:UIControlStateNormal];
}

- (void)subribeStreamAction:(UIButton *)btn {
    if ([self.delegate respondsToSelector:@selector(subribeStream:)]) {
        [self.delegate subribeStream:_userIdSubribeField.text];
    }
}

- (void)cancelSubribeStreamAction:(UIButton *)btn {
    if ([self.delegate respondsToSelector:@selector(cancelSubribeStream:)]) {
        [self.delegate cancelSubribeStream:_userIdCancelField.text];
    }
}

- (void)updateSubribeStreamAction:(UIButton *)btn {
    if ([self.delegate respondsToSelector:@selector(updateSubribeStream:)]) {
        [self.delegate updateSubribeStream:_userIdSubribeField.text];
    }
}

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField {
    return YES;
}

#pragma mark - RTCCallingSettingScreenViewDelegate

- (void)screenSettingParamsUpdated:(BRTCScreenShareParams *)params {
    if ([self.delegate respondsToSelector:@selector(settingPanelScreenParamsUpdated:)]) {
        [self.delegate settingPanelScreenParamsUpdated:params];
    }
}

- (void)screenSettingSnapshot {
    if ([self.delegate respondsToSelector:@selector(settingPanelScreenSnapshot)]) {
        [self.delegate settingPanelScreenSnapshot];
    }
}

#pragma mark - Create View

- (UIScrollView *)createSettingBaseView {
    UIScrollView *view = [[UIScrollView alloc] initWithFrame:CGRectZero];
    view.layer.masksToBounds = YES;
    view.backgroundColor = [UIColor whiteColor];
    return view;
}

- (UIButton *)newBtnForTitle:(NSString *)title titleColor:(UIColor *)titleColor bgColor:(UIColor *)bgColor {
    return [self newBtnForTitle:title titleColor:titleColor bgColor:bgColor radius:0];
}

- (UIButton *)newBtnForTitle:(NSString *)title
                  titleColor:(UIColor *)titleColor bgColor:(UIColor *)bgColor
                      radius:(CGFloat)radius {
    return [UIButton brtc_buttonWithTitle:title titleColor:titleColor bgColor:bgColor fontSize:14.f cornerRadius:radius];
}

- (UITextField *)generateTextField:(CGRect)rect placeholder:(NSString*)pholder text:(NSString*)context {
    UITextField *textField = [UITextField brtc_textFieldWithPlaceholder:pholder hasBorder:YES];
    textField.delegate = self;
    [textField addDoneButtonWithFrame:CGRectMake(0, 0, self.bounds.size.width, 50) target:self action:@selector(serverSettingTextFieldDidEndEditing:)];
    return textField;
}

- (UITextField *)generateNumberField:(CGRect)rect placeholder:(NSString*)pholder text:(NSString*)context {
    UITextField *textField = [self generateTextField:rect placeholder:pholder text:context];
    textField.keyboardType = UIKeyboardTypeNumberPad;
    return textField;
}

- (UILabel *)generateLabelForTitle:(NSString *)title {
    return [UILabel brtc_labelWithTitle:title color:[UIColor blackColor] fontSize:14.f];
}

- (UISwitch *)generateSwitch:(UIView*)parent tag:(NSInteger)tagStore {
    UISwitch *switchView = [[UISwitch alloc] initWithFrame:CGRectZero];
    switchView.tag = tagStore;
    [switchView addTarget:self
                action:@selector(videoSetSwitchChanged:)
        forControlEvents:UIControlEventValueChanged];
    return switchView;
}

- (void)serverSettingTextFieldDidEndEditing:(id)sender {
    [self endEditing:YES];
}

#pragma mark - property

- (void)setMediaRecordState:(NSInteger)state {
    _mediaRecordState = state;
    dispatch_async(dispatch_get_main_queue(), ^{
        NSString *title = state ? @"结束录制" : @"开始录制";
        [self->_startRecord setTitle:title forState:UIControlStateNormal];
    });
}

@end
