//
//  RTCCallingSettingsPanelView.h
//  rtc_sdk_ios
//
//  Created by zhangyafei02 on 2021/8/8.
//  Copyright © 2021 Sun,Jian(ACU-T102). All rights reserved.
//

#import <UIKit/UIKit.h>
#import "BDCloudRTCBaseDefine.pch"

NS_ASSUME_NONNULL_BEGIN

@class BRTCScreenShareParams;

@protocol SettingPanelViewDelegate<NSObject>
@optional
//called when view need snapshot
- (void)settingPanelSnapshot:(NSInteger)userId;
- (void)settingPanelScreenSnapshot;

//called when room relay
- (void) roomDelayRoomStart:(NSString*)newRoom user:(NSInteger)userId relay:(RelayOperateType) rot;

//called when room relay
- (void) roomDelayRoomEnd:(NSString*)newRoom;

//是否禁言
- (void)shutUpUserWithId:(NSString *)userId isDisable:(BOOL)isDisable;
//移出某人
- (void)kickOffUserWithId:(NSString *)userId;
//全部禁言
- (void)shutupAllUser;
//解散房间
- (void)disbandRoom;
- (void)showSpeakerStatus;

// 角色切换
- (void)switchRole;

- (void)sendMessage:(NSString *)message toUser:(NSString *)userId;
- (void)sendMessage:(NSString *)message;
- (void)sendStressDataChannel:(BOOL)isStart frequency:(int)frequency bps:(int)bps reliable:(BOOL)reliable;

- (void)subribeStream:(NSString *)streamId;
- (void)cancelSubribeStream:(NSString *)streamId;
- (void)updateSubribeStream:(NSString *)streamId;

- (void)enableSuperResolution:(BOOL)enable;
- (void)enableWatermark:(BOOL)enable;
- (void)lockCameraOrient:(BOOL)lock;
- (void)enableManualPushStream:(BOOL)enable;
- (void)settingViewRecordTypeDidChange:(int)type; // BRTCMediaRecorderType
- (void)settingViewRecordMixLayoutDidChange:(int)layout; // BRTCMediaMixType
- (void)startRecorderMedia;
- (void)stopRecorderMedia;

- (void)startPlayerMediaWithLoopback:(BOOL)loopback cycle:(NSUInteger)cycle;
- (void)pausePlayerMedia;
- (void)resumePlayerMedia;
- (void)stopPlayerMedia;

// 屏幕分享参数更新
- (void)settingPanelScreenParamsUpdated:(BRTCScreenShareParams *)params;

- (void)enableAudioVolumeIndication:(BOOL)enable interval:(int)interval;

@end

@interface RTCCallingSettingsPanelView : UIView

@property(nonatomic, weak) id<SettingPanelViewDelegate> delegate;

/// 媒体录制状态，0: idle; 1: recording;
@property (nonatomic, assign) NSInteger mediaRecordState;

- (instancetype)initWithFrame:(CGRect)frame;
- (void)stopScheduler;
@end

NS_ASSUME_NONNULL_END
